package com.jsegov.tddj.services;

import java.util.List;

import com.jsegov.tddj.dao.GHKDAO;
import com.jsegov.tddj.dao.GYQDJKDAO;
import com.jsegov.tddj.services.interf.IGYQDJKService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.GYQDJK;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GyqDjkService implements IGYQDJKService {
	@Autowired
    GYQDJKDAO gyqdjkDAO;
	@Autowired
    GHKDAO ghkDAO;

	public void deleteGYQDJK(String projectId) {
		// TODO Auto-generated method stub
		gyqdjkDAO.deleteGYQDJK(projectId);
	}

	public GYQDJK getGYQDJK(GYQDJK gyqdjk) {
		// TODO Auto-generated method stub
		return gyqdjkDAO.getGYQDJK(gyqdjk);
	}

	public GYQDJK getGYQDJK(String projectId) {
		// TODO Auto-generated method stub
		GYQDJK gyqdjk = new GYQDJK();
		gyqdjk.setProjectId(projectId);
		return gyqdjkDAO.getGYQDJK(gyqdjk);
	}

	public GYQDJK getGYQDJKbyTdzh(String tdzh) {
		// TODO Auto-generated method stub
		GYQDJK gyqdjk = new GYQDJK();
		gyqdjk.setTdzh(tdzh);
		return gyqdjkDAO.getGYQDJK(gyqdjk);
	}

	public void insertGYQDJK(GYQDJK gyqdjk) {
		// TODO Auto-generated method stub
		gyqdjkDAO.insertGYQDJK(gyqdjk);
	}

	public void insertGYQDJK(SPB spb) {
		// TODO Auto-generated method stub
		gyqdjkDAO.insertGYQDJK(getGyqdjkBySpb(spb));
	}

	public void insertGYQDJK(SQB sqb) {
		// TODO Auto-generated method stub
		gyqdjkDAO.insertGYQDJK(getGyqdjkBySqb(sqb));
	}

	public void updateGYQDJK(GYQDJK gyqdjk) {
		// TODO Auto-generated method stub
		gyqdjkDAO.updateGYQDJK(gyqdjk);
	}

	public void updateGYQDJK(SPB spb) {
		// TODO Auto-generated method stub
		gyqdjkDAO.updateGYQDJK(getGyqdjkBySpb(spb));
	}

	public void updateGYQDJK(SQB sqb) {
		// TODO Auto-generated method stub
		gyqdjkDAO.updateGYQDJK(getGyqdjkBySqb(sqb));
	}
	
	public GYQDJK getGyqdjkBySqb(SQB sqb){
		//projectid, rq, djh, zdmj, qlr, dwxz, sfzmtype, sfzmnum, yt, 
		GYQDJK gyqdjk = new GYQDJK();
		gyqdjk.setProjectId(sqb.getProjectId());
		gyqdjk.setRq(CommonUtil.getCurrStrDate());
		gyqdjk.setDjh(sqb.getDjh());
		gyqdjk.setZdmj(sqb.getZdmj());
		String qlr = "";
		String dwxz = "";
		String sfzmtype = "";
		String sfzmnum = "";
//		if (sqb.getRf2_dwmc().equals("")){
			qlr = sqb.getRf1_dwmc();
			dwxz = sqb.getRf1_dwxz();
			sfzmtype = sqb.getRf1_sfzmtype();
			sfzmnum = sqb.getRf1_sfzmnum();
//		}else{
//			qlr = sqb.getRf2_dwmc();
//			dwxz = sqb.getRf2_dwxz();
//			sfzmtype = sqb.getRf2_sfzmtype();
//			sfzmnum = sqb.getRf2_sfzmnum();
//		}
		gyqdjk.setQlr(qlr);
		gyqdjk.setDwxz(dwxz);
		gyqdjk.setSfzmtype(sfzmtype);
		gyqdjk.setSfzmnum(sfzmnum);
		gyqdjk.setYt(sqb.getYt());
		//tdqlmj, dymj, ftmj, qdjg, jzwlx, jzwzdmj, sbjzwqs, spbh, 
		//gyqdjk.setTdqlmj(sqb.getTdqlmj());
		//gyqdjk.setFtmj(sqb.getFtmj());
		gyqdjk.setQdjg(sqb.getQdjg());
		//gyqdjk.setJzwlx(sqb.getJzwlx());
		//gyqdjk.setJzwzdmj(sqb.getJzwzdmj());
		//gyqdjk.setSbjzwqs(sqb.getSbjzwqs());
		gyqdjk.setSpbh(sqb.getSqsbh());
		gyqdjk.setTdzh(sqb.getSqsbh());
		//ghkh, tdzh, jbr, shr, islogout, dwdm
		String ghkh = ghkDAO.getGHK(sqb.getProjectId()).getGhkh();
		gyqdjk.setGhkh(ghkh);
		//gyqdjk.setJbr(sqb.getSjr());
		gyqdjk.setIslogout(0);
		gyqdjk.setDwdm(sqb.getDwdm());
		gyqdjk.setTdzh(sqb.getSqsbh());
		return gyqdjk;
	}
	
	public GYQDJK getGyqdjkBySpb(SPB spb){
		//projectid, rq, djh, zdmj, qlr, dwxz, sfzmtype, sfzmnum, yt, 
		GYQDJK gyqdjk = new GYQDJK();
		gyqdjk.setProjectId(spb.getProjectId());
		gyqdjk.setRq(CommonUtil.getCurrStrDate());
		gyqdjk.setDjh(spb.getDjh());
		gyqdjk.setZdmj(spb.getZdmj());
		String qlr = "";
		String dwxz = "";
		String sfzmtype = "";
		String sfzmnum = "";
		//if (spb.getRf2_dwmc().equals("")){
			qlr = spb.getRf1_dwmc();
			dwxz = spb.getRf1_dwxz();
			sfzmtype = spb.getRf1_sfzmtype();
			sfzmnum = spb.getRf1_sfzmnum();
		//}else{
		//	qlr = spb.getRf2_dwmc();
		//	dwxz = spb.getRf2_dwxz();
		//	sfzmtype = spb.getRf2_sfzmtype();
		//	sfzmnum = spb.getRf2_sfzmnum();
		//}
		gyqdjk.setQlr(qlr);
		gyqdjk.setDwxz(dwxz);
		gyqdjk.setSfzmtype(sfzmtype);
		gyqdjk.setSfzmnum(sfzmnum);
		gyqdjk.setYt(spb.getYt());
		//tdqlmj, dymj, ftmj, qdjg, jzwlx, jzwzdmj, sbjzwqs, spbh, 
		//gyqdjk.setTdqlmj(spb.getTdqlmj());
		gyqdjk.setFtmj(spb.getFtmj());
		gyqdjk.setQdjg(spb.getQdjg());
		gyqdjk.setJzwlx(spb.getJzwlx());
		gyqdjk.setJzwzdmj(spb.getJzwzdmj());
		gyqdjk.setSbjzwqs(spb.getSbjzwqs());
		gyqdjk.setSpbh(spb.getSpbh());
		gyqdjk.setTdzh(spb.getTdzh());
		//ghkh, tdzh, jbr, shr, islogout, dwdm
		String ghkh = ghkDAO.getGHK(spb.getProjectId()).getGhkh();
		gyqdjk.setGhkh(ghkh);
		gyqdjk.setJbr(spb.getScr());
		gyqdjk.setShr(spb.getShr());
		gyqdjk.setIslogout(0);
		gyqdjk.setDwdm(spb.getDwdm());
		return gyqdjk;
	}

	public List<GYQDJK> getGyqDjk(String djh) {
		// TODO Auto-generated method stub
		return gyqdjkDAO.getGyqDjk(djh);
	}
}
