package com.jsegov.tddj.services;

import com.jsegov.tddj.dao.DJFDAO;
import com.jsegov.tddj.services.interf.IDJFService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.DJF;
import com.jsegov.tddj.vo.SPB;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DjfService implements IDJFService {
	@Autowired
    DJFDAO djfDAO;

	public void deleteDJF(String projectId) {
		djfDAO.deleteDJF(projectId);
	}

	public DJF getDJF(String projectId) {
		return djfDAO.getDJF(projectId);
	}

	public void insertDJF(DJF djf) {
		djfDAO.insertDJF(djf);
	}

	public void updateDJF(DJF djf) {
		djfDAO.updateDJF(djf);
	}

	public void insertDJF(SPB spb) {
		String qlr="";
		if (!spb.getRf2_dwmc().equals("")){
			qlr=spb.getRf2_dwmc();
		}else{
			qlr=spb.getRf1_dwmc();
		}
		DJF tempDjf=djfDAO.getDJF(spb.getProjectId());
		if(tempDjf==null){
			tempDjf=new DJF();
			tempDjf.setProjectId(spb.getProjectId());
			tempDjf.setFkdw(qlr);
			tempDjf.setSfmj(spb.getSyqmj());
			tempDjf.setSkrq(CommonUtil.getCurrDate());
			djfDAO.insertDJF(tempDjf);
		}
		else {
			tempDjf.setFkdw(qlr);
			tempDjf.setSfmj(spb.getSyqmj());
			djfDAO.updateDJF(tempDjf);
		}
	}
}
