package com.jsegov.tddj.services;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.dom4j.Document;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.model.impl.File;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.spring.Container;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IArchivesPostService;
import com.jsegov.tddj.services.interf.IGDService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.util.ArchiveModel;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.util.UTF8PostMethod;
import com.jsegov.tddj.vo.GD;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.TXQLZMS;

public class ArchivesPostService implements IArchivesPostService{

    private String fileCenterUrl;	
	private String archiveUrl;
	
	public String ArchivesPost(String projectId) {
		// TODO Auto-generated method stub /gateway.action
		String returnXML = "OK";
		if (archiveUrl!=null && archiveUrl.startsWith("http://")){			
			try {
				String xml1="";
				ISPBService spbService = (ISPBService)Container.getBean("spbService");
				spbService = (ISPBService) Container.getBean("spbService");
				SPB spb = spbService.getSPB(projectId);			
				StringBuffer xml = new StringBuffer();			
				List<String> fileUrlList=new ArrayList<String>(); 
			    try {
			    	String url = "";
			    	NodeService nodeService=(NodeService)Container.getBean("FileCenterNodeServiceImpl");	    	
					//登记系统的文件中心
					Space sourspace = nodeService.getWorkSpace("WORK_FLOW_STUFF",true);
					Node sournode = nodeService.getNode(sourspace.getId(), projectId,true);	
					List<Node> listNode= nodeService.getAllChildNodes(sournode.getId());		
					if (listNode!=null){
						Integer size = listNode.size();				
						for (int j = 0; j < size; j++) {
							try {
								if (listNode.get(j) instanceof File){
									//System.out.println(listNode.get(j).getId());
									url = fileCenterUrl+"/file/get.do?fid="+listNode.get(j).getId();
//									System.out.println(url);
									fileUrlList.add(url);
								}					
							} catch (Exception e) {
								// TODO: handle exception
								System.out.println("附件上传报错！");
								continue;
							}					
						}
					}
				} catch (Exception e) {
					// TODO: handle exception
					e.printStackTrace();
				}
				GYTDSYZ gytdsyzVo = null;
				JTTDSYZ jttdsyzVo = null;
				JTTDSUZ jttdsuzVo = null;
				TXQLZMS txqlzmsVo = null;			
				IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
				IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
				IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
				ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
				
				gytdsyzVo = gytdsyzService.getGYTDSYZ(projectId);			
				jttdsyzVo = jttdsyzService.getJTTDSYZ(projectId);////			
				jttdsuzVo = jttdsuzService.getJTTDSUZ(projectId);			
				txqlzmsVo = txqlzmsService.getTXQLZMS(projectId);	
				String zslx = "";
				if (gytdsyzVo!=null) {//国有					
					Document document = ArchiveModel.CreateGytdsyzXml(gytdsyzVo, spb, fileUrlList);
					xml1 = document.asXML();
					zslx = "gytdsyz";
//					System.out.println(xml1);
				} else if (jttdsyzVo!=null) {//集体使用
					Document document = ArchiveModel.CreateJttdsyzXml(jttdsyzVo, spb,fileUrlList);
					xml1 = document.asXML();			
					zslx = "jttdsyz";
				} else if (jttdsuzVo!=null) {//集体所有				
					Document document = ArchiveModel.CreateJttdsuzXml(jttdsuzVo, spb,fileUrlList);
					xml1 = document.asXML();
					zslx = "jttdsuz";
				} else if (txqlzmsVo!=null) {// 他项					
					Document document = ArchiveModel.CreateTxqlzmsXml(txqlzmsVo, spb,fileUrlList);
					xml1 = document.asXML();
					zslx = "txqlzms";
				}
				HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
				connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
				connectionManager.getParams().setConnectionTimeout(30000);
				connectionManager.getParams().setSoTimeout(30000);
				HttpClient httpClient = new HttpClient(connectionManager);			
				String gdInterface=archiveUrl;
				if(gdInterface!=null && !gdInterface.equals("") && xml1!=null && !xml1.equals("")){
					try{
						UTF8PostMethod utf8=new UTF8PostMethod(gdInterface);
						PostMethod postMethod = utf8;
						NameValuePair[] postData = new NameValuePair[1];
						postData[0] = new NameValuePair("data", xml1);
						postMethod.addParameters(postData);
						httpClient.executeMethod(postMethod);
						String responseXml = postMethod.getResponseBodyAsString();				
						String archiveProjectId=CommonUtil.getArchiveProjectId(responseXml);
						if(archiveProjectId!=null && !archiveProjectId.equals("")){
							GD gd=new GD();
							gd.setProjectId(projectId);
							gd.setGddate(CommonUtil.getCurrStrDate());
								
					        //SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
					        //PfUserVo userVo = userService.getUserByloginName(userId);
					        String username = TddjUtil.getCurrentUserName();
							gd.setUsername(username);
							gd.setZslx(zslx);
							gd.setArchiveProjectId(archiveProjectId);
							IGDService gdService = (IGDService) Container.getBean("gdService");
							GD gdVo=gdService.getGD(projectId);
							if(gdVo!=null){
								gdService.updateGD(gd);
							}else{
								gdService.insertGD(gd);
							}
							postMethod.releaseConnection();
							returnXML = "isOk";
						}else{					
							postMethod.releaseConnection();
							returnXML = CommonUtil.getArchiveMsg(responseXml);
						}
						//zdd 2011-6-13 如果为连接超时 则默认为已经归档
					}catch (SocketTimeoutException eTimeOut){
						eTimeOut.printStackTrace();
						GD gd=new GD();
						gd.setProjectId(projectId);
						gd.setGddate(CommonUtil.getCurrStrDate());
						gd.setZslx(zslx);
						IGDService gdService = (IGDService) Container.getBean("gdService");
						GD gdVo=gdService.getGD(projectId);
						if(gdVo!=null){
							gdService.updateGD(gd);
						}else{
							gdService.insertGD(gd);
						}
						returnXML = "isFail";
					}catch (Exception e){
						e.printStackTrace();					
						returnXML = "isFail";
					}
				}			
			} catch (Exception e) {
				// TODO: handle exception
				e.printStackTrace();
			}
		}				
		return returnXML;
	}

	public String getFileCenterUrl() {
		return fileCenterUrl;
	}

	public void setFileCenterUrl(String fileCenterUrl) {
		this.fileCenterUrl = fileCenterUrl;
	}

	public String getArchiveUrl() {
		return archiveUrl;
	}

	public void setArchiveUrl(String archiveUrl) {
		this.archiveUrl = archiveUrl;
	}

}
