package com.jsegov.tddj.quartz;


import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.IBHService;

public class ReSetBH extends QuartzJobBean {

	private Logger logger = Logger.getLogger(this.getClass().getName()); 
	
	@Override
	protected void executeInternal(JobExecutionContext arg0){
		// TODO Auto-generated method stub
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		//System.out.println(str+"：d-------------------d");
		try{
			IBHService ibhService=(IBHService)Container.getBean("bhService");
			//DROP BH_SQ
			ibhService.dropSq_GYTDSYZID();
			ibhService.dropSq_DJKBHID();
			ibhService.dropSq_FGZBHID();
			ibhService.dropSq_GHKBHID();
			ibhService.dropSq_JTTDSUZBHID();
			ibhService.dropSq_JTTDSYZBHID();
			ibhService.dropSq_SJDBHID();
			ibhService.dropSq_SPBBHID();
			ibhService.dropSq_SQBBHID();
			ibhService.dropSq_TXQLZMSBHID();
			ibhService.dropSq_ZSXL();
			ibhService.dropSq_ZXBHID();
			
			//CREATE BH_SQ
			ibhService.createSq_GYTDSYZID();
			ibhService.createSq_DJKBHID();
			ibhService.createSq_FGZBHID();
			ibhService.createSq_GHKBHID();
			ibhService.createSq_JTTDSUZBHID();
			ibhService.createSq_JTTDSYZBHID();
			ibhService.createSq_SJDBHID();
			ibhService.createSq_SPBBHID();
			ibhService.createSq_SQBBHID();
			ibhService.createSq_TXQLZMSBHID();
			ibhService.createSq_ZSXL();
			ibhService.createSq_ZXBHID();
			
			logger.error(str+"：初始化编号成功！");
		}catch (Exception e) {
			// TODO: handle exception
			logger.error(str+"：初始化编号失败："+e.getMessage());
		}
	}

}
