package com.jsegov.tddj.quartz;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.*;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.*;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

public class DefaultTask extends QuartzJobBean{
	
	private Logger logger = Logger.getLogger(this.getClass().getName());
	
	@Override
	protected void executeInternal(JobExecutionContext arg0)
			throws JobExecutionException {
		// TODO Auto-generated method stub
		/**
		 *  (改动后请修改下列注释)
		 * 	用途：定时任务触发位置,任务写成独立模块在这儿调用

		 * 	参数：无
		 *  最后修改日期：2008-12-08
		 *  修改人：刘仲阳

		 */
		defaultTask_JF();     //2年自动解封 (如果查封结束日期为空)
		defaultTask_JF1();	 	//查封期限满自动解封

		//defaultTask_JCYY();   //15天自动解除异议

		defaultTask_ReSetBH();	//1年自动重置编号

	}

	private void defaultTask_JCYY(){
		/**
		 *  (改动后请修改下列注释)
		 * 	用途：15天自动解除异议

		 * 	参数：无
		 *  最后修改日期：
		 *  修改人：
		 */
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		//System.out.println(str+"==DefaultTask For YYDJ ==================");
		String shrq;
		String sDate;
		sDate=CommonUtil.getCurrStrDate();
		shrq="";
		
		YYDJ yydj=new YYDJ();
		yydj.setIsjc(0);
		try{
			IYYDJService yydjService=(IYYDJService)Container.getBean("yydjService");
			HashMap<String , String> map = new HashMap<String , String>();
			map.put("isjc", "0"); 
			List yydjList=yydjService.getYYDJByIsjc(map);
			if (yydjList==null){
				//System.out.println("yydjList IS NULL!");
			}else{
				System.out.println("未解除数量："+yydjList.size());
				Integer k=0;
				for (int i=0;i<yydjList.size();i++){
					yydj=(YYDJ)yydjList.get(i);
					shrq=yydj.getShrq();
					//System.out.println(shrq);
					String YY = shrq.substring(0,4);
					String MM = shrq.substring(5, 7);
					String DD = shrq.substring(8, 10);
					String sYY = sDate.substring(0,4);
					String sMM = sDate.substring(5, 7);
					String sDD = sDate.substring(8, 10);
					Integer rlt=100;
					Integer addVal=0;
					Integer iYY=Integer.parseInt(YY);
					Integer iMM=Integer.parseInt(MM);
					if (YY.equals(sYY)){   //当前年份大于异议年份直接解除（处理老数据）    
						if (!MM.equals(sMM)){  //当前月份大于异议月份两个月（（处理老数据）
							if ((Integer.parseInt(sMM)-iMM)==1){  //当月份相差一个月
								if (iMM== 1 || iMM== 3 || iMM== 5 ||iMM== 7 ||iMM== 8 ||iMM== 10 ||iMM== 12){
									addVal=31;	
								}else if(iMM== 4|| iMM== 6|| iMM== 9|| iMM== 11){
									addVal=30;
								}else if(iMM== 2){
									if (iYY%100!=0 && iYY%4==0 || iYY%400==0){
										addVal=29;
									}else{
										addVal=28;
									}
								}
								rlt = Integer.parseInt(sDD) + addVal- Integer.parseInt(DD);
							}else if((Integer.parseInt(sMM)-iMM)<0){  //当前月份比异议月份小（异常情况下 不做处理）

								rlt=0;
							}
						}else{  //当月份相同 直接求差
							rlt=Integer.parseInt(sDD)-Integer.parseInt(DD);
						}
					}else if((Integer.parseInt(sYY)-iYY)<0){
						rlt=0;    //当前年份比异议年份小（异常情况下 不做处理）

					}
					if (rlt>15){
							yydj.setIsjc(1);
							yydj.setJcrq(sDate);
							yydjService.updateYYDJ(yydj);
							k=k+1;
							System.out.println("（本次解除）异议的审核日期为："+YY+":"+MM+":"+DD+"||||||||||||今天的日期为："+sYY+":"+sMM+":"+sDD);
						}else{
							System.out.println("（本次未解除）异议的审核日期为："+YY+":"+MM+":"+DD+"||||||||||||今天的日期为："+sYY+":"+sMM+":"+sDD);
						}
					}
				System.out.println("本次任务解除数量："+k);
				}
		}catch (Exception e) {
			// TODO: handle exception
			logger.error(str+"自动解除异议失败"+e.getMessage());
		}	
	}
	
	private void defaultTask_JF(){
		/**
		 *  (改动后请修改下列注释)
		 * 	用途：两年自动解封
		 * 	参数：无
		 *  最后修改日期：2008-12-08
		 *  修改人：刘仲阳

		 */
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		System.out.println(str+" 系统自动解封任务 ");
		String cfrq;
		String sDate;
		sDate=CommonUtil.getCurrStrDate();
		cfrq="";
		String default_jfyy="查封期限已满，系统自动解封。";		
		JF jf=new JF();
		CF cf=new CF();
		Integer isjf = 0;
		try{
			ICFService cfService = (ICFService)Container.getBean("cfService");
			IJFService jfService = (IJFService)Container.getBean("jfService");
			IDJKService djkService = (IDJKService)Container.getBean("djkService");
			IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
			
			List cfList=cfService.getCFByIsjf(isjf);
			if (cfList==null){
				//System.out.println("cfList IS NULL!");
			}else{
				System.out.println("查封数量："+cfList.size());
				Integer k=0;
				for (int i=0;i<cfList.size();i++){
					cf=(CF)cfList.get(i);
					if(cf.getCfjsrq() == null){
						cfrq = CommonUtil.formateDate(cf.getCfksrq());
						//System.out.println(cfrq);
						String YY = cfrq.substring(0,4);
						String MM = cfrq.substring(5, 7);
						String DD = cfrq.substring(8, 10);
						String sYY = sDate.substring(0,4);
						String sMM = sDate.substring(5, 7);
						String sDD = sDate.substring(8, 10);
						Integer rltYY,rltMM,rltDD;
						rltYY=Integer.parseInt(sYY)-Integer.parseInt(YY);
						rltMM=Integer.parseInt(sMM)-Integer.parseInt(MM);
						rltDD=Integer.parseInt(sDD)-Integer.parseInt(DD);
					
						if (rltYY>2 || (rltYY==2 && rltMM>0) || (rltYY==2 && rltMM==0 && rltDD>0)){
							//更新查封状态

							cf.setIsjf(1);
							cfService.updateCF(cf);
							//写查封信息

							jf.setProjectId(UUIDGenerator.generate());
							jf.setCfProjectId(cf.getProjectId());
							jf.setJfyy(default_jfyy);
							jf.setJfr("admin");
							jf.setJfrq(sDate);
							jf.setXbnr("证号："+cf.getTdzh()+"，地号："+cf.getDjh()+"，执行申请认为："+cf.getZxsqr()+
									   "，裁定单位为："+cf.getCddw()+"，查封结束日期为："+CommonUtil.formateDate(cf.getCfjsrq())+"，因"+jf.getJfyy());
							jfService.insertJF(jf);
							//写登记卡续表内容
							DJK djk = djkService.getDJKByDjh(cf.getDjh());
							String djkbh = "";
							Integer djkid = 0;
							if (djk!=null){
								djkbh = djk.getDjkbh();
								djkid = djk.getDjkId();
							}
							DJKXB djkxb = new DJKXB();
							djkxb.setDjkId(djkid);
							djkxb.setProjectId(jf.getProjectId());
							djkxb.setDjh(cf.getDjh());
							djkxb.setRq(CommonUtil.getCurrStrDate());
							djkxb.setDjjs(jf.getXbnr());
							djkxb.setDjkjbr("admin");
							//djkxb.setDjkshr(djkshr);
							djkxb.setDjrq(CommonUtil.getCurrStrDate());
							djkxb.setDwdm("32");
							djkxb.setTdzh(cf.getTdzh());
							djkxb.setIslogout(0);
							djkxb.setIsprinted(0);
							djkxb.setDjkbh(djkbh);
							//djkxb.setBsm();
							//djkxb.setGhkh(ghkh);
							djkxb.setSqlx("解封");
							djkxbService.insertDJKXB(djkxb);
                            //设置下一轮候查封为查封
                            cfService.updateNextLhxf(cf, jf.getProjectId());
							//统计解封数量
							k=k+1;
							//System.out.println("（本次解除）查封的日期为："+YY+":"+MM+":"+DD+"||||||||||||今天的日期为："+sYY+":"+sMM+":"+sDD);
						}else{
							//System.out.println("（本次未解除）查封的日期为："+YY+":"+MM+":"+DD+"||||||||||||今天的日期为："+sYY+":"+sMM+":"+sDD);
						}
					}
				}
			System.out.println("2年期限已满,系统自动解封,解封数量："+k);
			}
		}catch (Exception e) {
			// TODO: handle exception
			logger.error(str+"自动解封任务失败"+e.getMessage());
		}		
	}
	
	private void defaultTask_JF1(){
		/**
		 *  (改动后请修改下列注释)
		 * 	用途：查封期限满自动解封

		 * 	参数：无
		 *  最后修改日期：2008-12-08
		 *  修改人：刘仲阳

		 */
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		//System.out.println(str+"==DefaultTask For JF ====================");
		//String cfrq;
		Date cfksrq = null;
		Date cfjsrq = null;
		Date curDate = CommonUtil.getCurrDate();
		//cfrq="";
		String default_jfyy="查封期限已满，系统自动解封。";		
		JF jf=new JF();
		CF cf=new CF();
		Integer isjf = 0;
		try{
			ICFService cfService = (ICFService)Container.getBean("cfService");
			IJFService jfService = (IJFService)Container.getBean("jfService");
			IDJKService djkService = (IDJKService)Container.getBean("djkService");
			IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
			
			List cfList=cfService.getCFByIsjf(isjf);
			if (cfList==null){
				//System.out.println("cfList IS NULL!");
			}else{
				//System.out.println("未解除数量："+cfList.size());
				Integer k=0;
				for (int i=0;i<cfList.size();i++){
					cf=(CF)cfList.get(i);
					cfjsrq = cf.getCfjsrq();
					if (cfjsrq.equals(curDate) || cfjsrq.compareTo(curDate)<0){
							//更新查封状态

							cf.setIsjf(1);
							cfService.updateCF(cf);
							//写查封信息

							jf.setProjectId(UUIDGenerator.generate());
							jf.setCfProjectId(cf.getProjectId());
							jf.setJfyy(default_jfyy);
							jf.setJfr("admin");
							jf.setJfrq(CommonUtil.formateDate(cf.getCfjsrq()));
							jf.setXbnr("证号："+cf.getTdzh()+"，地号："+cf.getDjh()+"，执行申请认为："+cf.getZxsqr()+
									   "，裁定单位为："+cf.getCddw()+"，查封结束日期为："+CommonUtil.formateDate(cf.getCfjsrq())+"，因"+jf.getJfyy());
							jfService.insertJF(jf);
							//写登记卡续表内容
							DJK djk = djkService.getDJKByDjh(cf.getDjh());
							String djkbh = "";
							Integer djkid = 0;
							if (djk!=null){
								djkbh = djk.getDjkbh();
								djkid = djk.getDjkId();
							}
							DJKXB djkxb = new DJKXB();
							djkxb.setDjkId(djkid);
							djkxb.setProjectId(jf.getProjectId());
							djkxb.setDjh(cf.getDjh());
							djkxb.setRq(CommonUtil.getCurrStrDate());
							djkxb.setDjjs(jf.getXbnr());
							djkxb.setDjkjbr("admin");
							//djkxb.setDjkshr(djkshr);
							djkxb.setDjrq(CommonUtil.getCurrStrDate());
							djkxb.setDwdm("32");
							djkxb.setTdzh(cf.getTdzh());
							djkxb.setIslogout(0);
							djkxb.setIsprinted(0);
							djkxb.setDjkbh(djkbh);
							//djkxb.setBsm();
							//djkxb.setGhkh(ghkh);
							djkxb.setSqlx("解封");
							djkxbService.insertDJKXB(djkxb);
                            //设置下一轮候查封为查封
                            cfService.updateNextLhxf(cf, jf.getProjectId());
							//统计解封数量
							k=k+1;
							//System.out.println("（本次解除）查封的日期为："+YY+":"+MM+":"+DD+"||||||||||||今天的日期为："+sYY+":"+sMM+":"+sDD);
						}else{
							//System.out.println("（本次未解除）查封的日期为："+YY+":"+MM+":"+DD+"||||||||||||今天的日期为："+sYY+":"+sMM+":"+sDD);
						}
					}
				System.out.println("查封期限已满,系统自动解封,解封数量："+k);
				}
		}catch (Exception e) {
			// TODO: handle exception
			logger.error(str+"自动解封任务失败"+e.getMessage());
		}		
	}
	
	private void defaultTask_ReSetBH(){
		/**
		 *  (改动后请修改下列注释)
		 * 	用途：1年自动重置编号

		 * 	参数：无
		 *  最后修改日期：
		 *  修改人：
		 */
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		GregorianCalendar today = new GregorianCalendar();
		String str = sdf.format(today.getTime());
		System.out.println(str+" 系统自动重置编号任务 ");
		try{
			IBHService bhService=(IBHService)Container.getBean("bhService");
		    //获取当前年份
			String sYY = str.substring(0,4);    //当前年份
		    String YY = CommonUtil.getCURRENTYEAR();  //记录年份
			if(YY == null || YY.equals("")){
				YY = sYY;
				CommonUtil.setCURRENTYEAR(YY);
			}
			else if (Integer.parseInt(sYY)>Integer.parseInt(YY)){
				//DROP BH_SQ 删除序列
				bhService.dropSq_GYTDSYZID();
				bhService.dropSq_DJKBHID();
				bhService.dropSq_FGZBHID();
				bhService.dropSq_GHKBHID();
				bhService.dropSq_JTTDSUZBHID();
				bhService.dropSq_JTTDSYZBHID();
				bhService.dropSq_SJDBHID();
				bhService.dropSq_SPBBHID();
				bhService.dropSq_SQBBHID();
				bhService.dropSq_TXQLZMSBHID();
				bhService.dropSq_ZSXL();
				bhService.dropSq_ZXBHID();
				
				//CREATE BH_SQ 创建序列
				bhService.createSq_GYTDSYZID();
				bhService.createSq_DJKBHID();
				bhService.createSq_FGZBHID();
				bhService.createSq_GHKBHID();
				bhService.createSq_JTTDSUZBHID();
				bhService.createSq_JTTDSYZBHID();
				bhService.createSq_SJDBHID();
				bhService.createSq_SPBBHID();
				bhService.createSq_SQBBHID();
				bhService.createSq_TXQLZMSBHID();
				bhService.createSq_ZSXL();
				bhService.createSq_ZXBHID();
		    	
				//更新系统现有编号年份
				YY = sYY;
				CommonUtil.setCURRENTYEAR(YY);
				System.out.println("重置编号成功！");
		    }else{
		    	//如果记录年份小于当前年份
		    	YY = sYY;
				CommonUtil.setCURRENTYEAR(YY);
		    	System.out.println("不需要重置编号！");
		    }
		}catch (Exception e) {
			// TODO: handle exception
			logger.error(str+"：重置编号任务失败："+e.getMessage());
		}
	}
}