package com.jsegov.tddj.platform;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
/**
 * 继承平台的SessionUtil
 * @author Administrator
 *
 */
public class TddjUtil extends SessionUtil{
	public static String getCurrentUserDwdm(){
		SysUserService userService = (SysUserService) Container.getBean("SysUserServiceImpl");        
		String userDwdm = userService.getUserRegionCode(getCurrentUserId());
		return userDwdm;		
	}
	public static String getCurrentUserName(){
		String userName = "";
		try {
			SysUserService userService = (SysUserService) Container.getBean("SysUserServiceImpl");        
			PfUserVo pfUserVo = userService.getUserVo(getCurrentUserId());
			if (pfUserVo!=null)
				userName = pfUserVo.getUserName();
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		return userName;		
	}
	public static String getCurrentUserOrgan() {
		// TODO Auto-generated method stub
		try {
			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");			
			List<PfOrganVo> organList = userService.getOrganListByUser(getCurrentUserId());
			String dwmc = "";
			if(organList!=null && organList.size()>0)
				dwmc = organList.get(0).getOrganName();
			return dwmc;			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			return null;
		}		
	}

	public static List<String> getAllOrgan() {
		// TODO Auto-generated method stub
		try {
			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
			List<PfOrganVo> organList = userService.getOrganList();						
			List<String> list = new ArrayList<String>();
			if(organList!=null){
				PfOrganVo organVo = null;
				for (int i = 0; i < organList.size(); i++) {
					organVo = organList.get(i);
					list.add(organVo.getOrganName());
				}
			}
			return list;
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			return null;
		}		
	}
	public static LinkedHashMap<String,String> getAllOrganToLinkedHashMap() {
		// TODO Auto-generated method stub
		try {
			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
			List<PfOrganVo> organList = userService.getOrganList();						
			LinkedHashMap<String,String> list = new LinkedHashMap<String,String>();
			if(organList!=null){
				PfOrganVo organVo = null;
				for (int i = 0; i < organList.size(); i++) {
					organVo = organList.get(i);
					list.put(organVo.getOrganName(),organVo.getOrganName());
				}
			}
			return list;
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			return null;
		}		
	}
	public static List<String> getAllUser(){
		List<String> list = new ArrayList<String>();
		try {
			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
			List<PfUserVo> listUser = userService.getAllUsers();
			for (PfUserVo pfUserVo : listUser){
				list.add(pfUserVo.getUserName());				
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
		return list;
	}

}
