package com.jsegov.tddj.platform;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.spring.Container;
import com.jsegov.tddj.vo.Project;
import org.springframework.stereotype.Service;

@Service("platUtil")
public class PlatUtil implements IPlatUtil {

	/**
	 * ����������
	 * 
	 * @param project
	 * @param userId
	 * @return taskId
	 */
	public String createWorkFlowInstance(Project project, String userId) {
		String taskId = "";
		try {
			PfWorkFlowInstanceVo wfVO = new PfWorkFlowInstanceVo();
			Date createTime = new Date();
			wfVO.setTimeLimit(getCNQX(project.getWdid())+"");
			wfVO.setCreateTime(createTime);
			wfVO.setWorkflowIntanceId(project.getProjectId());
			wfVO.setWorkflowDefinitionId(project.getWdid());
			wfVO.setProId(project.getProjectId());
			if (project.getDjh()!=null && !project.getDjh().equals("")){
				wfVO.setRemark(project.getDjh()+" || "+project.getTdzl());
			}else{
				wfVO.setRemark(project.getTdzl());
			}
			
			wfVO.setWorkflowIntanceName(project.getQlr());
			wfVO.setCreateUser(userId);
			
			WorkFlowCoreService workFlowCoreService = (WorkFlowCoreService) Container
					.getBean("WorkFlowCoreService");
			WorkFlowInfo workFlowInfo = workFlowCoreService
					.createWorkFlowInstance(wfVO, userId);

			for (PfTaskVo taskVo : workFlowInfo.getTargetTasks()) {
				if (taskVo.getUserVo().getUserId().equals(userId)
						|| userId == taskVo.getUserVo().getUserId()) {
					taskId = taskVo.getTaskId();
					break;
				}
			}
			if (taskId == null || taskId.equals("")) {
				for (PfTaskVo taskVo : workFlowInfo.getTargetTasks()) {
					taskId = taskVo.getTaskId();
					break;
				}
			}
			// taskId = workFlowInfo.getSourceTask().getTaskId();
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("创建工作流实例失败");
		}
		return taskId;
	}

	/**
	 * �޸�ʵ��remark+projectName projectname����Ϊ��
	 * 
	 * @param projectId
	 * @param remark
	 * @param projectName
	 */
	public void editWorkFlowInstance(String projectId, String remark,
			String projectName) {
		SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean("SysWorkFlowInstanceService");
		PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
		if(wfInstanceVo!=null){
			wfInstanceVo.setRemark(remark);
			sysWorkFlowInstanceService.updateWorkFlowInstanceRemark(wfInstanceVo);
			if (!projectName.equals("")) {
				wfInstanceVo.setWorkflowIntanceName(projectName);
				sysWorkFlowInstanceService.updateWorkFlowIntanceName(wfInstanceVo);
			}
		}
	}

	/**
	 * �޸�ʵ�����
	 * 
	 * @param projectId
	 * @param projectName
	 */
	public void editWorkFlowInstanceName(String projectId, String projectName) {
		SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean("SysWorkFlowInstanceService");
		PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
		wfInstanceVo.setWorkflowIntanceName(projectName);
		sysWorkFlowInstanceService.updateWorkFlowIntanceName(wfInstanceVo);
	}

	
	public String getActivityDesc(String projectId, String activityId) {
		SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean("SysWorkFlowInstanceService");
		Document document = null;
		try {
			document =DocumentHelper.parseText(sysWorkFlowInstanceService.getWorkflowInstanceXml(projectId));
		} catch (DocumentException e) {
			e.printStackTrace();
		}
		Element root = document.getRootElement();
		Node node1 = root.selectSingleNode("//Package/WorkflowProcesses/WorkflowProcess/Activities/Activity[@Id='"+activityId+"']/Description");
		String activityDesc = node1.getText();
		if(activityDesc!=null){
			return activityDesc;
		} else {
			SysTaskService sysTaskService = (SysTaskService)Container.getBean("SysTaskService");
			PfActivityVo pfActivityVo = sysTaskService.getActivity(activityId);
			if (pfActivityVo != null) {
				activityDesc = pfActivityVo.getActivityName();
			}
			return activityDesc;
		}
	}

	/**
	 * ��ȡ��ŵ����(��Ŀʱ��)
	 * 
	 * @param wdid
	 * @return
	 */
	public int getCNQX(String wdid) {
		SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean("SysWorkFlowDefineService");
		PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
		int cnqx =0;
		if(StringUtils.isNotBlank(wfDefineVo.getTimeLimit()))
			cnqx = Integer.parseInt(wfDefineVo.getTimeLimit());
		return cnqx;
	}


    public String getPfActivityIdByTaskId(String taskId) {
        SysTaskService sysTaskService = (SysTaskService)Container.getBean("SysTaskService");
        String activitId = "";
        if (taskId!=null && !taskId.equals("")){
            PfTaskVo pfTask=sysTaskService.getTask(taskId);
            if(pfTask!=null){
                activitId = pfTask.getActivityId();

            }
        }
        return activitId;
    }

	/**
	 * ���taskid��ȡ�ʵ�����
	 * 
	 * @param taskId
	 * @return activityName
	 */
	public String getPfActivityNameByTaskId(String taskId) {
		SysTaskService sysTaskService = (SysTaskService)Container.getBean("SysTaskService");
		String activityName = "";
		if (taskId!=null && !taskId.equals("")){
			PfTaskVo pfTask=sysTaskService.getTask(taskId);
			if(pfTask!=null){
				String activitId = pfTask.getActivityId();
				PfActivityVo pfActivityVo = sysTaskService.getActivity(activitId);
				if (pfActivityVo != null) {
					activityName = pfActivityVo.getActivityName();
				}
			}
		}		
		return activityName;
	}

	/**
	 * ��ȡʵ��ʱ��
	 * 
	 * @param wdid
	 * @return
	 */
	public int getTimeLimit(String wdid) {
		SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean("SysWorkFlowDefineService");
		PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
		int limit=0;
		if(StringUtils.isNotBlank(wfDefineVo.getTimeLimit()))
			limit= Integer.parseInt(wfDefineVo.getTimeLimit());
		return limit;
	}
	
	/**
	 * ��ȡʵ��remark ͨ��projectId
	 * 
	 * @param projectId
	 * @return
	 */
	public String getWfRemarkByProjectId(String projectId) {
		SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean("SysWorkFlowInstanceService");
		SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean("SysWorkFlowDefineService");
		PfWorkFlowInstanceVo wfInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(projectId);
		PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wfInstanceVo.getWorkflowDefinitionId());
		String wfRemark = wfDefineVo.getRemark();
		if (wfRemark == null) {
			wfRemark = "";
		}
		return wfRemark;
	}

	/**
	 * ͨ����������ID(Wdid) ��ȡ�����������remark 
	 * 
	 * @param wdid
	 * @return
	 */
	public String getWfRemarkByWdid(String wdid) {
		// TODO Auto-generated method stub
		SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean("SysWorkFlowDefineService");
		PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
		String wfRemark = wfDefineVo.getRemark();
		if (wfRemark == null) {
			wfRemark = "";
		}
		return wfRemark;
	}

    public String getOrganByUser(String userId) {
   		// TODO Auto-generated method stub
   		try {
   			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
   			List<PfOrganVo> organList = userService.getOrganListByUser(userId);
   			String dwmc = "";
   			if(organList!=null && organList.size()>0)
   				dwmc = organList.get(0).getOrganName();
   			return dwmc;
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   			return null;
   		}
   	}

   	public List<String> getAllOrgan() {
   		// TODO Auto-generated method stub
   		try {
   			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
   			List<PfOrganVo> organList = userService.getOrganList();
   			List<String> list = new ArrayList<String>();
   			if(organList!=null){
   				PfOrganVo organVo = null;
   				for (int i = 0; i < organList.size(); i++) {
   					organVo = organList.get(i);
   					list.add(organVo.getOrganName());
   				}
   			}
   			return list;
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   			return null;
   		}
   	}
   	public List<String> getAllUser(){
   		List<String> list = new ArrayList<String>();
   		try {
   			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
   			List<PfUserVo> listUser = userService.getAllUsers();
   			for (PfUserVo pfUserVo : listUser){
   				list.add(pfUserVo.getUserName());
   			}
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   		}
   		return list;
   	}
   	public void updateGlobalVal(String projectId, String GobalValName, Object value){
   	    try{
   	      SysWorkFlowInstanceService sysWorkFlowInstanceService = (SysWorkFlowInstanceService)Container.getBean("SysWorkFlowInstanceService");
   	      sysWorkFlowInstanceService.updateGobalVal(projectId, GobalValName, value);
   	    }catch (Exception e) {
   	      e.printStackTrace();
   	    }
   	}
   	public List<String> getFileId(String projectId, String desc) {
   		// TODO Auto-generated method stub
   		List<String> listID = new ArrayList<String>();
   		try {
   			if (projectId!=null && desc!=null && !projectId.equals("")){
   				List<com.gtis.fileCenter.model.Node> list = getProjectNode(projectId);
   				for (com.gtis.fileCenter.model.Node node:list){
   					//zdd 一个收件项目多张附件  名称后面自动加数
   					if (node.getDescription()!=null && (node.getDescription().equals(desc) || (node.getDescription().startsWith(desc) && node.getDescription().length()-1==desc.length())))
   						listID.add(node.getId().toString());
   				}
   			}
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   		}
   		return listID;
   	}
   	public List<String> getFileId(String projectId) {
   		// TODO Auto-generated method stub
   		List<String> listID = new ArrayList<String>();
   		try {
   			if (projectId!=null && !projectId.equals("")){
   				List<com.gtis.fileCenter.model.Node> list = getProjectNode(projectId);
   				for (com.gtis.fileCenter.model.Node node:list){
   					listID.add(node.getId().toString());
   				}
   			}
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   		}
   		return listID;
   	}
   	private List<com.gtis.fileCenter.model.Node> getProjectNode(String projectId){
   		NodeService nodeService = (NodeService)Container.getBean("FileCenterNodeServiceImpl");
   		Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
   		com.gtis.fileCenter.model.Node tempNode = createFileFolder(space.getId(), projectId);
   		List<com.gtis.fileCenter.model.Node> list = nodeService.getAllChildNodes(tempNode.getId());
   		return list;
   	}
   	private void deleteFiLeNode(String nodeName){
   		NodeService nodeService = (NodeService)Container.getBean("FileCenterNodeServiceImpl");
   		Space space = nodeService.getWorkSpace("WORK_FLOW_STUFF");
   		com.gtis.fileCenter.model.Node tempNode = nodeService.getChildNode(space.getId(), nodeName);
   		if (tempNode!=null && tempNode.getId()!=null)
   			nodeService.remove(tempNode.getId());
   		List<com.gtis.fileCenter.model.Node> list = nodeService.getAllChildNodes(tempNode.getId());


   	}
   	private com.gtis.fileCenter.model.Node createFileFolder(Integer parentId,String folderNodeName){
       	com.gtis.fileCenter.model.Node tempNode = null;
       	NodeService nodeService = (NodeService)Container.getBean("FileCenterNodeServiceImpl");
       	try{
       		tempNode = nodeService.getNode(parentId, folderNodeName,true);
       	}catch(NodeNotFoundException e){
   //    		tempNode = new com.gtis.fileCenter.model.Node();
   //    		tempNode.setName(folderNodeName);
   //    		tempNode.setParentId(parentId);
   //    		tempNode = nodeService.save(tempNode);
       		e.printStackTrace();
       	}
       	return tempNode;
   	}
   	public void saveNodeDesc(Integer fileId,String desc){
   		try {
   			NodeService nodeService = (NodeService)Container.getBean("FileCenterNodeServiceImpl");
   			com.gtis.fileCenter.model.Node node = nodeService.getNode(fileId);
   			if (node!=null && (node.getDescription()==null || node.getDescription().equals(""))){
   				node.setName(desc+node.getName().substring(node.getName().indexOf("."), node.getName().length()));
   				node.setDescription(desc);
   				nodeService.save(node);
   			}
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   		}
   	}
   	public void removeFile(Integer fileId){
   		try {
   			NodeService nodeService = (NodeService)Container.getBean("FileCenterNodeServiceImpl");
   			nodeService.remove(fileId);
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   		}
   	}

   	public List<PfWorkFlowDefineVo> getWorkFlowDefine() {
   		// TODO Auto-generated method stub
   		SysWorkFlowDefineService SysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean("SysWorkFlowDefineService");
   		return SysWorkFlowDefineService.getWorkFlowDefineList();
   	}
   	public List<PfBusinessVo> getBusinessVo() {
   		// TODO Auto-generated method stub
   		SysWorkFlowDefineService SysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean("SysWorkFlowDefineService");
   		return SysWorkFlowDefineService.getBusinessList();
   	}
   	public List<String> getSystemResrouceFunAuthorList(String userId, String rid) {
   		// TODO Auto-generated method stub
   		List<String> list = new ArrayList<String>();
   		try {
   			SysAuthorService authorService = (SysAuthorService)Container.getBean("SysAuthorServiceImpl");
   			SysUserService userService = (SysUserService) Container.getBean("SysUserServiceImpl");
   			List<PfRoleVo> listRoleVo = userService.getRoleListByUser(userId);
   			String roles = "";
   			for (PfRoleVo pfRoleVo:listRoleVo) {
   				if (!roles.equals("")){
   					roles = roles +","+"'"+pfRoleVo.getRoleId()+"'";
   				}else{
   					roles = "'"+pfRoleVo.getRoleId()+"'";
   				}
   			}
   			List<PfPartitionInfoVo> lstfPartitions = authorService.getSystemResrouceFunAuthorList(roles, rid);
               if (lstfPartitions != null) {
                   for (PfPartitionInfoVo partitionInfoVo : lstfPartitions) {
                       list.add(partitionInfoVo.getElementName());
                   }
               }
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   		}
   		return list;
   	}

   	public String getOrganManger(String userId) {
   		// TODO Auto-generated method stub
   		String userName = "";
   		try {
   			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
   			List<PfOrganVo> organList = userService.getOrganListByUser(userId);
   			List<PfUserVo> list = userService.getUserListByOragn(organList.get(0).getOrganId());
   			PfUserVo userVo = null;
   			for (int i = 0; i < list.size(); i++) {
   				userVo = list.get(i);
   				if (userVo!=null && userVo.getUserPost()!=null && userVo.getUserPost().equals("科长")){
   					userName = userVo.getUserName();
   					break;
   				}
   			}
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   		}
   		return userName;
   	}

   	/**
   	 * 通过wdid获取PfWorkFlowDefineVo
   	 * lcj新增
   	 */
   	public PfWorkFlowDefineVo getPfWorkFlowDefineVo(String wdid){
   			SysWorkFlowDefineService sysWorkFlowDefineService = (SysWorkFlowDefineService)Container.getBean("SysWorkFlowDefineService");
   			PfWorkFlowDefineVo wfDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
   			return wfDefineVo;
   		}
   	/**
   	 * 根据用户获取部门信息(如果一个用户在多个部门取第一个部门)
   	 * @param userId
   	 * @return
   	 */
   	public PfOrganVo getOrganByUserId(String userId) {
   		// TODO Auto-generated method stub
   		try {
   			SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
   			List<PfOrganVo> organList = userService.getOrganListByUser(userId);
   			PfOrganVo pfOrganVo=null;
   			if(organList!=null && organList.size()>0)
   				pfOrganVo = organList.get(0);
   			return pfOrganVo;
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   			return null;
   		}
   	}
   	/**
   	 * 根据用户id和角色id获取同一部门的所有用户名称
   	 * @param userId
   	 * @return
   	 */
   	public List<String> getUserNameInOrganByUserId(String userId) {
   		// TODO Auto-generated method stub
   		try {
   			List<String> userNameInOrgan=new ArrayList<String>();
   			if(StringUtils.isNotEmpty(userId)){
   				PfOrganVo organVo=getOrganByUserId(userId);
   				SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
   				if(organVo!=null && StringUtils.isNotEmpty(organVo.getOrganName())){
   					List<PfUserVo> lstUser=userService.getUsersByOrganName(organVo.getOrganName());
   					for(PfUserVo pfUserVo : lstUser){
   						if(pfUserVo!=null && StringUtils.isNotEmpty(pfUserVo.getUserName())){
   							userNameInOrgan.add(pfUserVo.getUserName());
   						}
   					}
   				}
   			}
   			return userNameInOrgan;
   		} catch (Exception e) {
   			e.printStackTrace();
   			return null;
   		}
   	}
   	/**
   	 * 根据用户id获取所有角色
   	 * @param userId
   	 * @return
   	 */
   	public List<PfRoleVo> getRoleListByUser(String userId) {
   		SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
   		return userService.getRoleListByUser(userId);
   	}
   	/**
   	 * 根据用户id获取用户信息
   	 * @param userId
   	 * @return
   	 */
   	public PfUserVo getUserVo(String userId) {
   		SysUserService userService=(SysUserService)Container.getBean("SysUserServiceImpl");
   		return userService.getUserVo(userId);
   	}
   	/**
   	 * 编辑文件描述和姓名
   	 * @param fileId
   	 * @param desc
   	 * @param projectId
   	 */
   	public void saveNodeDescByProjectId(Integer fileId,String desc,String projectId){
   		try {
   			NodeService nodeService = (NodeService)Container.getBean("FileCenterNodeServiceImpl");
   			com.gtis.fileCenter.model.Node node = nodeService.getNode(fileId);
   			if (node!=null && (node.getDescription()==null || node.getDescription().equals(""))){
   				List<String> nodeList=getFileId(projectId, desc);
   				if(nodeList.size()>0){
   					desc=desc+nodeList.size();
   				}
   				node.setName(desc+node.getName().substring(node.getName().indexOf("."), node.getName().length()));
   				node.setDescription(desc);
   				nodeService.save(node);
   			}
   		} catch (Exception e) {
   			// TODO: handle exception
   			e.printStackTrace();
   		}
   	}
}
