package com.jsegov.tddj.fileUpload;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Hashtable;

public class UploadActivityManager {

	public final static int LOG_TYPE_INFO =  0;
	public final static int LOG_TYPE_WARN =  1;
	public final static int LOG_TYPE_ERROR = 2;
	
	private Hashtable<String, UploadActivity> uploadStatusMap = new Hashtable<String, UploadActivity>();

	
	private static UploadActivityManager hInstance = null;

	private UploadActivityManager() {
	}
	
	public static UploadActivityManager getInstance(){
		if (hInstance == null) {
			hInstance = new UploadActivityManager();
		}
		return hInstance;
	}
	
	/**
	 * 获取上载状态

	 * @param uploadId
	 * @return
	 */
	public UploadActivity queryUploadActivity(String uploadId) throws Exception{
		UploadActivity tempUploadActivity = uploadStatusMap.get(uploadId);
		if (tempUploadActivity==null){
			throw new Exception("无法获取到uploadId="+uploadId+"的上载活动");
		}
		return tempUploadActivity;
	}
	
	/**
	 * 注册上载活动
	 * @param uploadId
	 * @param uploadInfo
	 * @param progress
	 */
	public void registerUploadActivity(String uploadId, int status,
			int progress) {
		if (uploadId == null){
			return;
		}
		if (progress > 100){
			progress = 100;
		}
		if (progress< 0){
			progress = 0;
		}
		UploadActivity tempUploadActivity = new UploadActivity();
		tempUploadActivity.setUploadId(uploadId);
		tempUploadActivity.setStatus(status);
		tempUploadActivity.setProgress(progress);
		tempUploadActivity.setRegisterTime(Calendar.getInstance().getTimeInMillis());
		uploadStatusMap.put(uploadId, tempUploadActivity);
	}
	
	public void updateUploadActivity(String uploadId,int status,int progress,String message){
		if (uploadId == null){
			return;
		}
		UploadActivity tempUploadActivity = uploadStatusMap.get(uploadId);
		tempUploadActivity.setUploadId(uploadId);
		tempUploadActivity.setStatus(status);
		tempUploadActivity.setProgress(progress);
		tempUploadActivity.setMessage(message);
	}
	
	/**
	 * 解除注册
	 * @param uploadId
	 */
	public void unRegisterUploadActivity(String uploadId){
		uploadStatusMap.remove(uploadId);
	}
	
	public void writeLog(String uploadId,int logType, String logInfo ) throws Exception{
		if (uploadId == null || uploadId.trim().length() == 0
				|| logInfo == null || logInfo.trim().length() == 0) {
			throw new Exception("无法获取到对应的上载活动，uploadId为空！");
		}
		UploadActivity tempUploadActivity =  queryUploadActivity(uploadId);
		StringBuffer tempLogBuf = tempUploadActivity.getLogBuf();

		switch(logType){
		case UploadActivityManager.LOG_TYPE_INFO:
			tempLogBuf.append("\r\n[INFO] ");
			tempLogBuf.append(logInfo.toString());
			break;
		case UploadActivityManager.LOG_TYPE_WARN:
			tempLogBuf.append("\r\n[WARN] ");
			tempLogBuf.append(logInfo.toString());
			break;
		case UploadActivityManager.LOG_TYPE_ERROR:
			tempLogBuf.append("\r\n[ERROR] ");
			tempLogBuf.append(logInfo.toString());
			break;
		default:
			tempLogBuf.append("\r\n[INFO] ");
			tempLogBuf.append(logInfo.toString());
			break;
		}
	}
	
	public String getLog(String uploadId) throws Exception{
		UploadActivity tempUploadActivity =  queryUploadActivity(uploadId);
		StringBuffer tempLogBuf = tempUploadActivity.getLogBuf();
		if (tempLogBuf == null){
			return "";
		}	
		return tempLogBuf.toString();
	}
	
	
	public String logToFile(String uploadId) throws Exception{
		
		UploadActivity tempUploadActivity =  queryUploadActivity(uploadId);
		String logUrl = "";
		String log = getLog(uploadId);
		if (log == null || log.trim().length()==0){
			return logUrl;
		}
    	String curClassDir = this.getClass().getResource("").getPath();
		String destDir = curClassDir.substring(0,curClassDir.indexOf("WEB-INF"));
		destDir = destDir +"\\temp\\log\\";
		File logDirFile = new File(destDir);
		if (!logDirFile.exists()){
			logDirFile.mkdir();
		}
		
		destDir = destDir +uploadId+".log";
		File file = new File(destDir);
//		FileOutputStream fos;
		try {
//			fos = new FileOutputStream(file);
//			DataOutputStream  dos=new DataOutputStream(fos);
//			dos.writeChars(log);
//			dos.flush();
//			dos.close();
//			fos.flush();
//			fos.close();
			
			Writer   out   =   new   BufferedWriter(new   OutputStreamWriter(new   FileOutputStream(destDir),"GBK"));  
			out.write(log);  
			out.close();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		tempUploadActivity.setLogFilePath(destDir);
		return destDir;
	}
	//清空导入map里存放的数据
	public void clearDataResult(){
		uploadStatusMap.clear();
	}
}
