package com.jsegov.tddj.fileUpload;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

import com.jsegov.tddj.vo.BWDVo;
import com.jsegov.tddj.vo.ChangeInfoVo;
import com.jsegov.tddj.vo.PntCoordVo;
import com.jsegov.tddj.vo.ProjInfoVo;


/**
 * 本类主要是用来存放导入文件解析后的成果

 * @author Administrator
 *
 */
public class DataParseResult {
	private String regionCode = "";
	private BWDVo bwdVo;
	private LinkedHashMap<String,ProjInfoVo> projInfoMap = new LinkedHashMap<String,ProjInfoVo>();
	private LinkedHashMap<String, List<ChangeInfoVo>> changeInfoMap = new LinkedHashMap<String, List<ChangeInfoVo>>();
	private LinkedHashMap<String, List<PntCoordVo>> pndCoordMap = new LinkedHashMap<String, List<PntCoordVo>>();

	private LinkedHashMap<String,List<String>> filePathListMap = new LinkedHashMap<String,List<String>>();
	
	
	public LinkedHashMap<String, ProjInfoVo> getProjInfoMap() {
		return projInfoMap;
	}

	public LinkedHashMap<String, List<ChangeInfoVo>> getChangeInfoMap() {
		return changeInfoMap;
	}

	public LinkedHashMap<String, List<PntCoordVo>> getPndCoordMap() {
		return pndCoordMap;
	}
	
	public  LinkedHashMap<String,List<String>> getFilePathListMap(){
		return filePathListMap;
	}
	
	public List<ProjInfoVo> getProjInfoVoList(){
		List<ProjInfoVo> projInfoVoList = new Vector<ProjInfoVo>();
		Iterator projInfoIter = projInfoMap.values().iterator();
		while(projInfoIter.hasNext()){
			projInfoVoList.add((ProjInfoVo)projInfoIter.next());
		}
		return projInfoVoList;
	}
	
	
	public List<ChangeInfoVo> getChangeInfoVoList(){
		List<ChangeInfoVo> changeInfoVoList= new Vector<ChangeInfoVo>();
		Iterator  changeInfoVoIter = changeInfoMap.values().iterator();
		while(changeInfoVoIter.hasNext()){
			changeInfoVoList.addAll((List<ChangeInfoVo>)changeInfoVoIter.next());
		}
		return changeInfoVoList;
	}
		
	public List<PntCoordVo> getPntCoordVoList(){
		List<PntCoordVo>  pntCoordVoList= new Vector<PntCoordVo>();
		Iterator  pntCoordVoIter = pndCoordMap.values().iterator();
		while(pntCoordVoIter.hasNext()){
			pntCoordVoList.addAll((List<PntCoordVo>)pntCoordVoIter.next());
		}
		return pntCoordVoList;
	}
	/**
	 * 清空result中的数据集

	 */
	public void clearDataResult(){
		projInfoMap.clear();
		changeInfoMap.clear();
		pndCoordMap.clear();
		filePathListMap.clear();
	}

	public String getRegionCode() {
		return regionCode;
	}

	public void setRegionCode(String regionCode) {
		this.regionCode = regionCode;
	}

	public BWDVo getBwdVo() {
		return bwdVo;
	}

	public void setBwdVo(BWDVo bwdVo) {
		this.bwdVo = bwdVo;
	}
}
