package com.jsegov.tddj.dao;

import java.util.List;
import java.util.Map;

import com.gtis.spring.ChildOf;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.jsegov.tddj.vo.ZDDZB;
import org.springframework.stereotype.Service;

@Service("zddzbDAO")
@ChildOf(parent = "ibatisBaseDaoNoPage")
public class ZDDZBDAO extends SqlMapClientDaoSupport {
    public List<ZDDZB> selectNewDjhFromZddzb(String olddjh) {
        return (List<ZDDZB>) getSqlMapClientTemplate().queryForList("selectNewFromZddzb", olddjh);
    }
    public List<ZDDZB> selectOldDjhFromZddzb(String olddjh) {
        return (List<ZDDZB>) getSqlMapClientTemplate().queryForList("selectOldFromZddzb", olddjh);
    }

    /**
     * 根据地籍号找出所有的变更过的地籍号
     */
    public List<ZDDZB> selectAllDjh(String djh) {
        return (List<ZDDZB>) getSqlMapClientTemplate().queryForList("selectAllDjh", djh);
    }

    public ZDDZB selectZDDZB(Map map) {
        return (ZDDZB) getSqlMapClientTemplate().queryForObject("queryZDDZB", map);
    }

    public void updateZDDZB(ZDDZB zddzb) {
        getSqlMapClientTemplate().update("updateZddzb", zddzb);
    }

    public void insertZDDZB(ZDDZB zddzb) {
        getSqlMapClientTemplate().insert("insertZddzb", zddzb);
    }

    public void deleteZDDZB(String id) {
        getSqlMapClientTemplate().delete("deleteZddzbById", id);
    }
}
