package com.jsegov.tddj.dao;

import com.gtis.spring.ChildOf;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import com.jsegov.tddj.vo.Project;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;


@Service
@ChildOf(parent = "ibatisBaseDaoNoPage")
public class ProjectDAO extends SqlMapClientDaoSupport{

	public void insertProject(Project project) {
		getSqlMapClientTemplate().insert("insertProject", project);
	}

	public void deleteProject(String projectId) {
		getSqlMapClientTemplate().delete("deleteProjectById", projectId);
	}

	public Project getProject(String projectId) {
		Project project=(Project)getSqlMapClientTemplate().queryForObject("selectProjectById", projectId);
		return project;
	}

	public void updateProject(Project project) {
		getSqlMapClientTemplate().update("updateProject", project);
	}
    //历史数据导入，查询Project
    public List<Project> queryProject(String startdate,String enddate) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startdate",startdate);
        map.put("enddate",enddate);
        List<Project> project=null;
            project=(List<Project>)getSqlMapClientTemplate().queryForList("queryProjectByTime", map);
        return project;
    }

}
