package com.jsegov.tddj.dao;

import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import com.jsegov.tddj.vo.CF;

public class CFDAO extends SqlMapClientDaoSupport {

    /**
     * 按土地证书查封
     *
     * @param cf
     * @return
     */
    public List CfListByTdzs(CF cf) {
        List list = null;
        if (StringUtils.isNotBlank(cf.getTdzh())) {
            CF queryCF = new CF();
            queryCF.setIsjf(0);
            queryCF.setTdzh(cf.getTdzh());
            list = getSqlMapClientTemplate().queryForList("selectCF", queryCF);
        }
        return list;
    }

    /**
     * 按土地证书查封
     *
     * @param Tdzh
     * @return
     */
    public List CfListByTdzs(String Tdzh) {
        List list = null;
        if (StringUtils.isNotBlank(Tdzh)) {
            CF queryCF = new CF();
            queryCF.setIsjf(0);
            queryCF.setTdzh(Tdzh);
            list = getSqlMapClientTemplate().queryForList("selectCF", queryCF);
        }
        return list;
    }

    /**
     * 按宗地查封
     *
     * @param cf
     * @return
     */
    public List CfListByZd(CF cf) {
        List list = null;
        if (StringUtils.isNotBlank(cf.getDjh()) || StringUtils.isNotBlank(cf.getZl())) {
            CF queryCF = new CF();
            queryCF.setCflx("按宗查封");
            queryCF.setIsjf(cf.getIsjf());
            queryCF.setDjh(cf.getDjh());
            queryCF.setZl(cf.getZl());
            list = getSqlMapClientTemplate().queryForList("selectCF", queryCF);
        }
        return list;
    }

    /**
     * 预查封
     *
     * @param cf
     * @return
     */
    public List YCfListByZd(CF cf) {
        List list = null;
        if (StringUtils.isNotBlank(cf.getDjh()) || StringUtils.isNotBlank(cf.getZl())) {
            CF queryCF = new CF();
            queryCF.setCflx("预查封");
            queryCF.setIsjf(cf.getIsjf());
            queryCF.setZl(cf.getZl());
            queryCF.setBzxr(cf.getBzxr());
            list = getSqlMapClientTemplate().queryForList("selectCF", queryCF);
        }
        return list;
    }

    public String isCF(CF cf) {
        String returnMessage = "";
        List cfListByTdzs = CfListByTdzs(cf);

        //按证查封
        if (cfListByTdzs != null && cfListByTdzs.size() > 0) {
            return returnMessage = "该证书已被查封！";
        }

        List cfListByZd = CfListByZd(cf);
        if (cfListByZd != null && cfListByZd.size() > 0) {
            return returnMessage = "该宗地已被查封！";
        }

        List yCfListByZd = YCfListByZd(cf);
        if (yCfListByZd != null && yCfListByZd.size() > 0) {
            return returnMessage = "该宗地已被预查封！";
        }

        return returnMessage;
    }

    public void deleteCF(String projectId) {
        getSqlMapClientTemplate().delete("deleteCFById", projectId);
    }

    public void insertCF(CF cf) {
        getSqlMapClientTemplate().insert("insertCF", cf);
    }

    public void updateCF(CF cf) {
        getSqlMapClientTemplate().update("updateCF", cf);
    }

    public CF getCF(String projectId) {
        return (CF) getSqlMapClientTemplate().queryForObject(
                "selectCFByProjectId", projectId);
    }

    public List getCF(CF cf) {
        return getSqlMapClientTemplate().queryForList("selectCF", cf);
    }

    public List<Object> expCf(HashMap<String, Object> map) {
        return getSqlMapClientTemplate().queryForList("queryCF", map);
    }

    public List<CF> queryCfList(HashMap<String, Object> map) {
        // TODO Auto-generated method stub
        return (List<CF>) getSqlMapClientTemplate().queryForList("queryCF", map);
    }
    // public String isCF(CF cf) {
    // String returnMessage = "";
    // CF queryResultCF = null;
    // CF queryCF = new CF();
    // //System.out.println(cf.getDjh());
    // if (!cf.getTdzh().equals("")){
    // //queryCF.setCflx("按证查封");
    // System.out.println(cf.getTdzh()+"---cf.getDjh()");
    // queryCF.setIsjf(0);
    // queryCF.setTdzh(cf.getTdzh());
    // queryResultCF =
    // (CF)getSqlMapClientTemplate().queryForObject("selectCF",cf);
    // if (queryResultCF!=null){
    // returnMessage = "该证书已被查封！";
    // }
    // }
    // if (returnMessage.equals("") && !cf.getDjh().equals("")){
    // queryCF.setCflx("按宗查封");
    // queryCF.setIsjf(cf.getIsjf());
    // queryCF.setTdzh("");
    // //System.out.println(cf.getIsjf()+"---cf.getIsjf()");
    // //System.out.println(cf.getDjh()+"---cf.getDjh()");
    // queryCF.setDjh(cf.getDjh());
    // queryResultCF =
    // (CF)getSqlMapClientTemplate().queryForObject("selectCF",cf);
    // //System.out.println(queryResultCF.getProjectId());
    // if (queryResultCF!=null){
    // returnMessage = "该宗地已被查封！";
    //			}
    //		}
    //		return returnMessage;
    //	}
}
