package com.jsegov.tddj.check;

import com.jsegov.tddj.dao.JttdsyzDAO;
import com.jsegov.tddj.vo.CheckReturnMsg;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-17
 * Time: 下午7:05
 * Des:  检查一户多宅情况，针对宅基地
 * To change this template use File | Settings | File Templates.
 */
@Service
public class CreateTaskCheckYhdzImpl implements CreateTaskCheck {
    @Autowired
    JttdsyzDAO jttdsyzDAO;

    @Override
    public CheckReturnMsg run(Map params) {
        CheckReturnMsg msg = null;

        String qlr = (params.get("qlr")!=null)?"":params.get("qlr").toString();

        String returnMessage = "";
        if (qlr!=null && !qlr.equals("")){
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("qlr", qlr);
            List<Object> list = jttdsyzDAO.expJttdsyz(map);
            if (list!=null && list.size()>0) {
                msg = new CheckReturnMsg();
                msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                msg.setReturnMessage(qlr+"已经存在宅基地，是否继续办理？");
            }
        }
        return msg;
    }
}
