package com.jsegov.tddj.check;

import com.gtis.spring.Container;
import com.jsegov.tddj.dao.GytdsyzDAO;
import com.jsegov.tddj.dao.JttdsuzDAO;
import com.jsegov.tddj.dao.JttdsyzDAO;
import com.jsegov.tddj.dao.TxqlzmsDAO;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-16
 * Time: 下午6:33
 * Des:
 * To change this template use File | Settings | File Templates.
 */
@Service
public class CreateTaskCheckTdzhImpl implements CreateTaskCheck {

    @Autowired
    GytdsyzDAO gytdsyzDAO;

    @Autowired
    JttdsyzDAO jttdsyzDAO;

    @Autowired
    JttdsuzDAO jttdsuzDAO;

    @Autowired
    TxqlzmsDAO txqlzmsDAO;

    @Override
    public CheckReturnMsg run(Map params) {

        CheckReturnMsg msg = null;
        String tdzh = (params.get("tdzh")==null)?"":params.get("tdzh").toString();
        String qsxz = (params.get("qsxz")==null)?"":params.get("qsxz").toString();
        String sqlx = (params.get("sqlx")==null)?"":params.get("sqlx").toString();
        if(sqlx.indexOf("他项")>-1){
            qsxz = "TX";
        }
        Integer checkCode = (params.get("checkCode")==null)?0: Integer.parseInt(params.get("checkCode").toString());

            if ("GY".equals(qsxz)){
                GYTDSYZ gytdsyz = new GYTDSYZ();
                gytdsyz.setTdzh(tdzh);
                GYTDSYZ result = (GYTDSYZ)gytdsyzDAO.getGytdsyz(gytdsyz);
                //如果根据土地证号都没有找到土地证信息
                msg = new CheckReturnMsg();
                if(result == null){
                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    msg.setReturnMessage("系统中不存在证号为“"+tdzh+"”的相关信息，是否属于老数据没有转入，建议您录入之后再处理。\r\n如果您要继续办理，请点YES，否则请点NO");
                    return msg;
                }else{
//                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
//                    msg.setReturnMessage(getZsStatus(tdzh,result.getIslogout(), checkCode));

                    return getZsStatus(tdzh,result.getIslogout(), checkCode);
                }
            }else if("JY".equals(qsxz)){
                JTTDSYZ jttdsyz = new JTTDSYZ();
                jttdsyz.setTdzh(tdzh);
                JTTDSYZ result = (JTTDSYZ)jttdsyzDAO.getJTTDSYZ(jttdsyz);
                msg = new CheckReturnMsg();
//              //如果根据土地证号都没有找到土地证信息
                if(result == null){
                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    msg.setReturnMessage("系统中不存在证号为“"+tdzh+"”的相关信息，是否属于老数据没有转入，建议您录入之后再处理。\r\n如果您要继续办理，请点YES，否则请点NO");
                    return msg;
                }else{
                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    return getZsStatus(tdzh,result.getIslogout(), checkCode);
                }
            }else if("JU".equals(qsxz)){
                JTTDSUZ jttdsuz = new JTTDSUZ();
                jttdsuz.setTdzh(tdzh);
                JTTDSUZ result = (JTTDSUZ)jttdsuzDAO.getJTTDSUZ(jttdsuz);
                msg = new CheckReturnMsg();
//              //如果根据土地证号都没有找到土地证信息
                if(result == null){
                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    msg.setReturnMessage("系统中不存在证号为“"+tdzh+"”的相关信息，是否属于老数据没有转入，建议您录入之后再处理。\r\n如果您要继续办理，请点YES，否则请点NO");
                    return msg;
                }else{
                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    return getZsStatus(tdzh,result.getIslogout(), checkCode);
                }
            }else if("TX".equals(qsxz)){
                TXQLZMS txqlzms = new TXQLZMS();
                txqlzms.setTdzh(tdzh);
                TXQLZMS result = (TXQLZMS)txqlzmsDAO.getTXQLZMS(txqlzms);
                msg = new CheckReturnMsg();
//              //如果根据土地证号都没有找到土地证信息
                if(result == null){
                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    msg.setReturnMessage("系统中不存在证号为“"+tdzh+"”的相关信息，是否属于老数据没有转入，建议您录入之后再处理。\r\n如果您要继续办理，请点YES，否则请点NO");
                    return msg;
                }else{
                    msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);
                    return getZsStatus(tdzh,result.getIslogout(), checkCode);
                }
            }
        return msg;
    }


    public CheckReturnMsg getZsStatus(String tdzh,Integer isLogout,Integer cc){
        CheckReturnMsg msg = new CheckReturnMsg();
        msg.setCheckModel(CheckReturnMsg.MsgModel.CONFIRM);

        if (isLogout==null){
            return null;
        }else if (isLogout == 0){
            return null;
        }else if (isLogout == 1 && cc == 301){
            msg.setReturnMessage("该土地证：" + tdzh + "已注销！");
        }else if (isLogout == 2 && cc == 302){
            msg.setReturnMessage("该土地证：" + tdzh + "已变更！");
        }else if (isLogout == 3 && cc == 303){
            ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
            //获取未注销的他项证
            List<TXQLZMS> wzxlist = txqlzmsService.queryTxqlzmsByYtdzh(tdzh);
            String txtdzh="";
            if(wzxlist!=null && wzxlist.size()>0){
                for(int i=0;i<wzxlist.size();i++){
                     TXQLZMS txqlzms = wzxlist.get(i);
                    txtdzh = txtdzh + txqlzms.getTdzh()+"、";
                }
                txtdzh =txtdzh.substring(0,txtdzh.length()-1);
                msg.setReturnMessage("该土地证已进行过他项登记,已登记的他项证书号为:"+txtdzh);
                msg.setAlertMsg("该土地证已进行过他项登记,已登记的他项证书号为:"+txtdzh);
            }

        }else if (isLogout == 4 && cc == 304){
            ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
            //获取未注销的他项证
            List<TXQLZMS> wzxlist = txqlzmsService.queryTxqlzmsByYtdzh(tdzh);
            String txtdzh="";
            if(wzxlist!=null && wzxlist.size()>0){
                for(int i=0;i<wzxlist.size();i++){
                    TXQLZMS txqlzms = wzxlist.get(i);
                    txtdzh = txtdzh + txqlzms.getTdzh()+"、";
                }
                txtdzh =txtdzh.substring(0,txtdzh.length()-1);
                msg.setReturnMessage("该土地证已进行过他项登记,已登记的他项证书号为:"+txtdzh);
                msg.setAlertMsg("该土地证已进行过他项登记,已登记的他项证书号为:"+txtdzh);
            }
        }else if (isLogout == 5 && cc == 305){
            msg.setReturnMessage("该土地证：" + tdzh + "已部分租赁！");
        }else if (isLogout == 6 && cc == 306){
            msg.setReturnMessage("该土地证：" + tdzh + "已完全租赁！");
        }else if (isLogout == 7 && cc == 307){
            msg.setReturnMessage("该土地证：" + tdzh + "已部分变更！");
        }else if (isLogout == 8 && cc == 308){
            msg.setReturnMessage("该土地证：" + tdzh + "已分割！");
        }else if (isLogout == 20 && cc == 309){
            msg.setReturnMessage("该土地证：" + tdzh + "为房改房");
        }else {
            return null;
        }
        return msg;
    }
}
