package com.jsegov.tddj.check;

import com.jsegov.tddj.dao.FGZDAO;
import com.jsegov.tddj.vo.CheckReturnMsg;
import com.jsegov.tddj.vo.FGZ;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-17
 * Time: 上午10:05
 * Des:
 * To change this template use File | Settings | File Templates.
 */
@Service
public class CreateTaskCheckFgzImpl implements CreateTaskCheck {
    @Autowired
    FGZDAO fgzDAO;

    @Override
    public CheckReturnMsg run(Map params) {
        CheckReturnMsg msg = new CheckReturnMsg();

        String tdzh = (params.get("tdzh")==null)?"":params.get("tdzh").toString();

        FGZ fgz  = new FGZ();
        fgz.setFgzh(tdzh);

        FGZ resultFgz = fgzDAO.getFGZ(fgz);
        if (resultFgz == null){
            msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
            msg.setReturnMessage("该分割证：" + tdzh + "不存在！");
        }else{
            if (resultFgz.getIshz()==1){
                msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
                msg.setReturnMessage( "该分割证：" + tdzh + "已换发土地证，土地证号为：" + resultFgz.getHfzh() + "！");
            }else{
                msg = null;
            }
        }
        return msg;
    }
}
