package com.jsegov.tddj.check;

import com.jsegov.tddj.dao.CFDAO;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.CheckReturnMsg;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: pyonline
 * Date: 12-4-16
 * Time: 下午2:05
 * Des: 创建任务时，检查查封的相关逻辑
 * To change this template use File | Settings | File Templates.
 */
@Service
public class CreateTaskCheckCfImpl implements CreateTaskCheck {

    @Autowired
    CFDAO cfDAO;

    @Override
    public CheckReturnMsg run(Map params) {
        CheckReturnMsg msg = new CheckReturnMsg();

        String tdzh = (params.get("tdzh")==null)?"":params.get("tdzh").toString();
        String djh = (params.get("djh")==null)?"":params.get("djh").toString();
        String tdzl = (params.get("tdzl")==null)?"":params.get("tdzl").toString();
        String qlr = (params.get("qlr")==null)?"":params.get("qlr").toString();

        CF cf = new CF();
        cf.setIsjf(0);
        cf.setTdzh(tdzh);
        cf.setDjh(djh);
        cf.setZl(tdzl);
        cf.setBzxr(qlr);

        Integer i = (cfDAO.CfListByTdzs(cf)!=null)?cfDAO.CfListByTdzs(cf).size():0;
        if(i>0){
            msg.setCheckModel(CheckReturnMsg.MsgModel.ALERT);
            msg.setReturnMessage("本土地证已经被查封了"+i+"次。");
            return  msg;
        }else{
            return null;
        }
    }
}
