package com.jsegov.tddj.aop;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.spring.Container;
import com.jsegov.tddj.dao.LogDAO;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.*;
import com.jsegov.tddj.vo.*;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:xuexing3212@gtis.com.cn">zhangxing</a>
 * @version V1.0, 13-6-7
 */
@Aspect
public class CreatLog {
    private LogDAO logDAO;

    @After("execution(* com.jsegov.tddj.dao.DJKDAO.updateDJK(..))")
    public void updateDJKLog(JoinPoint jp) {
        DJK djk = (DJK) jp.getArgs()[0];
        String djh="";
        String projectid="";
        if(djk!=null)
        {
            djh=djk.getDjh();
            projectid=djk.getDjkId().toString();
        }
        CreateNewLog("编辑","编辑登记卡，地籍号为:"+djh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.DJKDAO.insertDJK(..))")
    public void insertDJKLog(JoinPoint jp) {
        DJK djk = (DJK) jp.getArgs()[0];
        String projectid=djk.getProjectId();
        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        DJK djk1 = djkService.getDJK(projectid);
        String djh="";
        String djkid="";
        if(djk1!=null){
            djh=djk1.getDjh();
            djkid=djk1.getDjkId().toString();
        }
        CreateNewLog("插入","插入登记卡，地籍号为:"+djh,djkid);
    }

    @Before("execution(* com.jsegov.tddj.dao.DJKDAO.deleteDJK(..))")
    public void deleteDJKLog(JoinPoint jp) {
        String projectId=(String)jp.getArgs()[0];;
        IDJKService djkService = (IDJKService) Container.getBean("djkService");
        DJK djk = djkService.getDJK(projectId);
        String djh="";
        String djkid="";
        if(djk!=null){
            djh=djk.getDjh();
            djkid=djk.getDjkId().toString();
        }
        CreateNewLog("删除","删除登记卡，地籍号为:"+djh,djkid);
    }

    @After("execution(* com.jsegov.tddj.dao.DJKXBDAO.updateDJKXB(..))")
    public void updateDJKXBLog(JoinPoint jp) {
        DJKXB djkxb = (DJKXB) jp.getArgs()[0];
        String djh="";
        String projectid=djkxb.getProjectId();
        String djkxbid="";
        IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
        DJKXB djkxb1= djkxbService.getDJKXB(projectid);
        if(djkxb1!=null)
        {
            djh=djkxb1.getDjh();
            djkxbid=djkxb1.getDjkxbid().toString();
        }
        CreateNewLog("编辑","编辑登记卡续表，地籍号为:"+djh,djkxbid);
    }

    @After("execution(* com.jsegov.tddj.dao.DJKXBDAO.insertDJKXB(..))")
    public void insertDJKXBLog(JoinPoint jp) {
        DJKXB djkxb = (DJKXB) jp.getArgs()[0];
        IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
        String djh="";
        String djkxbid="";
        String projectid=djkxb.getProjectId();
        DJKXB djkxb1 = djkxbService.getDJKXB(projectid);
        if(djkxb1!=null){
            djh=djkxb1.getDjh();
            djkxbid=djkxb1.getDjkxbid().toString();
        }
        CreateNewLog("插入","插入登记卡续表，地籍号为:"+djh,djkxbid);
    }

    @Before("execution(* com.jsegov.tddj.dao.DJKXBDAO.deleteDJKXB(..))")
    public void deleteDJKXBLog(JoinPoint jp) {
        String projectId = (String) jp.getArgs()[0];
        String djh="";
        String djkxbid="";
        IDJKXBService djkxbService=(IDJKXBService)Container.getBean("djkXbService");
        DJKXB djkxb=djkxbService.getDJKXB(projectId);
        if(djkxb!=null){
            djh=djkxb.getDjh();
            djkxbid=djkxb.getDjkxbid().toString();
        }
        CreateNewLog("删除","删除登记卡续表，地籍号为:"+djh,djkxbid);
    }

    @After("execution(* com.jsegov.tddj.dao.TDZJSDAO.updateTDZJS(..))")
    public void updateTDZJSLog(JoinPoint jp) {
        TDZJS tdzjs = (TDZJS) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(tdzjs!=null){
            tdzh=tdzjs.getTdzh();
            projectid=tdzjs.getTdzjsId().toString();
        }
        CreateNewLog("编辑","编辑土地证记事,土地证号为:"+tdzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.TDZJSDAO.insertTDZJS(..))")
    public void insertTDZJSLog(JoinPoint jp) {
        TDZJS tdzjs = (TDZJS) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(tdzjs!=null){
            tdzh=tdzjs.getTdzh();
            projectid=tdzjs.getTdzjsId().toString();
        }
        CreateNewLog("插入","插入土地证记事，土地证号为:"+tdzh,projectid);
    }

    @Before("execution(* com.jsegov.tddj.dao.TDZJSDAO.deleteTDZJSByJsId(..))")
    public void deleteTDZJSByJsIdLog(JoinPoint jp) {
        String tdzjsId = (String) jp.getArgs()[0];
        String tdzh="";
        ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
        TDZJS tdzjs=tdzjsService.getTDZJS(tdzjsId);
        if(tdzjs!=null){
            tdzh=tdzjs.getTdzh();
        }
        CreateNewLog("删除","删除土地证记事，土地证号为:"+tdzh,tdzjsId.toString());
    }

    @Before("execution(* com.jsegov.tddj.dao.TDZJSDAO.deleteTDZJS(..))")
    public void deleteTDZJSByProjectIdLog(JoinPoint jp) {
        String projectId = (String) jp.getArgs()[0];
        String tdzh="";
        String tdzjsid="";
        ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
        TDZJS tdzjs=tdzjsService.getTDZJSByProjectId(projectId);
        if(tdzjs!=null){
            tdzh=tdzjs.getTdzh();
            tdzjsid=tdzjs.getTdzjsId().toString();
        }
        CreateNewLog("删除","删除土地证记事，土地证号为:"+tdzh,tdzjsid);
    }


    @After("execution(* com.jsegov.tddj.dao.FGZDAO.updateFGZ(..))")
    public void updateFGZLog(JoinPoint jp) {
        FGZ fgz = (FGZ) jp.getArgs()[0];
        String fgzh="";
        String projectid="";
        if(fgz!=null){
            fgzh=fgz.getFgzh();
            projectid=fgz.getFgzid();
        }
        CreateNewLog("编辑","编辑分割证，分割证号为:"+fgzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.FGZDAO.insertFGZ(..))")
    public void insertFGZLog(JoinPoint jp) {
        FGZ fgz = (FGZ) jp.getArgs()[0];
        String fgzh="";
        String projectid="";
        if(fgz!=null){
            fgzh=fgz.getFgzh();
            projectid=fgz.getFgzid();
        }
        CreateNewLog("插入","插入分割证，分割证号为:"+fgzh,projectid);
    }

    @Before("execution(* com.jsegov.tddj.dao.FGZDAO.deleteFGZ(..))")
    public void deleteFGZLog(JoinPoint jp) {
        FGZ fgz = (FGZ) jp.getArgs()[0];
        String fgzid=fgz.getFgzid();
        IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
        FGZ fgz1 = fgzService.getFGZById(fgzid);
        String fgzh="";
        String projectid="";
        if(fgz1!=null){
            fgzh=fgz1.getFgzh();
            projectid=fgz1.getFgzid();
        }
        CreateNewLog("删除","删除分割证，分割证号为:"+fgzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.SJDCLLISTDAO.updateSJDCLLIST(..))")
    public void updateSJDCLListLog(JoinPoint jp) {
        SJDCLLIST sjdcllist = (SJDCLLIST) jp.getArgs()[0];
        String sjdclid="";
        if(sjdcllist!=null && sjdcllist.getId()!=null)
            sjdclid=sjdcllist.getId().toString();
        CreateNewLog("编辑","编辑收件单材料，收件单材料id为:"+sjdclid,sjdclid);
    }

    @After("execution(* com.jsegov.tddj.dao.SJDCLLISTDAO.insertSJDCLLIST(..))")
    public void insertSJDCLListLog(JoinPoint jp) {
        SJDCLLIST sjdcllist = (SJDCLLIST) jp.getArgs()[0];
        String sjdclid="";
        if(sjdcllist!=null && sjdcllist.getId()!=null)
            sjdclid=sjdcllist.getId().toString();
        CreateNewLog("插入","插入收件单材料，收件单材料id为:"+sjdclid,sjdclid);
    }

    @After("execution(* com.jsegov.tddj.dao.SJDCLLISTDAO.deleteSJDCLLIST(..))")
    public void deleteSJDCLListLog(JoinPoint jp) {
        Integer sjdclid=(Integer)jp.getArgs()[0];
        CreateNewLog("删除","删除收件单材料，收件单材料id为:"+sjdclid,sjdclid.toString());
    }

    @After("execution(* com.jsegov.tddj.dao.SQBDAO.updateSQB(..))")
    public void updateSQBLog(JoinPoint jp) {
        SQB sqb = (SQB) jp.getArgs()[0];
        String sqsbh="";
        String projectid="";
        if(sqb!=null ){
            sqsbh=sqb.getSqsbh();
            projectid=sqb.getProjectId();
        }
        CreateNewLog("编辑","编辑申请表，申请书编号为:"+sqsbh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.SQBDAO.insertSQB(..))")
    public void insertSQBLog(JoinPoint jp) {
        SQB sqb = (SQB) jp.getArgs()[0];
        String sqsbh="";
        String projectid="";
        if(sqb!=null ){
            sqsbh=sqb.getSqsbh();
            projectid=sqb.getProjectId();
        }
        CreateNewLog("插入","插入申请表，申请书编号为:"+sqsbh,projectid);
    }

    @Before("execution(* com.jsegov.tddj.dao.SQBDAO.deleteSQB(..))")
    public void deleteSQBLog(JoinPoint jp) {
        String projectid=(String)jp.getArgs()[0];
        String sqsbh="";
        ISQBService sqbService=(ISQBService)Container.getBean("sqbService");
        SQB sqb=sqbService.getSQB(projectid);
        if(sqb!=null){
            sqsbh=sqb.getSqsbh();
        }
        CreateNewLog("删除","删除申请表，申请书编号为:"+sqsbh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.SPBDAO.updateSPB(..))")
    public void updateSPBLog(JoinPoint jp) {
        SPB spb = (SPB) jp.getArgs()[0];
        String spbh="";
        String projectid="";
        if(spb!=null ){
            spbh=spb.getSpbh();
            projectid=spb.getProjectId();
        }
        CreateNewLog("编辑","编辑审批表，审批表号为:"+spbh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.SPBDAO.insertSPB(..))")
    public void insertSPBLog(JoinPoint jp) {
        SPB spb = (SPB) jp.getArgs()[0];
        String spbh="";
        String projectid="";
        if(spb!=null ){
            spbh=spb.getSpbh();
            projectid=spb.getProjectId();
        }
        CreateNewLog("插入","插入审批表，审批表号为:"+spbh,projectid);
    }

    @Before("execution(* com.jsegov.tddj.dao.SPBDAO.deleteSPB(..))")
    public void deleteSPBLog(JoinPoint jp) {
        String projectid=(String)jp.getArgs()[0];
        String spbh="";
        ISPBService spbService = (ISPBService) Container.getBean("spbService");
        SPB spb = spbService.getSPB(projectid);
        if(spb!=null){
            spbh=spb.getSpbh();
        }
        CreateNewLog("删除","删除审批表，审批表号为:"+spbh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.GytdsyzDAO.updateGYTDSYZ(..))")
    public void updateGYTDSYZLog(JoinPoint jp) {
        GYTDSYZ gytdsyz = (GYTDSYZ) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(gytdsyz!=null ){
            tdzh=gytdsyz.getTdzh();
            projectid=gytdsyz.getProjectId();
        }
        CreateNewLog("编辑","编辑国有土地使用证，土地证号为:"+tdzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.GytdsyzDAO.insertGYTDSYZ(..))")
    public void insertGYTDSYZLog(JoinPoint jp) {
        GYTDSYZ gytdsyz = (GYTDSYZ) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(gytdsyz!=null ){
            tdzh=gytdsyz.getTdzh();
            projectid=gytdsyz.getProjectId();
        }
        CreateNewLog("插入","插入国有土地使用证，土地证号为:"+tdzh,projectid);
    }

    @Before("execution(* com.jsegov.tddj.dao.GytdsyzDAO.deleteGYTDSYZ(..))")
    public void deleteGYTDSYZLog(JoinPoint jp) {
        String projectid=(String)jp.getArgs()[0];
        String tdzh="";
        IGytdsyzService gytdsyzService=(IGytdsyzService)Container.getBean("gyTdsyzService");
        GYTDSYZ gytdsyz=gytdsyzService.getGYTDSYZ(projectid);
        if(gytdsyz!=null){
            tdzh=gytdsyz.getTdzh();
        }
        CreateNewLog("删除","删除国有土地使用证，土地证号为:"+tdzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.JttdsyzDAO.updateJTTDSYZ(..))")
    public void updateJTTDSYZLog(JoinPoint jp) {
        JTTDSYZ jttdsyz = (JTTDSYZ) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(jttdsyz!=null ){
            tdzh=jttdsyz.getTdzh();
            projectid=jttdsyz.getProjectId();
        }
        CreateNewLog("编辑","编辑集体土地使用证，土地证号为:"+tdzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.JttdsyzDAO.insertJTTDSYZ(..))")
    public void insertJTTDSYZLog(JoinPoint jp) {
        JTTDSYZ jttdsyz = (JTTDSYZ) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(jttdsyz!=null ){
            tdzh=jttdsyz.getTdzh();
            projectid=jttdsyz.getProjectId();
        }
        CreateNewLog("插入","插入集体土地使用证，土地证号为:"+tdzh,projectid);
    }

    @Before("execution(* com.jsegov.tddj.dao.JttdsyzDAO.deleteJTTDSYZ(..))")
    public void deleteJTTDSYZLog(JoinPoint jp) {
        String projectid=(String)jp.getArgs()[0];
        String tdzh="";
        IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("jtTdsyzService");
        JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZ(projectid);
        if(jttdsyz!=null){
            tdzh=jttdsyz.getTdzh();
        }
        CreateNewLog("删除","删除集体土地使用证，土地证号为:"+tdzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.TxqlzmsDAO.updateTXQLZMS(..))")
    public void updateTXQLZMSLog(JoinPoint jp) {
        TXQLZMS txqlzms = (TXQLZMS) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(txqlzms!=null ){
            tdzh=txqlzms.getTdzh();
            projectid=txqlzms.getProjectId();
        }
        CreateNewLog("编辑","编辑他项权利证明书，土地证号为:"+tdzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.TxqlzmsDAO.insertTXQLZMS(..))")
    public void insertTXQLZMSLog(JoinPoint jp) {
        TXQLZMS txqlzms = (TXQLZMS) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(txqlzms!=null ){
            tdzh=txqlzms.getTdzh();
            projectid=txqlzms.getProjectId();
        }
        CreateNewLog("插入","插入他项权利证明书，土地证号为:"+tdzh,projectid);
    }

    @Before("execution(* com.jsegov.tddj.dao.TxqlzmsDAO.deleteTXQLZMS(..))")
    public void deleteTXQLZMSLog(JoinPoint jp) {
        String projectid=(String)jp.getArgs()[0];
        String tdzh="";
        ITxqlzmsService txqlzmsService = (ITxqlzmsService)Container.getBean("txqlzmsService");
        TXQLZMS txqlzms = txqlzmsService.getTXQLZMS(projectid);
        if(txqlzms!=null){
            tdzh=txqlzms.getTdzh();
        }
        CreateNewLog("删除","删除他项权利证明书，土地证号为:"+tdzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.JttdsuzDAO.updateJTTDSUZ(..))")
    public void updateJTTDSUZLog(JoinPoint jp) {
        JTTDSUZ jttdsuz = (JTTDSUZ) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(jttdsuz!=null ){
            tdzh=jttdsuz.getTdzh();
            projectid=jttdsuz.getProjectId();
        }
        CreateNewLog("编辑","编辑集体土地所有证，土地证号为:"+tdzh,projectid);
    }

    @After("execution(* com.jsegov.tddj.dao.JttdsuzDAO.insertJTTDSUZ(..))")
    public void insertJTTDSUZLog(JoinPoint jp) {
        JTTDSUZ jttdsuz = (JTTDSUZ) jp.getArgs()[0];
        String tdzh="";
        String projectid="";
        if(jttdsuz!=null ){
            tdzh=jttdsuz.getTdzh();
            projectid=jttdsuz.getProjectId();
        }
        CreateNewLog("插入","插入集体土地所有证，土地证号为:"+tdzh,projectid);
    }

    @Before("execution(* com.jsegov.tddj.dao.JttdsuzDAO.deleteJTTDSUZ(..))")
    public void deleteJTTDSUZLog(JoinPoint jp) {
        String projectid=(String)jp.getArgs()[0];
        String tdzh="";
        IJttdsuzService jttdsuzService = (IJttdsuzService)Container.getBean("jtTdsuzService");
        JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZ(projectid);
        if(jttdsuz!=null ){
            tdzh=jttdsuz.getTdzh();
        }
        CreateNewLog("删除","删除集体土地所有证，土地证号为:"+tdzh,projectid);
    }

    public void CreateNewLog(String action,String content,String projectid){
        try{
            Log log=new Log();
            log.setId(UUIDGenerator.generate());
            log.setUserId(TddjUtil.getCurrentUserId());
            log.setCreateTime(new Date());
            log.setAction(action);
            log.setIp(getIpAddr(ServletActionContext.getRequest()));
            log.setProjectid(projectid);
            String msg="";
            if(StringUtils.isBlank(TddjUtil.getCurrentUserName()))
                msg="流程";
            else
                msg=TddjUtil.getCurrentUserName();
            log.setContent(msg+"在"+getIpAddr(ServletActionContext.getRequest())+"机器上"+content);
            logDAO.saveLog(log);
        } catch (Exception e){
            System.out.println("插入日志表错误："+e.getMessage());
        }
    }
    // 获取客户端真实ip
    public String getIpAddr(HttpServletRequest request) {
        String ip ="";
        if(request!=null){
            ip = request.getHeader("x-forwarded-for");
            if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if(ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        return ip;
    }
    public LogDAO getLogDAO() {
        return logDAO;
    }

    public void setLogDAO(LogDAO logDAO) {
        this.logDAO = logDAO;
    }
}
