package com.jsegov.tddj.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.jsegov.tddj.services.interf.IStatFGZService;
import com.jsegov.tddj.util.DjhConvert;
import org.apache.struts2.ServletActionContext;

import com.gtis.web.SplitParam;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.StatFGZ;
import com.opensymphony.xwork2.ActionSupport;
import org.springframework.beans.factory.annotation.Autowired;

public class StatFGZAction extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    @Autowired
	private IStatFGZService statFGZService;
	private SplitParam splitParam;
    private String oldDjh;
    public String getOldDjh() {
        return oldDjh;
    }

    public void setOldDjh(String oldDjh) {
        this.oldDjh = oldDjh;
    }
	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}
	public IStatFGZService getStatFGZService() {
		return statFGZService;
	}
	public void setStatFGZService(IStatFGZService statFGZService) {
		this.statFGZService = statFGZService;
	}
	
	public String execute() throws Exception {
		//SplitParamImpl s = new SplitParamImpl();
		//s.setQueryString("statFGZ");
		HashMap<String,Object> map = new HashMap<String,Object>();
		HttpServletRequest request = ServletActionContext.getRequest();
		map = CommonUtil.getDwdmQuery(request, map);
		String djh = "";
		if (request.getParameter("djh") != null){
			djh = request.getParameter("djh");
			if (!djh.equals("")){
				/*map.put("djh", "%"+djh+"%");*/
                HashMap param=new HashMap();
                param= DjhConvert.ConvertToNewDjh(djh);
                String queryDjh=(String)param.get("addDjh");
                map.put("transDjh",queryDjh);
			}
		}
        if(oldDjh!=null&&!oldDjh.equals(""))
        {
            HashMap param=new HashMap();
            param= DjhConvert.ConvertToOldDjh(oldDjh);
            String queryDjh=(String)param.get("addDjh");
            map.put("transDjh",queryDjh);

        }
		String qlr = "";
		if (request.getParameter("qlr") != null){
			qlr = request.getParameter("qlr");
			if (!qlr.equals("")){
				map.put("qlr", "%"+qlr+"%");
			}
		}
		
		String ztdzh = "";
		if (request.getParameter("ztdzh") != null){
			ztdzh = request.getParameter("ztdzh");
			if (!ztdzh.equals("")){
				map.put("ztdzh", "%"+ztdzh+"%");
			}
		}

		String dwmc = "";
		if (request.getParameter("dwmc") != null){
			dwmc = request.getParameter("dwmc");
			if (!dwmc.equals("")){
				map.put("dwmc", "%"+dwmc+"%");
			}
		}
		
		String ksrq = "";
		if (request.getParameter("ksrq") != null){
			ksrq = request.getParameter("ksrq");
			if (!ksrq.equals("")){
				map.put("ksrq",CommonUtil.formateDateToStr(ksrq));
			}
		}
		
		String jsrq = "";
		if (request.getParameter("jsrq") != null){
			jsrq = request.getParameter("jsrq");
			if (!jsrq.equals("")){
				map.put("jsrq", CommonUtil.formateDateToStr(jsrq));
			}
		}
		
		//s.setQueryParam(map);
		//this.splitParam = s;

        map.put("dwdm","3208%");
		List<StatFGZ> fgzList = statFGZService.statFGZ(map);				
		ArrayList<String> a1 = new ArrayList<String>();
		ArrayList<String> a2 = new ArrayList<String>();		
		for (int i=0;i<fgzList.size();i++){
			StatFGZ statFgz = fgzList.get(i);
			a1.add(i, statFgz.getAllnum());
			a2.add(i, statFgz.getDwmc());
		}		
		request.setAttribute("a1", a1);
		request.setAttribute("a2", a2);
		
		
		request.setAttribute("djh", djh);
		request.setAttribute("qlr", qlr);
		request.setAttribute("ztdzh", ztdzh);
		request.setAttribute("dwmc", dwmc);
		request.setAttribute("ksrq", ksrq);
		request.setAttribute("jsrq", jsrq);
		return SUCCESS;
	}
}
