package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;
import org.apache.commons.lang.StringUtils;
import com.gtis.spring.Container;
import com.gtis.util.UUIDGenerator;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.IGHKService;
import com.jsegov.tddj.services.interf.IGYQDJKService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.IProRelationService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.services.interf.ITDZJSService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.util.Common;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.ProRelation;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.TDZJS;
import com.jsegov.tddj.vo.TXQLZMS;
import com.jsegov.tddj.vo.XZQ;
import com.opensymphony.xwork2.ActionSupport;

public class SjrlAction extends ActionSupport{

	/** 
	 * 
	 */
	private static final long serialVersionUID = 569543284318560509L;

	SPB spb;
	String tdzh;
	String fzrq;
	String sqsbh;
	String sqrq;
	String msg;
	
	String scrq;
	String shrq;
	String pzrq;
	String shr1;
	
	String rf1_dlrxm;
	String rf1_dlrzsh;
	String rf1_dljgmc;
	String rf1_dllxdh;
	
	String rf2_dlrxm;
	String rf2_dlrzsh;
	String rf2_dljgmc;
	String rf2_dllxdh;
	



	private String subType;// 提交类型;
	private String userDwdm;

	public String getUserDwdm() {
		return userDwdm;
	}

	public void setUserDwdm(String userDwdm) {
		this.userDwdm = userDwdm;
	}

	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		String userId = TddjUtil.getCurrentUserId();	
		userDwdm = TddjUtil.getCurrentUserDwdm();
		if (request.getParameter("projectId")!=null){
			request.setAttribute("saveDisabled", "");
			request.setAttribute("addsjDisabled", "");
			request.setAttribute("deleteDisabled", "");
            request.setAttribute("fjscDisabled", "");
            getData();
		}else{
			if (spb==null) spb = new SPB();
			request.setAttribute("addsjDisabled", "");
			request.setAttribute("saveDisabled", "disabled='disabled'");
			request.setAttribute("deleteDisabled", "disabled='disabled'");
            request.setAttribute("fjscDisabled", "disabled='disabled'");
		//	userService.getUserVo(arg0);
			//spb.setProjectId(UUIDGenerator.generate());
		}
		return SUCCESS;
	}

	public void getData() throws Exception {
		String projectId = "";
		String zsType = "GY";
		HttpServletRequest request = ServletActionContext.getRequest();	
		userDwdm = TddjUtil.getCurrentUserDwdm();
		if (request.getParameter("projectId")!=null){
			projectId = request.getParameter("projectId");
		}
		if (request.getParameter("zsType")!=null){
			zsType = request.getParameter("zsType");
			request.setAttribute("Tcount", zsType);
		}
		if (request.getParameter("saveSqb")!=null){
			request.setAttribute("saveSqb",request.getParameter("saveSqb"));
		}
		//System.out.println(request.getParameter("saveSqb")+"------");
		if (request.getParameter("saveSpb")!=null){
			request.setAttribute("saveSpb",request.getParameter("saveSpb"));
		}
		if (request.getParameter("saveDjk")!=null){
			request.setAttribute("saveDjk",request.getParameter("saveDjk"));
		}
		ISPBService spbService = (ISPBService)Container.getBean("spbService");
		spb = spbService.getSPB(projectId);
		if(zsType.equals("GY")){
			IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
			GYTDSYZ gyz = gytdsyzService.getGYTDSYZ(projectId);
			tdzh = gyz.getTdzh();
			fzrq = gyz.getFzrq();
			if(gyz != null && spb == null){
				spb = new SPB();
				spb.setProjectId(gyz.getProjectId());
				spb.setRf1_dwmc(gyz.getQlr());
				spb.setTh(gyz.getTh());
				spb.setYt(gyz.getYt());
				spb.setSyqlx(gyz.getSyqlx());
				spb.setZzrq(gyz.getZzrq());
				spb.setSyqmj(gyz.getSyqmj());
				spb.setDymj(gyz.getDymj());
				spb.setFtmj(gyz.getFtmj());
				spb.setZl(gyz.getZl());
				spb.setDjh(gyz.getDjh());
				spb.setDwdm(gyz.getDwdm());
				spb.setQdjg(gyz.getQdjg());
			}//else{
			//	spb.setProjectId(UUIDGenerator.generate());
			//}
		}else if(zsType.equals("JY")){
			IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("jtTdsyzService");
			JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZ(projectId);
			tdzh = jttdsyz.getTdzh();
			fzrq = jttdsyz.getFzrq();
			if(jttdsyz != null && spb == null){
				spb = new SPB();
				spb.setProjectId(jttdsyz.getProjectId());
				spb.setRf1_dwmc(jttdsyz.getQlr());
				spb.setTh(jttdsyz.getTh());
				spb.setYt(jttdsyz.getYt());
				spb.setSyqlx(jttdsyz.getSyqlx());
				spb.setZzrq(jttdsyz.getZzrq());
				spb.setSyqmj(jttdsyz.getSyqmj());
				spb.setDymj(jttdsyz.getDymj());
				spb.setFtmj(jttdsyz.getFtmj());
				spb.setZl(jttdsyz.getZl());
				spb.setDjh(jttdsyz.getDjh());
				spb.setDwdm(jttdsyz.getDwdm());
				spb.setQdjg(jttdsyz.getQdjg());
			}//else{
			//	spb.setProjectId(UUIDGenerator.generate());
			//}
		}else if(zsType.equals("JU")){
			IJttdsuzService jttdsuzService=(IJttdsuzService)Container.getBean("jtTdsuzService");
			JTTDSUZ jttdsuz=jttdsuzService.getJTTDSUZ(projectId);
			tdzh = jttdsuz.getTdzh();
			fzrq = jttdsuz.getFzrq();
			if(jttdsuz != null && spb == null){
				spb = new SPB();
				spb.setProjectId(jttdsuz.getProjectId());
				spb.setRf1_dwmc(jttdsuz.getSyqr());
				spb.setTh(jttdsuz.getTh());
				if (jttdsuz.getTdzmj()!=null){
					spb.setZdmj(jttdsuz.getTdzmj().toString());
				}
				spb.setZl(jttdsuz.getZl());
				spb.setDjh(jttdsuz.getDjh());
				spb.setDwdm(jttdsuz.getDwdm());
			}//else{
			//	spb.setProjectId(UUIDGenerator.generate());
			//}			
		}else if(zsType.equals("TX")){
			ITxqlzmsService txqlzmsService = (ITxqlzmsService)Container.getBean("txqlzmsService");
			TXQLZMS txz = txqlzmsService.getTXQLZMS(projectId);
			tdzh = txz.getTdzh();
			fzrq = txz.getFzrq();
			if(txz != null && spb == null){
				spb = new SPB();
				spb.setProjectId(txz.getProjectId());
				spb.setRf1_dwmc(txz.getYwr());
				spb.setRf2_dwmc(txz.getQlr());
				spb.setTh(txz.getTh());
				spb.setYt(txz.getYt());
				spb.setSyqlx(txz.getSyqlx());
				spb.setSyqmj(txz.getSyqmj());
				spb.setZl(txz.getZl());
				spb.setDjh(txz.getDjh());
				spb.setDwdm(txz.getDwdm());
				spb.setTxql(txz.getTxql());
				spb.setCxqx(txz.getCxqx());
				spb.setQlsx(txz.getQlsx());
				spb.setSdrq(txz.getSdrq());
				spb.setQsxz(txz.getQsxz());
			}//else{
			//	spb.setProjectId(UUIDGenerator.generate());
			//}
		}
		//
		if (spb.getScrq()!=null)scrq = CommonUtil.formateDate(spb.getScrq());
		if (spb.getShrq()!=null)shrq = CommonUtil.formateDate(spb.getShrq());
		if (spb.getPzrq()!=null)pzrq = CommonUtil.formateDate(spb.getPzrq());
		//sqb
		ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
		SQB sqb = sqbService.getSQB(projectId);
		if (sqb!=null && sqb.getSqsbh()!=null){
		sqsbh = sqb.getSqsbh();
		rf1_dlrxm=sqb.getRf1_dlrxm();
		rf1_dlrzsh=sqb.getRf1_dlrzsh();
		rf1_dljgmc=sqb.getRf1_dljgmc();
		rf1_dllxdh=sqb.getRf1_dllxdh();
		rf2_dlrxm=sqb.getRf2_dlrxm();
		rf2_dlrzsh=sqb.getRf2_dlrzsh();
		rf2_dljgmc=sqb.getRf2_dljgmc();
		rf2_dllxdh=sqb.getRf2_dllxdh();
		}
		//if (sqb!=null && sqb.getSjrq()!=null)sqrq = CommonUtil.formateDate(sqb.getSjrq());
		//return SUCCESS;
	}
	
	public String save() {
		
		HttpServletRequest request = ServletActionContext.getRequest();		
		String userName = TddjUtil.getCurrentUserName();	
		userDwdm = TddjUtil.getCurrentUserDwdm();
		//request.setAttribute("saveDisabled", "");
		//request.setAttribute("addsjDisabled", "disabled='disabled'");
		request.setAttribute("saveDisabled", "");
		request.setAttribute("deleteDisabled", "");
		request.setAttribute("addsjDisabled", "");
        request.setAttribute("fjscDisabled", "");
		// request.setAttribute("addsjDisabled", "disabled='disabled'");
		String Tcount = "";
		String saveSqb = "";
		String saveSpb = "";
		String saveDjk = "";
		String newDjh = "";
        String oldDjh = "";
		if(spb.getDjh().length()==19 && tdzh.length()>4){
             if(spb.getDjh().substring(12,13).equals("G") || spb.getDjh().substring(12,13).equals("J")){
                 newDjh = spb.getDjh();
             }else {
                 oldDjh = spb.getDjh();
             }
        } else{
            oldDjh =  spb.getDjh();
        }
		if (request.getParameter("Tcount")!=null){
			Tcount = request.getParameter("Tcount");
		}
		if (request.getParameter("saveSqb")!=null){
			saveSqb = request.getParameter("saveSqb");
		}
		if (request.getParameter("saveSpb")!=null){
			saveSpb = request.getParameter("saveSpb");
		}
		if (request.getParameter("saveDjk")!=null){
			saveDjk = request.getParameter("saveDjk");
		}

		// 根据subType：判断是否需要产生新的projectId

		if (subType.equals("insert")) {
			spb.setProjectId(UUIDGenerator.generate());
		}
		try{

			//根据权属性质生成证书

			//IZSService zService = (IZSService)Container.getBean("zsService");
			if (!tdzh.equals("")){
				spb.setTdzh(tdzh);
			}else if(tdzh.equals("")){

				//自动生成证号

				IBHService bhService = (IBHService)Container.getBean("bhService");
				if (Tcount.equals("GY")){
					tdzh =bhService.getGYTDSYZBH();
				}else if (Tcount.equals("JY")){
					tdzh =bhService.getJTTDSYZBH();
				}else if (Tcount.equals("JU")){
					tdzh =bhService.getJTTDSUZBH();
				}else if (Tcount.equals("TX")){
					tdzh =bhService.getTXQLZMSBH();
				}
				//tdzh = spb.getSpbh(); 
				spb.setSpbh(bhService.getSPBBH());
				sqsbh= bhService.getSQBBH();
				spb.setTdzh(tdzh);
			}
			
			if (scrq!=null && !scrq.equals("")){
				spb.setScrq(CommonUtil.formateDateToStr(scrq));
			}
			if (shrq!=null && !shrq.equals("")){
				spb.setShrq(CommonUtil.formateDateToStr(shrq));
			}
			if (pzrq!=null && !pzrq.equals("")){
				spb.setPzrq(CommonUtil.formateDateToStr(pzrq));
			}
			if (fzrq!=null && !fzrq.equals("")){
				spb.setPzrq(CommonUtil.formateDateToStr(fzrq));
			}
			Common com = new Common();
			XZQ xzq = com.getXZQ();
			spb.setRmzf(xzq.getXzqName());
			spb.setDwdm(userDwdm);

			//自动生成SYQMJ

			//NumberFormat nf = new DecimalFormat("0.00");
			if (spb.getDymj()!=null && spb.getFtmj()!=null){
				//spb.setSyqmj(new Double(nf.format(spb.getDymj()+spb.getFtmj())));
				spb.setSyqmj(CommonUtil.formatNumber(spb.getDymj()+(spb.getFtmj())));			
			}else if (spb.getDymj()==null && spb.getFtmj()!=null){
				spb.setSyqmj(CommonUtil.formatNumber(spb.getFtmj()));
			}else if (spb.getDymj()!=null && spb.getFtmj()==null){
				spb.setSyqmj(CommonUtil.formatNumber(spb.getDymj()));
			}
			

			//点击新增 INSERT 点击保存UPDATE
			//证书 

			if (Tcount.equals("GY")){
				IGytdsyzService gytdsyzService = (IGytdsyzService)Container.getBean("gyTdsyzService");
				GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZ(spb.getProjectId());
				if (gytdsyz == null){
					gytdsyz = new GYTDSYZ();
					gytdsyz.setQlr(spb.getRf1_dwmc());
					gytdsyzService.insertGYTDSYZ(spb);
				}else{
					gytdsyz.setQlr(spb.getRf1_dwmc());
					gytdsyzService.updateGYTDSYZ(spb);
				}
			}else if (Tcount.equals("JY")){
				IJttdsyzService jttdsyzService = (IJttdsyzService)Container.getBean("jtTdsyzService");
				JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZ(spb.getProjectId());
				if (jttdsyz==null){
					jttdsyz =new JTTDSYZ();
					jttdsyz.setQlr(spb.getRf1_dwmc());
					jttdsyzService.insertJTTDSYZ(spb);
				}else{
					jttdsyz.setQlr(spb.getRf1_dwmc());
					jttdsyzService.updateJTTDSYZ(spb);
				}
			}else if (Tcount.equals("JU")){
				IJttdsuzService jttdsuzService = (IJttdsuzService)Container.getBean("jtTdsuzService");
				JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZ(spb.getProjectId());
				if (jttdsuz==null){
					jttdsuz =new JTTDSUZ();
					jttdsuz.setSyqr(spb.getRf1_dwmc());
					jttdsuzService.insertJTTDSUZ(spb);
				}else{
					jttdsuz.setSyqr(spb.getRf1_dwmc());
					jttdsuzService.updateJTTDSUZ(spb);
				}			
				
			}else if (Tcount.equals("TX")){
				ITxqlzmsService txqlzmsService = (ITxqlzmsService)Container.getBean("txqlzmsService");
				TXQLZMS txqlzms = txqlzmsService.getTXQLZMS(spb.getProjectId());
				if (txqlzms==null){
					txqlzms=new TXQLZMS();
					txqlzms.setQlr(spb.getRf1_dwmc());
					txqlzmsService.insertTXQLZMS(spb);
				}else{
					txqlzms.setQlr(spb.getRf1_dwmc());
					txqlzmsService.updateTXQLZMS(spb);
				}
			}
			

			//审批表


			//if (saveSpb.equals("saveSpb")){
				ISPBService spbService = (ISPBService)Container.getBean("spbService");
				if (request.getParameter("spb.shr")!=null)spb.setShr(request.getParameter("spb.shr"));
				if (spbService.getSPB(spb.getProjectId()) == null){
					spbService.insertSPB(spb);
				}else{
					spbService.updateSPB(spb);
				}
			//}

			//归户卡  
			//说明：产生登记卡就生成归户卡

                if (saveDjk.equals("saveDjk")){
				IGHKService ghkService = (IGHKService)Container.getBean("ghkService");
				if (ghkService.getGHK(spb.getProjectId()) == null){
					ghkService.insertGHK(spb);
				}else{
					ghkService.updateGHK(spb);
				}
			}

			//登记卡


			if (saveDjk.equals("saveDjk")){
				IDJKService djkService = (IDJKService)Container.getBean("djkService");
                if(newDjh !=null && !newDjh.equals("")){
                    if (djkService.getDJKByDjh(newDjh)==null){
                        djkService.insertDJK(spb);
                    }else{
                        djkService.updateDJK(spb);
                    }
                } else if(oldDjh!= null && !oldDjh.equals("")){
                    if (djkService.getDJKByOldDjh(oldDjh)==null){
                        djkService.insertDjk(spb);
                    }else{
                        djkService.updateDjk(spb);
                    }
                }
			}

			//登记卡续表


			if (!spb.getXbnr().equals("")){
				IDJKXBService djkxbService = (IDJKXBService)Container.getBean("djkXbService");
				if (djkxbService.getDJKXB(spb.getProjectId())==null){
					djkxbService.insertDJKXB(spb);
				}else{
					djkxbService.updateDJKXB(spb);
				}
			}

			//申请表


			if (saveSqb.equals("saveSqb")){
				ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
				SQB sqb = new SQB();
				sqb.setSqsbh(sqsbh);
				sqb.setRf1_dljgmc(rf1_dljgmc);
				sqb.setRf1_dllxdh(rf1_dllxdh);
				sqb.setRf1_dlrxm(rf1_dlrxm);
				sqb.setRf1_dlrzsh(rf1_dlrzsh);
				sqb.setRf2_dljgmc(rf2_dljgmc);
				sqb.setRf2_dllxdh(rf2_dllxdh);
				sqb.setRf2_dlrxm(rf2_dlrxm);
				sqb.setRf2_dlrzsh(rf2_dlrzsh);				
				sqb.setSqlx(spb.getSqlx());
				sqb.setProjectId(spb.getProjectId());
				sqb.setSyqlx(spb.getSyqlx());
				//sqb.setZmcl(spb.getQsly());
				sqb.setZtdzh(spb.getZtdzh());
				sqb.setQsxz(spb.getQsxz());

				sqbService.readSPB(sqb, spb, "SJRL");  //用readSPB（SQB，SPB，STRING）中“SJRL” 把SPB RF1 RF2 对应烤给SQB

				if (sqbService.getSQB(spb.getProjectId())==null){
					sqbService.insertSQB(sqb);
				}else{
					sqbService.updateSQB(sqb);
				}
			}

			//项目表


			IProjectService projectService = (IProjectService)Container.getBean("projectService");
			Project proj = projectService.getProject(spb.getProjectId());
			if (proj == null){
				Project project = new Project();
				project.setProjectId(spb.getProjectId());
				project.setProjectName(spb.getRf1_dwmc());
				project.setDjh(spb.getDjh());
				project.setBeginTime(CommonUtil.getCurrDate());
				project.setEndTime(CommonUtil.getCurrDate());
				project.setCreater(userName);
				project.setDwdm(userDwdm);

				project.setDjlx("数据录入");

				projectService.insertProject(project);
			}else{
				proj.setDjh(spb.getDjh());

				proj.setDjlx("数据录入");
				//proj.setDjlx(proj.getDjlx()+",数据录入");

				projectService.updateProject(proj);
			}

			//项目关系表


			IProRelationService proRelationService = (IProRelationService)Container.getBean("proRelationService");
			ProRelation proRelation = proRelationService.getProRelation(spb.getProjectId());
			if (proRelation == null){
				proRelation = new  ProRelation();
				//projectid, tdzh, qlr, fzrq, djlx, djh
				proRelation.setDjh(spb.getDjh());
				proRelation.setProjectId(spb.getProjectId());
				proRelation.setTdzh(spb.getTdzh());
				proRelation.setQlr(spb.getRf1_dwmc());
				proRelation.setFzrq(fzrq);
	           	proRelation.setDjlx("数据录入");

				proRelationService.insertProjectRelation(proRelation);
			}else{
				proRelation.setDjh(spb.getDjh());
				proRelation.setTdzh(spb.getTdzh());
				proRelation.setQlr(spb.getRf1_dwmc());
				proRelation.setFzrq(fzrq);

				proRelation.setDjlx("数据录入");

				proRelationService.updateProjectRelation(proRelation);
			}

			//土地证记事表
			if (Tcount.equals("TX")){//他项登记时 TDZH 对应 TXJS   ZTDZH 对应 JS

				ITDZJSService tdzjsService=(ITDZJSService)Container.getBean("tdzJsService");

				if(!spb.getTxjs().equals("")){
					if (tdzjsService.getTDZJS(spb.getTdzh(),spb.getProjectId())==null){
						tdzjsService.insertTXJS(spb);
					}else{
						tdzjsService.updateTXJS(spb);
					}
				}
				if(!spb.getJs().equals("")){
					if (tdzjsService.getTDZJS(spb.getZtdzh(),spb.getProjectId())==null){
						tdzjsService.insertTDZJS(spb);
					}else{
						tdzjsService.updateTDZJS(spb);
					}
				}
			}else{
				if(!spb.getJs().equals("")){
					ITDZJSService tdzjsService=(ITDZJSService)Container.getBean("tdzJsService");
					if (tdzjsService.getTDZJS(spb.getTdzh(),spb.getProjectId())==null){
						tdzjsService.insertTDZJS(spb);
					}else{
						tdzjsService.updateTDZJS(spb);
					}				
				}
			}

			//平台地籍号、座落
			IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
            if(Tcount.equals("TX")) {
                if (StringUtils.isNotBlank(spb.getRf2_dwmc())) {
                    platUtil.editWorkFlowInstance(spb.getProjectId(), spb.getDjh() + " || " + spb.getZl(), spb.getRf2_dwmc());
                }
            }else{
                platUtil.editWorkFlowInstance(spb.getProjectId(),  spb.getDjh() +" || "+spb.getZl(), spb.getRf1_dwmc());
            }
			setMsg("保存成功！");

		}catch (Exception e) {
			// TODO: handle exception
	        setMsg("字段异常请检查！"+e.getMessage());

		}
		request.setAttribute("Tcount", Tcount);
		request.setAttribute("saveSqb", saveSqb);
		request.setAttribute("saveSpb", saveSpb);
		request.setAttribute("saveDjk", saveDjk);
		return SUCCESS;
	}
	
	/**
	 * 删除证书并删除相关数据表记录
	 * 
	 * @return
	 * @throws Exception
	 */
	public String delete() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();		
		userDwdm = TddjUtil.getCurrentUserDwdm();
		String projectId = spb.getProjectId();
		// 删除项目表

		IProjectService projectService = (IProjectService) Container.getBean("projectService");
		projectService.deleteProject(projectId);
		// 删除收件单

		ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
		sjdService.deleteSJD(projectId);
		// 删除收件单材料

		sjdService.deleteSJDCL(projectId);
		// 删除申请表

		ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
		sqbService.deleteSQB(projectId);

		// 删除审批表

		ISPBService spbService = (ISPBService) Container.getBean("spbService");
		spbService.deleteSPB(projectId);

		// 删除登记卡

		IDJKService djkService = (IDJKService) Container.getBean("djkService");
		djkService.deleteDJK(projectId);

		// 删除登记卡续表

		IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
		djkxbService.deleteDJKXB(projectId);

		// 删除土地证--待改进

		IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
		gytdsyzService.deleteGYTDSYZ(projectId);
		IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
		jttdsyzService.deleteJTTDSYZ(projectId);
		IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
		jttdsuzService.deleteJTTDSUZ(projectId);
		ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
		txqlzmsService.deleteTXQLZMS(projectId);

		// 删除土地证记事

		ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
		TDZJS tdzjs = tdzjsService.getTDZJSByProjectId(projectId);

		// 2009-2-25 修改
		if (tdzjs != null) {
			tdzjsService.deleteTDZJS(tdzjs.getTdzjsId());
		}

		// 删除归户卡

		IGHKService ghkService = (IGHKService) Container.getBean("ghkService");
		ghkService.deleteGHK(projectId);

		// 删除共有权登记卡
		IGYQDJKService gyqdjkService = (IGYQDJKService) Container.getBean("gyqDjkService");
		gyqdjkService.deleteGYQDJK(projectId);
       // 删除项目关系表

		IProRelationService proRelationService = (IProRelationService) Container.getBean("proRelationService");
		proRelationService.deleteProjectRelation(projectId);

		// 返回消息
		setMsg("删除成功！");



		// 重置页面

		tdzh = "";
		sqsbh = "";

		scrq = "";
		shrq = "";
		pzrq = "";
		fzrq = "";

		rf1_dlrxm = "";
		rf1_dlrzsh = "";
		rf1_dljgmc = "";
		rf1_dllxdh = "";

		rf2_dlrxm = "";
		rf2_dlrzsh = "";
		rf2_dljgmc = "";
		rf2_dllxdh = "";
		spb = new SPB();
		request.setAttribute("addsjDisabled", "");
		request.setAttribute("saveDisabled", "disabled='disabled'");
		request.setAttribute("deleteDisabled", "disabled='disabled'");
        request.setAttribute("fjscDisabled", "disabled='disabled'");
		// spb.setProjectId(UUIDGenerator.generate());
		return SUCCESS;
	}
	
	public String getShr1() {
		return shr1;
	}

	public void setShr1(String shr1) {
		this.shr1 = shr1;
	}

	public String getScrq() {
		return scrq;
	}

	public void setScrq(String scrq) {
		this.scrq = scrq;
	}

	public String getShrq() {
		return shrq;
	}

	public void setShrq(String shrq) {
		this.shrq = shrq;
	}

	public String getPzrq() {
		return pzrq;
	}

	public void setPzrq(String pzrq) {
		this.pzrq = pzrq;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public SPB getSpb() {
		return spb;
	}

	public void setSpb(SPB spb) {
		this.spb = spb;
	}

	public String getTdzh() {
		return tdzh;
	}

	public void setTdzh(String tdzh) {
		this.tdzh = tdzh;
	}

	public String getFzrq() {
		return fzrq;
	}

	public void setFzrq(String fzrq) {
		this.fzrq = fzrq;
	}

	public String getSqsbh() {
		return sqsbh;
	}

	public void setSqsbh(String sqsbh) {
		this.sqsbh = sqsbh;
	}

	public String getSqrq() {
		return sqrq;
	}

	public void setSqrq(String sqrq) {
		this.sqrq = sqrq;
	}

	public String getRf1_dlrzsh() {
		return rf1_dlrzsh;
	}

	public void setRf1_dlrzsh(String rf1_dlrzsh) {
		this.rf1_dlrzsh = rf1_dlrzsh;
	}

	public String getRf1_dljgmc() {
		return rf1_dljgmc;
	}

	public void setRf1_dljgmc(String rf1_dljgmc) {
		this.rf1_dljgmc = rf1_dljgmc;
	}

	public String getRf1_dllxdh() {
		return rf1_dllxdh;
	}

	public void setRf1_dllxdh(String rf1_dllxdh) {
		this.rf1_dllxdh = rf1_dllxdh;
	}

	public String getRf2_dlrzsh() {
		return rf2_dlrzsh;
	}

	public void setRf2_dlrzsh(String rf2_dlrzsh) {
		this.rf2_dlrzsh = rf2_dlrzsh;
	}

	public String getRf2_dljgmc() {
		return rf2_dljgmc;
	}

	public void setRf2_dljgmc(String rf2_dljgmc) {
		this.rf2_dljgmc = rf2_dljgmc;
	}

	public String getRf2_dllxdh() {
		return rf2_dllxdh;
	}

	public void setRf2_dllxdh(String rf2_dllxdh) {
		this.rf2_dllxdh = rf2_dllxdh;
	}

	public String getRf1_dlrxm() {
		return rf1_dlrxm;
	}

	public void setRf1_dlrxm(String rf1_dlrxm) {
		this.rf1_dlrxm = rf1_dlrxm;
	}

	public String getRf2_dlrxm() {
		return rf2_dlrxm;
	}

	public void setRf2_dlrxm(String rf2_dlrxm) {
		this.rf2_dlrxm = rf2_dlrxm;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}	
	
}