package com.jsegov.tddj.action;

import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.IDJKXBService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJFService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.services.interf.ITDZJSService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.util.Common;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JF;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.TDZJS;
import com.jsegov.tddj.vo.TXQLZMS;
import com.opensymphony.xwork2.ActionSupport;

public class ShowDJCLAction extends ActionSupport {

    /**
     *
     */
    private static final long serialVersionUID = 5330488916418857331L;
    private SplitParam splitParam;
    private DJK djk = new DJK();
    private SPB spb = new SPB();
    private SQB sqb = new SQB();
    private CF cf = new CF();
    private JF jf = new JF();
    private GYTDSYZ gytdsyz = new GYTDSYZ();
    private JTTDSYZ jttdsyz = new JTTDSYZ();
    private TXQLZMS txqlzms = new TXQLZMS();
    private JTTDSUZ jttdsuz = new JTTDSUZ();
    private String djh;
    private String tdzh;
    private String scrq;
    private String jbrq;
    private String shrq;
    private String pzrq;
    private String isjf;
    private String sdrq;
    private String cfksrq;
    private String cfjsrq;
    private String xbnr;
    private String projectId;
    private List djkxbList;
    private List<TDZJS> jsList = new ArrayList<TDZJS>();
    private List<CF> cfList = new ArrayList<CF>();
    private String zslx;
    private String cfid;
    private String iscf;
    //zdd 2011-12-22 某个用户的用户名和登录密码   查看证书关系时用到
    private String username;
    private String password;

    public String getUsername() {
        Common common = new Common();
        username = common.getUserName();
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        Common common = new Common();
        password = common.getUserPassword();
        return password;
    }

    public String getZslx() {
        return zslx;
    }
    public void setZslx(String zslx) {
        this.zslx = zslx;
    }
    public String getCfid() {
        return cfid;
    }
    public void setCfid(String cfid) {
        this.cfid = cfid;
    }
    public String getIscf() {
        return iscf;
    }
    public void setIscf(String iscf) {
        this.iscf = iscf;
    }
    public String execute() throws Exception {
//		djh="3205831000020001000";
//		tdzh="标国用(2010)第1292号";
        HttpServletRequest request = ServletActionContext.getRequest();
        projectId = request.getParameter("projectid");
        djh = request.getParameter("djh");
        if (projectId != null && !projectId.equals("")){
            IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");

            gytdsyz=gytdsyzService.getGYTDSYZ(projectId);
            if (gytdsyz!=null){
                tdzh = gytdsyz.getTdzh();
                zslx = "gytdsyz";
            }else if (gytdsyz==null){
                IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
                jttdsyz=jttdsyzService.getJTTDSYZ(projectId);
                if (jttdsyz!=null){
                    tdzh = jttdsyz.getTdzh();
                    zslx = "jttdsyz";
                }
            }
            if (gytdsyz==null && jttdsyz==null){
                ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
                txqlzms=txqlzmsService.getTXQLZMS(projectId);
                if(txqlzms!=null){
                    tdzh = txqlzms.getTdzh();
                    zslx = "txqlzms";
                }
            }
            if (gytdsyz==null && jttdsyz==null && txqlzms==null){
                IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
                jttdsuz=jttdsuzService.getJTTDSUZ(projectId);
                if(jttdsuz!=null){
                    tdzh = jttdsuz.getTdzh();
                    zslx = "jttdsuz";
                }
            }
            if (tdzh!=null && !tdzh.equals("")){
                ICFService cfService = (ICFService)Container.getBean("cfService");
                List list = cfService.getCFByTdzh(tdzh);
                if (list!=null && list.size()>0){
                    iscf = "true";
                    cf = (CF)list.get(0);
                    if (list.size()==1 && cf.getIsjf()==0){
                        cfid = cf.getProjectId();
                    }
                }
            }

        }
        return SUCCESS;
    }
    public String showTDZ() throws Exception{
        String resultStr = "tdzerror";
        if (tdzh != null && !tdzh.equals("")){
            tdzh=URLDecoder.decode(tdzh,"UTF-8");

            IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
            IJttdsyzService jttdsyzService = (IJttdsyzService) Container.getBean("jtTdsyzService");
            ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container.getBean("txqlzmsService");
            IJttdsuzService jttdsuzService = (IJttdsuzService) Container.getBean("jtTdsuzService");
            ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
            if(tdzh.indexOf("国用")>-1){
                gytdsyz=gytdsyzService.getGYTDSYZbyTdzh(tdzh);
                if(gytdsyz!=null){
                    jsList = tdzjsService.getTDZJSList(gytdsyz.getTdzh());
                    resultStr = "gytdsyz";
                }
            }else if(tdzh.indexOf("集用")>-1){
                jttdsyz=jttdsyzService.getJTTDSYZByTdzh(tdzh);
                if(jttdsyz!=null){
                    jsList = tdzjsService.getTDZJSList(jttdsyz.getTdzh());
                    resultStr = "jttdsyz";
                }
            }else if(tdzh.indexOf("他项")>-1){
                txqlzms=txqlzmsService.getTXQLZMSByTdzh(tdzh);
                if(txqlzms!=null){
                    jsList = tdzjsService.getTDZJSList(txqlzms.getTdzh());
                    resultStr = "txqlzms";
                }//CDJ 添加集体土地所有证证书关系  #2892 2010-09-19
            }else if(tdzh.indexOf("集有")>-1){
                jttdsuz=jttdsuzService.getJTTDSUZByTdzh(tdzh);
                if(jttdsuz!=null){
                    jsList = tdzjsService.getTDZJSList(jttdsuz.getTdzh());
                    resultStr = "jttdsuz";
                }
            }else{
                gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(tdzh);
                if(gytdsyz!=null){
                    jsList = tdzjsService.getTDZJSList(gytdsyz.getTdzh());
                    resultStr = "gytdsyz";
                }
                if (gytdsyz==null){
                    txqlzms = txqlzmsService.getTXQLZMSByTdzh(tdzh);
                    if(txqlzms!=null){
                        jsList = tdzjsService.getTDZJSList(txqlzms.getTdzh());
                        resultStr = "txqlzms";
                    }
                }
                if (txqlzms==null){
                    jttdsyz=jttdsyzService.getJTTDSYZByTdzh(tdzh);
                    if(jttdsyz!=null){
                        jsList = tdzjsService.getTDZJSList(jttdsyz.getTdzh());
                        resultStr = "jttdsyz";
                    }
                }
                if (jttdsyz==null) {
                    jttdsuz=jttdsuzService.getJTTDSUZByTdzh(tdzh);
                    if(jttdsuz!=null){
                        jsList = tdzjsService.getTDZJSList(jttdsuz.getTdzh());
                        resultStr = "jttdsuz";
                    }
                }
            }
        }

        return resultStr;
    }

    public String showDJK() throws Exception {
        if (djh != null && !djh.equals("")){
            IDJKService djkService = (IDJKService) Container.getBean("djkService");
            djk=djkService.getDJKByDjh(djh);
            IDJKXBService djkxbService = (IDJKXBService) Container.getBean("djkXbService");
            djkxbList=djkxbService.getDJKXBList(djh);
            if(djk!=null){
                return "djk";
            }else{
                return "djkerror";
            }
        }else{
            return "djkerror";
        }
    }


    public String showSPB() throws Exception {
        if(projectId !=null && !projectId.equals("")){
            ISPBService spbService = (ISPBService)Container.getBean("spbService");
            spb=spbService.getSPB(projectId);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if(spb !=null){
                if(spb.getScrq() !=null && !spb.getScrq().equals("")){
                    scrq=sdf.format(spb.getScrq());
                }
                if(spb.getJbrq() !=null && !spb.getJbrq().equals("")){
                    jbrq=sdf.format(spb.getJbrq());
                }
                if(spb.getShrq() !=null && !spb.getShrq().equals("")){
                    shrq=sdf.format(spb.getShrq());
                }
                if(spb.getPzrq() !=null && !spb.getPzrq().equals("")){
                    pzrq=sdf.format(spb.getPzrq());
                }
                return "spb";
            }
        }
        return "spberror";
    }

    public String showSQB() throws Exception {
        if(projectId!=null && !projectId.equals("")){
            ISQBService sqbService = (ISQBService)Container.getBean("sqbService");
            sqb=sqbService.getSQB(projectId);
            if(sqb != null){
                return "sqb";
            }
        }
        return "sqberror";
    }

    public String showCFJF() throws Exception {
        if(tdzh !=null && !tdzh.equals("")){
            ICFService cfService = (ICFService)Container.getBean("cfService");
            tdzh=URLDecoder.decode(tdzh,"UTF-8");
            cfList=cfService.getCFByTdzh(tdzh);
            if(cfList.size()>0){
//				HashMap<String,Object> map = new HashMap<String,Object>();
//				map.put("tdzh", "%"+tdzh+"%");
//				SplitParamImpl s = new SplitParamImpl();
//				s.setQueryString("queryCF");
//				s.setQueryParam(map);
//				
//				this.splitParam =s;
                return "cfList";
            }else if(cfList.size()==1){
                cf=cfList.get(0);
                if(cfList.get(0).getIsjf() == 1){
                    setIsjf("解封");
                }else{
                    setIsjf("查封");
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if(cf.getSdrq() != null && !cf.getSdrq().equals("")){
                    sdrq=sdf.format(cf.getSdrq());
                }
                if(cf.getCfksrq() != null && !cf.getCfksrq().equals("")){
                    cfksrq=sdf.format(cf.getCfksrq());
                }
                if(cf.getCfjsrq() != null && !cf.getCfjsrq().equals("")){
                    cfjsrq=sdf.format(cf.getCfjsrq());
                }
                IJFService jfService = (IJFService)Container.getBean("jfService");
                jf=jfService.getJFByCfProjectId(cf.getProjectId());
                if(jf!=null && isjf.equals("解封")){
                    if(jf.getXbnr() !=null && !jf.getXbnr().equals("")){
                        setXbnr(jf.getXbnr());
                    }
                }else{
                    if(cf.getXbnr() !=null && !cf.getXbnr().equals("")){
                        setXbnr(cf.getXbnr());
                    }
                }
                if(cf != null){
                    return "cf";
                }
            }
        }
        return "cferror";
    }

    //分别对多条查封记录查询

    public String queryCFJF() throws Exception {
        ICFService cfService = (ICFService)Container.getBean("cfService");
        cf=cfService.getCFByProjectId(projectId);
        if(cf.getIsjf()!=null && cf.getIsjf() == 1){
            setIsjf("解封");
        }else{
            setIsjf("查封");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if(cf.getSdrq() != null && !cf.getSdrq().equals("")){
            sdrq=sdf.format(cf.getSdrq());
        }
        if(cf.getCfksrq() != null && !cf.getCfksrq().equals("")){
            cfksrq=sdf.format(cf.getCfksrq());
        }
        if(cf.getCfjsrq() != null && !cf.getCfjsrq().equals("")){
            cfjsrq=sdf.format(cf.getCfjsrq());
        }
        IJFService jfService = (IJFService)Container.getBean("jfService");
        jf=jfService.getJFByCfProjectId(cf.getProjectId());
        if(jf!=null && isjf.equals("解封")){
            if(jf.getXbnr() !=null && !jf.getXbnr().equals("")){
                setXbnr(jf.getXbnr());
            }
        }else{
            if(cf.getXbnr() !=null && !cf.getXbnr().equals("")){
                setXbnr(cf.getXbnr());
            }
        }
        return "cf";
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public DJK getDjk() {
        return djk;
    }

    public void setDjk(DJK djk) {
        this.djk = djk;
    }

    public GYTDSYZ getGytdsyz() {
        return gytdsyz;
    }

    public void setGytdsyz(GYTDSYZ gytdsyz) {
        this.gytdsyz = gytdsyz;
    }

    public JTTDSYZ getJttdsyz() {
        return jttdsyz;
    }

    public void setJttdsyz(JTTDSYZ jttdsyz) {
        this.jttdsyz = jttdsyz;
    }

    public TXQLZMS getTxqlzms() {
        return txqlzms;
    }

    public void setTxqlzms(TXQLZMS txqlzms) {
        this.txqlzms = txqlzms;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getTdzh() {
        return tdzh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }


    public String getProjectId() {
        return projectId;
    }
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public List getDjkxbList() {
        return djkxbList;
    }

    public void setDjkxbList(List djkxbList) {
        this.djkxbList = djkxbList;
    }

    public List<TDZJS> getJsList() {
        return jsList;
    }

    public void setJsList(List<TDZJS> jsList) {
        this.jsList = jsList;
    }
    public SPB getSpb() {
        return spb;
    }
    public void setSpb(SPB spb) {
        this.spb = spb;
    }
    public SQB getSqb() {
        return sqb;
    }
    public void setSqb(SQB sqb) {
        this.sqb = sqb;
    }
    public CF getCf() {
        return cf;
    }
    public void setCf(CF cf) {
        this.cf = cf;
    }
    public JF getJf() {
        return jf;
    }
    public void setJf(JF jf) {
        this.jf = jf;
    }
    public String getScrq() {
        return scrq;
    }
    public void setScrq(String scrq) {
        this.scrq = scrq;
    }
    public String getJbrq() {
        return jbrq;
    }
    public void setJbrq(String jbrq) {
        this.jbrq = jbrq;
    }
    public String getShrq() {
        return shrq;
    }
    public void setShrq(String shrq) {
        this.shrq = shrq;
    }
    public String getPzrq() {
        return pzrq;
    }
    public void setPzrq(String pzrq) {
        this.pzrq = pzrq;
    }
    public String getIsjf() {
        return isjf;
    }
    public void setIsjf(String isjf) {
        this.isjf = isjf;
    }
    public String getSdrq() {
        return sdrq;
    }
    public void setSdrq(String sdrq) {
        this.sdrq = sdrq;
    }
    public String getCfksrq() {
        return cfksrq;
    }
    public void setCfksrq(String cfksrq) {
        this.cfksrq = cfksrq;
    }
    public String getCfjsrq() {
        return cfjsrq;
    }
    public void setCfjsrq(String cfjsrq) {
        this.cfjsrq = cfjsrq;
    }
    public String getXbnr() {
        return xbnr;
    }
    public void setXbnr(String xbnr) {
        this.xbnr = xbnr;
    }
    public List<CF> getCfList() {
        return cfList;
    }
    public void setCfList(List<CF> cfList) {
        this.cfList = cfList;
    }
    public JTTDSUZ getJttdsuz() {
        return jttdsuz;
    }
    public void setJttdsuz(JTTDSUZ jttdsuz) {
        this.jttdsuz = jttdsuz;
    }

}
