package com.jsegov.tddj.action;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.services.interf.IFGZService;
import com.jsegov.tddj.services.interf.ILimitFieldService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISHEETINFOService;
import com.jsegov.tddj.services.interf.ISJDCLService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.FGZ;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SHEETINFO;
import com.jsegov.tddj.vo.SJD;
import com.jsegov.tddj.vo.SJDCL;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.XZQ;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;

/**
 * <p/> 获取审批表默认值

 * @author xtdi
 * @version V1.0, 2010-3-17
 */
public class SheetDefautValueAction extends ActionSupport {
    private String proId;
    private String taskId;

    public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getProId() {
        return proId;
    }

    public void setProId(String proId) {
        this.proId = proId;
    }
    public String getCfDefaultValue(){
         try{
             if (proId == null  || proId.length()==0) {
                    ServletActionContext.getResponse().setCharacterEncoding("utf-8");
                    ServletActionContext.getResponse().getWriter().println("");
                    return null;
              }
            ICFService cfService = (ICFService) Container.getBean("cfService");
            CF cf = cfService.getCFByProjectId(proId);
            Map<String, String> defaultValueMap = new HashMap<String, String>();
            String sqlx = "";
            ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
            SJD sjd = sjdService.getSJD(proId);
            sqlx = sjd.getSqlx();

            String cfxbnr_default = "";
            if (cf.getXbnr()==null){
                ISHEETINFOService sheetinfoService = (ISHEETINFOService)Container.getBean("sheetInfoService");
                SHEETINFO sheetinfo = sheetinfoService.getSHEETINFO(sqlx);
                if (sheetinfo != null){
                    cf.setXbnr(sheetinfo.getDjkxbnr());
                }
                cfService.updateCF(cf);
            }
            if(cf.getXbnr()!=null){
            	  cfxbnr_default =cf.getXbnr();
            }
            //System.out.println(cfxbnr_default);
            defaultValueMap.put("cfxbnr_default", cfxbnr_default);
            ILimitFieldService limitFieldService = (ILimitFieldService)Container.getBean("limitFieldService");
            IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
        	String remark = platUtil.getPfActivityNameByTaskId(taskId);
            String limitField = limitFieldService.getLimitFieldString(sqlx, "tbl_cf",remark);
            String tempUpperLimitField = limitField.toUpperCase();
            defaultValueMap.put("limitField", tempUpperLimitField) ;
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(defaultValueMap));
        }catch(Exception ex){
            ex.printStackTrace();
        }
        return Action.NONE;

    }

    public String getSpbDefaultValue(){
        //System.out.println("---------------------------getSpbDefaultValue");
        try {
            if (proId == null  || proId.length()==0) {
                ServletActionContext.getResponse().setCharacterEncoding("utf-8");
                ServletActionContext.getResponse().getWriter().println("");
                return null;
            }
            String spbcsyj_default = "";
            String spbfjyj_default = "";
            String spbshyj_default = "";
            String spbpzyj_default = "";
            String spbqsly_default = "";
            String js_default = "";
            String djkxbnr_default = "";
            String txql_default = "";
            String qlsx_default = "";
            String dyje_default = "";

            String spbcsyj = "";
            String spbfjyj= "";
            String spbshyj = "";
            String spbpzyj = "";
            String js = "";
            String djkxbnr = "";
            String txql = "";
            String qlsx = "";
            String tdzh = "";
            String dyje = "";
            String sz = "";

            String sqlx = "";
            String rmzf = "";
            XZQ xzq = new XZQ();
            xzq = CommonUtil.getXZQ();
            rmzf = xzq.getXzqName();

            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            SQB sqb = sqbService.getSQB(proId);
            if (sqb != null) {
                sqlx = sqb.getSqlx();
                //rmzf = sqb.getRmzf( );
                ISHEETINFOService sheetinfoService = (ISHEETINFOService) Container.getBean("sheetInfoService");
                SHEETINFO sheetinfo = sheetinfoService.getSHEETINFO(sqlx);
                if (sheetinfo != null) {
                    spbcsyj_default = sheetinfo.getSpbcsyj();
                    spbfjyj_default=sheetinfo.getSpbfjyj();
                    spbshyj_default = sheetinfo.getSpbshyj();
                    spbpzyj_default = sheetinfo.getSpbpzyj();
                    js_default = sheetinfo.getJs();
                    djkxbnr_default = sheetinfo.getDjkxbnr();
                    txql_default = sheetinfo.getTxql();
                    qlsx_default = sheetinfo.getQlsx();
                    dyje_default = sheetinfo.getDyje();
                }
            } else {
                ISPBService spbService = (ISPBService) Container.getBean("spbService");
                SPB spb = spbService.getSPB(proId);
                sqlx = spb.getSqlx();
                //rmzf = spb.getRmzf();
            }
            ISPBService spbService = (ISPBService) Container.getBean("spbService");
            SPB spbDefault = spbService.getSPB(proId);
            if(spbDefault!=null){
            	spbcsyj = spbDefault.getCsyj();
              //  spbfjyj=spbDefault.getFjyj();
                spbshyj = spbDefault.getShyj();
                spbpzyj = spbDefault.getPzyj();  

                js = spbDefault.getJs();
                djkxbnr = spbDefault.getXbnr();
                txql = spbDefault.getTxql();
                qlsx = spbDefault.getQlsx();
                dyje = spbDefault.getDyje();
                tdzh = spbDefault.getTdzh();
                sz = spbDefault.getZdsz();
            	
            }
            //zdd 2010-6-29 读取qsly
            ISJDCLService sjdclService = (ISJDCLService)Container.getBean("sjdClService");
            List<SJDCL> sjdclList=sjdclService.getSJDCL(proId);
            Integer size = 0;            
            if (sjdclList!=null)
            	size = sjdclList.size();
            for (int i = 0; i < size; i++) {
            	if(i==0){
            		spbqsly_default = sjdclList.get(i).getZjmc();
            	}else{
            		spbqsly_default = spbqsly_default+"；"+sjdclList.get(i).getZjmc();
            	}	
			}

            Map<String, String> defaultValueMap = new HashMap<String, String>();
            //spbcsyj, spbshyj, spbpzyj, js, djkxbnr, txql, bgjysm, qlsx, dyje

            defaultValueMap.put("spbcsyj_default", spbcsyj_default);            
            defaultValueMap.put("spbfjyj_default", spbfjyj_default);
            defaultValueMap.put("spbshyj_default", spbshyj_default);
            defaultValueMap.put("spbpzyj_default", spbpzyj_default);
            defaultValueMap.put("spbqsly_default", spbqsly_default);
            defaultValueMap.put("js_default", js_default);
            defaultValueMap.put("djkxbnr_default", djkxbnr_default);
            defaultValueMap.put("txql_default", txql_default);
            defaultValueMap.put("qlsx_default", qlsx_default);
            defaultValueMap.put("dyje_default", dyje_default);

//		formDoc.addHiddenData("spbcsyj_default", spbcsyj_default);
//		formDoc.addHiddenData("spbshyj_default", spbshyj_default);
//		formDoc.addHiddenData("spbpzyj_default", spbpzyj_default);
//		formDoc.addHiddenData("js_default", js_default);
//		formDoc.addHiddenData("djkxbnr_default", djkxbnr_default);
//		formDoc.addHiddenData("txql_default", txql_default);
//		formDoc.addHiddenData("qlsx_default", qlsx_default);
//		formDoc.addHiddenData("dyje_default", dyje_default);

            defaultValueMap.put("spbcsyj_new", spbcsyj);
            defaultValueMap.put("spbfjyj_new", spbfjyj);
            defaultValueMap.put("spbshyj_new", spbshyj);
            defaultValueMap.put("spbpzyj_new", spbpzyj);
            defaultValueMap.put("js_new", js);
            defaultValueMap.put("djkxbnr_new", djkxbnr);
            defaultValueMap.put("txql_new", txql);
            defaultValueMap.put("qlsx_new", qlsx);
            defaultValueMap.put("dyje_new", dyje + "");
            defaultValueMap.put("tdzh", tdzh);
            defaultValueMap.put("rmzf", rmzf);
            defaultValueMap.put("projectId", proId);
            defaultValueMap.put("sz", sz);

//		formDoc.addHiddenData("spbcsyj_new", spbcsyj);
//		formDoc.addHiddenData("spbshyj_new", spbshyj);
//		formDoc.addHiddenData("spbpzyj_new", spbpzyj);
//		formDoc.addHiddenData("js_new", js);
//		formDoc.addHiddenData("djkxbnr_new", djkxbnr);
//		formDoc.addHiddenData("txql_new", txql);
//		formDoc.addHiddenData("qlsx_new", qlsx);
//		formDoc.addHiddenData("dyje_new", dyje+"");
//		formDoc.addHiddenData("tdzh", tdzh);
//		formDoc.addHiddenData("rmzf", rmzf);
//		formDoc.addHiddenData("projectId", proId);
//		formDoc.addHiddenData("sz", sz);

            if (sqlx != null && !sqlx.equals("")) {
            	ILimitFieldService limitFieldService = (ILimitFieldService)Container.getBean("limitFieldService");
            	IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
            	String remark = platUtil.getPfActivityNameByTaskId(taskId);
                String limitField = limitFieldService.getLimitFieldString(sqlx, "zd_qssp",remark);
                limitField = limitField.toUpperCase();//转换成大写，javascript操作
                defaultValueMap.put("limitField", limitField);
//			    formDoc.addHiddenData("limitField", limitField);
            }
            if (sqlx != null && sqlx.equals("分割证换发证")) {
                String fgzh = spbDefault.getZtdzh();
                if (fgzh != null && !fgzh.equals("")) {
                    IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
                    FGZ fgz = fgzService.getFGZByFgzh(fgzh);
                    if (fgz != null) {
//					formDoc.addHiddenData("jzmj", fgz.getJzmj().toString());
                        defaultValueMap.put("jzmj", fgz.getJzmj().toString());
                    }
                }
            }
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(defaultValueMap));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }


    public String getSqbDefaultValue() {
        //System.out.println("---------------------------getSqbDefaultValue");
        try {
            if (proId == null  || proId.length()==0) {
                ServletActionContext.getResponse().setCharacterEncoding("utf-8");
                ServletActionContext.getResponse().getWriter().println("");
                return null;
            }
            IProjectService projectService = (IProjectService) Container.getBean("projectService");
            Project project = (Project) projectService.getProject(proId);
            String djlx = project.getDjlx();

            String sqlx = "";
            String qsxz = "";
            String ztdzh = "";
            Double syqmj = 0.0;
            Double dymj = 0.0;
            Double ftmj = 0.0;
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            SQB sqb = (SQB) sqbService.getSQB(proId);
            if (sqb != null) {
                sqlx = sqb.getSqlx();
                qsxz = sqb.getQsxz();
                ztdzh = sqb.getZtdzh();
                syqmj = sqb.getSyqmj();
                dymj = sqb.getDymj();
                ftmj = sqb.getFtmj();
            } else {
                sqlx = djlx;
            }

            Map<String, String> defaultValueMap = new HashMap<String, String>();
            //读取默认意见
            ISHEETINFOService sheetinfoService = (ISHEETINFOService) Container.getBean("sheetInfoService");
            SHEETINFO sheetinfo = sheetinfoService.getSHEETINFO(sqlx);
            String txql_default = "";
            String qlsx_default = "";
            String dyje_default = "";
            String bgjysm_default = "";
            if (sheetinfo != null) {
                txql_default = sheetinfo.getTxql();
                qlsx_default = sheetinfo.getQlsx();
                dyje_default = sheetinfo.getDyje();
                bgjysm_default = sheetinfo.getBgjysm();
            }
            txql_default = txql_default.replace("ztdzh", ztdzh);
            defaultValueMap.put("bgjysm_default", bgjysm_default);
            defaultValueMap.put("txql_default", txql_default);
            defaultValueMap.put("qlsx_default", qlsx_default);
            defaultValueMap.put("dyje_default", dyje_default);
            if(sqb!=null){
             defaultValueMap.put("txql_new", sqb.getTxql());
             defaultValueMap.put("dyje_new", sqb.getDyje() + "");
             defaultValueMap.put("bgjysm_new", sqb.getSqdjdnr());
            }else{
            	 defaultValueMap.put("txql_new", "");
            	 defaultValueMap.put("dyje_new", "" + "");
                 defaultValueMap.put("bgjysm_new","");
            }
         
           
            defaultValueMap.put("ztdzh", ztdzh);

//		formDoc.addHiddenData("bgjysm_default", bgjysm_default);
//		formDoc.addHiddenData("txql_default", txql_default);
//		formDoc.addHiddenData("qlsx_default", qlsx_default);
//		formDoc.addHiddenData("dyje_default", dyje_default);
//		formDoc.addHiddenData("txql_new", sqb.getTxql());
//		formDoc.addHiddenData("dyje_new", sqb.getDyje()+"");
//		formDoc.addHiddenData("bgjysm_new", sqb.getSqdjdnr());
//		formDoc.addHiddenData("ztdzh", ztdzh);
            ILimitFieldService limitFieldService = (ILimitFieldService)Container.getBean("limitFieldService");
            IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
        	String remark = platUtil.getPfActivityNameByTaskId(taskId);
            String limitField = limitFieldService.getLimitFieldString(sqlx, "zd_sqdj",remark);
             limitField=limitField.toUpperCase();
            defaultValueMap.put("limitField", limitField);
            defaultValueMap.put("syqmj", ftmj.toString());
            defaultValueMap.put("ztdzh", ztdzh);
            defaultValueMap.put("dymj", dymj.toString());

            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(defaultValueMap));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
     public String getSjdDefaultValue() {
          //System.out.println("---------------------------getSJDDefaultValue");
        try {
            if (proId == null  || proId.length()==0) {
                ServletActionContext.getResponse().setCharacterEncoding("utf-8");
                ServletActionContext.getResponse().getWriter().println("");
                return null;
            }
            IProjectService projectService = (IProjectService) Container.getBean("projectService");
            Project project = (Project) projectService.getProject(proId);
            String djlx = project.getDjlx();

            String sqlx = "";
            String qsxz = "";
            String rmzf = "";
            XZQ xzq = new XZQ();
		    xzq = CommonUtil.getXZQ();
		    rmzf = xzq.getXzqName();
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            SQB sqb = (SQB) sqbService.getSQB(proId);
            if (sqb != null) {
                sqlx = sqb.getSqlx();
		        qsxz = sqb.getQsxz();
            } else {
                ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
                SJD sjd = sjdService.getSJD(proId);
                sqlx = sjd.getSqlx();
                if (sqlx == null || sqlx.equals(""))sqlx = djlx;
            }
           if (qsxz.equals("国有建设用地使用权") || qsxz.equals("国有农用地使用权") ) {
                qsxz="国有土地使用权";
            }else if (qsxz.equals("集体建设用地使用权") || qsxz.equals("集体农用地使用权") || qsxz.equals("宅基地使用权")){
                qsxz="集体土地使用权";
            }
            ISJDCLService sjdclService = (ISJDCLService)Container.getBean("sjdClService");
		    boolean isHaveSjdcl = sjdclService.isSaveSJDCL(proId);
            Map<String, String> defaultValueMap = new HashMap<String, String>();
            //读取默认意见
           SAXReader sr=new SAXReader();
		   Document document=null;
           try{
                document=sr.read(new File(getPath() + "conf/tddj/sqlx.xml"));
            }catch (DocumentException e){
                e.printStackTrace();
            }
            Element root = document.getRootElement();
            List nodeList = root.selectNodes("djlx");
           for (int i=0;i<nodeList.size();i++){
                Element one = (Element)nodeList.get(i);  //获得  DJLX 节点
                if (djlx.equals(one.attribute("text").getValue())){    //获得 DJLX 节点 属性TEXT的值

                    //formDoc.delSelectConfig("sqlx");// 清空选项
                    List nodeList1=one.selectNodes("qsxz");
                    for (int j=0;j<nodeList1.size();j++){
                        Element two=(Element)nodeList1.get(j);//获得  QSXZ 节点
                        if (qsxz.equals(two.attribute("text").getValue())){   //获得QSXZ 节点 属性TEXT的值

                           // formDoc.delSelectConfig("sqlx"); // 清空选项
                            List nodeList2=two.selectNodes("sqlx");
                            //System.out.println(nodeList2.size());
                            for (int k=0;k<nodeList2.size();k++){
                                Element three=(Element)nodeList2.get(k);
                              //  formDoc.addSelectConfig("sqlx", three.getText(),three.getText());
                            }
                            //formDoc.addSelectConfig("sqlx", sqlx, sqlx);
                            //System.out.println("break+in");
                            break;
                        }
                    }
                    break;
                }
		   }
       ILimitFieldService limitFieldService = (ILimitFieldService)Container.getBean("limitFieldService");
       IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
   	   String remark = platUtil.getPfActivityNameByTaskId(taskId);
       String limitField = limitFieldService.getLimitFieldString(sqlx, "tbl_sjd",remark);
       //defaultValueMap.put("sqlx", sqlx);
		defaultValueMap.put("limitField", limitField);
		// 添加隐藏值

		if (!sqlx.equals("")) {
			defaultValueMap.put("ProjectSqlx", sqlx);
		} else {
		   defaultValueMap.put("ProjectSqlx", "NODATA");
		}
		// 添加隐藏值

		if (isHaveSjdcl) {
			 defaultValueMap.put("have_zjmc", "HAVEDATA");
		} else {
			 defaultValueMap.put("have_zjmc", "NODATA");
		}
		 defaultValueMap.put("djlx", djlx);
		 defaultValueMap.put("proId", proId);
		 defaultValueMap.put("rmzf", rmzf);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(defaultValueMap));
        } catch (Exception ex) {
            ex.printStackTrace();
        }

         return Action.NONE;
     }

     public String getYydjDefaultValue() {
            try {
                if (proId == null  || proId.length()==0) {
                    ServletActionContext.getResponse().setCharacterEncoding("utf-8");
                    ServletActionContext.getResponse().getWriter().println("");
                    return null;
                }
                Map<String, String> defaultValueMap = new HashMap<String, String>();
                String sqlx = "";
                ISJDService sjdService = (ISJDService)Container.getBean("sjdService");
                SJD sjd = sjdService.getSJD(proId);
                ILimitFieldService limitFieldService = (ILimitFieldService)Container.getBean("limitFieldService");
                IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
            	   String remark = platUtil.getPfActivityNameByTaskId(taskId);
                String limitField = limitFieldService.getLimitFieldString(sqlx, "tbl_yydj",remark);
                defaultValueMap.put("limitField", limitField.toUpperCase());
            }catch(Exception ex){
                ex.printStackTrace();
            }
            return null;
     }
    private String getPath() {
		/**
		 * 用途：获取架包相对路径 用于定位xml文件
		 * 参数：

		 * 修改日期：

		 * 修改人：
		 */
    
		return this.getClass().getResource("/").getPath();
	 }


   
//       public static void  main(String [] argv){
//            SheetDefautValueAction sv= new SheetDefautValueAction();
//             String str =sv.getPath();
//              System.out.println(str);
//    }
}
