package com.jsegov.tddj.action;

import com.gtis.spring.Container;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISJDService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.services.interf.IZD_DJDCBService;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SJD;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.ZD_DJDCB;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;

public class ReadDJhToProjectAction extends ActionSupport {

    /**
     *
     */
    private static final long serialVersionUID = -772930246193537299L;

    private String djh;
    private String projectId;
    private String readDjdcb;
    private String qlrmc;
    private String chh;
    private String uniqueId;


    public String getChh() {
        return chh;
    }

    public void setChh(String chh) {
        this.chh = chh;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    @Override
    public String execute() throws Exception {
        // TODO Auto-generated method stub
        try {
            IProjectService projectService = (IProjectService) Container.getBean("projectService");
            Project project = projectService.getProject(projectId);
            ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
            SQB sqb = sqbService.getSQB(projectId);
            ISPBService spbService = (ISPBService) Container.getBean("spbService");
            SPB spb = spbService.getSPB(projectId);
            project.setDjh(djh);
            projectService.updateProject(project);
            ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
            SJD sjd = sjdService.getSJD(projectId);
            String zl = "";

            IZD_DJDCBService djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
            if (readDjdcb != null && readDjdcb.equals("true")) {
                ZD_DJDCB pamdjdcb = new ZD_DJDCB();
                pamdjdcb.setDjh(project.getDjh());
                pamdjdcb.setQlrmc(qlrmc);
                ZD_DJDCB djdcb = djdcbService.selectDjdcb(pamdjdcb);
                if (djdcb != null)
                    zl = djdcb.getTdzl();
                if (sqb != null && djdcb != null) {
                    sqb = sqbService.readDJDCB(sqb, djdcb, 1);
                    if (spb == null) {
                        spb = new SPB();
                        spb = spbService.readSQB(spb, sqb);
                        spbService.insertSPB(spb);
                    } else {
                        sqbService.updateSQB(sqb);
                        spb = spbService.readSQB(spb, sqb);
                        spbService.updateSPB(spb);
                    }
                }
            } else {
                zl = sjd.getZl();
                if (sqb != null) {
                    sqb.setDjh(djh);
                    sqbService.updateSQB(sqb);
                }
                if (spb != null) {
                    spb.setDjh(djh);
                    spbService.updateSPB(spb);
                }
            }
            IPlatUtil platUtil = (IPlatUtil) Container.getBean("platUtil");
            platUtil.editWorkFlowInstance(projectId, djh + " || " + zl, project.getProjectName());
        } catch (Exception e) {
            // TODO: handle exception
            e.printStackTrace();
            System.out.println("读取新地籍号出现问题，请检查！");
        }

        return Action.NONE;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getReadDjdcb() {
        return readDjdcb;
    }

    public void setReadDjdcb(String readDjdcb) {
        this.readDjdcb = readDjdcb;
    }


}
