package com.jsegov.tddj.action;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.jsegov.tddj.services.interf.*;
import com.jsegov.tddj.vo.*;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.util.CommonUtil;
import com.opensymphony.xwork2.ActionSupport;

public class ReSelectDjdcb extends ActionSupport {
    /**
     * 地籍调查表查询重新选择
     */
    private static final long serialVersionUID = 102075653434624095L;
    private SplitParam splitParam;
    private ZD_DJDCB djdcb = new ZD_DJDCB();
    private QSZD_DJDCB qszd_djdcb = new QSZD_DJDCB();
    private String activityName;
    private String jzdNum;
    private String rtnMsg = "OK";
    private String oldDjh;

    public String getOldDjh() {
        return oldDjh;
    }

    public void setOldDjh(String oldDjh) {
        this.oldDjh = oldDjh;
    }

    public String getRtnMsg() {
        return rtnMsg;
    }

    public void setRtnMsg(String rtnMsg) {
        this.rtnMsg = rtnMsg;
    }
    public String getJzdNum() {
        return jzdNum;
    }

    public void setJzdNum(String jzdNum) {
        this.jzdNum = jzdNum;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public ZD_DJDCB getDjdcb() {
        return djdcb;
    }

    public void setDjdcb(ZD_DJDCB djdcb) {
        this.djdcb = djdcb;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    // 点击重新选择按钮事件
    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        String qlrmc = URLDecoder.decode(request.getParameter("qlrmc"),"utf-8");
//        String djh = request.getParameter("djh");
        String qsxz = request.getParameter("djdcb.qsxz");
        djdcb.setQsxz(qsxz);
//        djdcb.setDjh(djh);
        djdcb.setQlrmc(qlrmc);
        SplitParamImpl s = new SplitParamImpl();
        // 判断权属性质 通过获取来的地籍号和权利人

        if (!qsxz.equals("3")) {
            //ZD_DJDCB queryDjdcb = new ZD_DJDCB();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map = CommonUtil.getDjhQuery(request,map);

//            if (!djh.equals("")) {
//                //queryDjdcb.setDjh("%" + djh + "%");
//                map.put("djh", "%" + djdcb.getDjh() + "%");
//            }
            if (!qlrmc.equals("")) {
                //queryDjdcb.setQlrmc("%" + qlrmc + "%");
                map.put("qlrmc", "%" + djdcb.getQlrmc() + "%");
            }
            //s.setQueryString("selectDJDCB");
            //s.setQueryParam(queryDjdcb);
            if (djdcb.getQsxz() != null && !djdcb.getQsxz().equals("")) {
                // queryDjdcb.setQsxz("%"+djdcb.getQsxz()+"%");
                map.put("qsxz", djdcb.getQsxz()+"%");
            }

            s.setQueryString("selectDJDCBForSplit");
            s.setQueryParam(map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
//            if (!djh.equals("")) {
//                map.put("djh", "%" + djh + "%");
//            }
            if (!qlrmc.equals("")) {
                map.put("qlrmc", "%" + qlrmc + "%");
            }

            s.setQueryString("selectSYQDCB");
            s.setQueryParam(map);
        }
        // s.setQueryString("listDJDCB");

        this.splitParam = s;
        return SUCCESS;
    }

    // 重新选择页面查询调查表

    public String queryDjdcb() {
        HttpServletRequest request = ServletActionContext.getRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map=CommonUtil.getDjhQuery(request,map);

        if (djdcb.getDjh() != null && !djdcb.getDjh().equals("")) {
            // queryDjdcb.setDjh("%"+djdcb.getDjh()+"%");
            map.put("djh", "%" + djdcb.getDjh() + "%");
        }
        if (djdcb.getQlrmc() != null && !djdcb.getQlrmc().equals("")) {
            // queryDjdcb.setQlrmc("%"+djdcb.getQlrmc()+"%");
            map.put("qlrmc", "%" + djdcb.getQlrmc() + "%");
        }
        if (djdcb.getTdzl() != null && !djdcb.getTdzl().equals("")) {
            // queryDjdcb.setTdzl("%"+djdcb.getTdzl()+"%");
            map.put("tdzl", "%" + djdcb.getTdzl() + "%");
        }
        if (djdcb.getQsxz() != null && !djdcb.getQsxz().equals("")) {
            // queryDjdcb.setQsxz("%"+djdcb.getQsxz()+"%");
            map.put("qsxz", djdcb.getQsxz()+"%");
        }
        if(StringUtils.isNotBlank(oldDjh)){
            IZDDZBService zddzbService = (IZDDZBService) Container.getBean("zddzbService");
            List<ZDDZB> zddzbList = zddzbService.selectNewDjhFromZddzb("%"+oldDjh+"%");
            String addDjh = null;
            //oracle in只支持1000个
            if(zddzbList!=null && zddzbList.size()>1000){
                rtnMsg = "模糊匹配数据超过1000条，请输入更精确的老地号信息";
                int i = 0;
                for(ZDDZB zddzb :zddzbList){
                    if(zddzb!=null){
                        if(addDjh == null){
                            addDjh = "('"+zddzb.getDh()+"'";
                        }else{
                            addDjh += ",'"+zddzb.getDh()+"'";
                        }
                    }
                    i++;
                    if(i==1000){
                        break;
                    }
                }
                if(addDjh!=null){
                    addDjh += ")";
                }
                map.put("addDjh",addDjh);
            }else{
                for(ZDDZB zddzb :zddzbList){
                    if(zddzb!=null){
                        if(addDjh == null){
                            addDjh = "('"+zddzb.getDh()+"'";
                        }else{
                            addDjh += ",'"+zddzb.getDh()+"'";
                        }
                    }
                }
                if(addDjh!=null){
                    addDjh += ")";
                }
                map.put("addDjh",addDjh);
            }
        }

        SplitParamImpl s = new SplitParamImpl();
        if (!djdcb.getQsxz().equals("3")) {
            //s.setQueryString("listDCB");
            s.setQueryString("selectDJDCBForSplit");
        } else {
            s.setQueryString("selectSYQDCB");
        }
        s.setQueryParam(map);
        this.splitParam = s;
        return SUCCESS;
    }

    // 点击“申请表”-“审批表”时读取调查表

    public String readDjdcb() {
        String projectId = "";
        String taskId = "";
        HttpServletRequest request = ServletActionContext.getRequest();
        IPlatUtil platUtil=(IPlatUtil)Container.getBean("platUtil");
        if (request.getParameter("proid") != null)
            projectId = request.getParameter("proid").toString();
        if (request.getParameter("taskid") != null)
            taskId = request.getParameter("taskid").toString();
        activityName = platUtil.getPfActivityNameByTaskId(taskId);
        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        SQB sqb = (SQB) sqbService.getSQB(projectId);

        if(sqb == null) return "djdcb";

        String sqlx = sqb.getSqlx();
        if (!sqlx.equals("") && sqlx.indexOf("所有权") > -1) {
            if (!sqb.getDjh().equals("")) {
                qszd_djdcb.setDjh(sqb.getDjh());
                qszd_djdcb.setTdsyzmc(sqb.getRf1_dwmc());
                qszd_djdcb.setQsxz("3");
                IQSZD_DJDCBService djdcbService = (IQSZD_DJDCBService) Container.getBean("qszd_DjdcbService");
                qszd_djdcb = djdcbService.selectDjdcb(qszd_djdcb);
                qszd_djdcb.setQsxz("集体土地所有权");
                //System.out.println(CommonUtil.formateDate(qszd_djdcb.getDcrq()));
                //System.out.println(qszd_djdcb.getZygdwzsm().replaceAll("\n", "<br>"));
                //System.out.println(qszd_djdcb.getZyjxzxsm().replaceAll("\n", "<br>"));
                //System.out.println(qszd_djdcb.getZdbfgsm().replaceAll("\n", "<br>"));
                //System.out.println(qszd_djdcb.getQtsm().replaceAll("\n", "<br>"));
                //System.out.println(qszd_djdcb.getTdqsjzdcjs().replaceAll("\n", "<br>"));
                if (qszd_djdcb.getZygdwzsm() !=null){
                    request.setAttribute("zygdwzsm", qszd_djdcb.getZygdwzsm().replaceAll("\n", "<br>"));
                }else{
                    request.setAttribute("zygdwzsm", "");
                }
                if (qszd_djdcb.getZyjxzxsm() != null){
                    request.setAttribute("zyjxzxsm", qszd_djdcb.getZyjxzxsm().replaceAll("\n", "<br>"));
                }else{
                    request.setAttribute("zyjxzxsm", "");
                }
                if (qszd_djdcb.getZdbfgsm() != null){
                    request.setAttribute("zdbfgsm", qszd_djdcb.getZdbfgsm().replaceAll("\n", "<br>"));
                }else{
                    request.setAttribute("zdbfgsm", "");
                }
                if (qszd_djdcb.getQtsm() != null){
                    request.setAttribute("qtsm", qszd_djdcb.getQtsm().replaceAll("\n", "<br>"));
                }else{
                    request.setAttribute("qtsm", "");
                }
                if (qszd_djdcb.getTdqsjzdcjs() != null){
                    request.setAttribute("tdqsjzdcjs", qszd_djdcb.getTdqsjzdcjs().replaceAll("\n", "<br>"));
                }else{
                    request.setAttribute("tdqsjzdcjs", "");
                }
                if (qszd_djdcb.getDcrq() != null){
                    request.setAttribute("dcrq", CommonUtil.formateDate(qszd_djdcb.getDcrq()));
                }else{
                    request.setAttribute("dcrq", "");
                }

            } else {
                qszd_djdcb.setTdsyzmc(sqb.getRf1_dwmc());
                qszd_djdcb.setTdzl(sqb.getZl());
                qszd_djdcb.setQsxz("3");
            }

            return "djdcb_syq";
        } else {
            if (!sqb.getDjh().equals("")) {
                djdcb.setDjh(sqb.getDjh());
                IZD_DJDCBService djdcbService = (IZD_DJDCBService) Container.getBean("zdDjdcbService");
                djdcb = djdcbService.selectDjdcb(djdcb);

                if (sqb.getSqlx().equals("土地使用权抵押权初始登记")
                        || sqb.getSqlx().equals("他项权利证明书注销登记")) {
                    djdcb.setQlrmc(sqb.getRf2_dwmc());
                } else {
                    djdcb.setQlrmc(sqb.getRf1_dwmc());
                }
            } else {
                /*
                     * if (!sqb.getRf2_dwmc().equals("") &&
                     * !sqb.getSqlx().equals("土地使用权抵押权初始登记") &&
                     * !sqb.getSqlx().equals("他项权利证明书注销登记")){
                     * djdcb.setQlrmc(sqb.getRf2_dwmc()); }else{
                     * djdcb.setQlrmc(sqb.getRf1_dwmc()); }
                     */

                if (sqb.getSqlx().equals("土地使用权抵押权初始登记")
                        || sqb.getSqlx().equals("他项权利证明书注销登记")) {

                    djdcb.setQlrmc(sqb.getRf2_dwmc());
                } else {
                    djdcb.setQlrmc(sqb.getRf1_dwmc());
                }
                // djdcb.setQlrmc(sqb.getRf1_dwmc());
                djdcb.setTdzl(sqb.getZl());
            }

            if (djdcb.getKzrq() != null && !djdcb.getKzrq().equals(""))
                djdcb.setKzrq(CommonUtil.formateDateToString(djdcb.getKzrq()));
            if (djdcb.getDcrq() != null && !djdcb.getDcrq().equals(""))
                djdcb.setDcrq(CommonUtil.formateDateToString(djdcb.getDcrq()));
            IZD_JZBSBService zd_jzbsbService = (IZD_JZBSBService) Container
                    .getBean("zdJzbsbService");
            jzdNum = zd_jzbsbService.statJzdNum(sqb.getDjh());
            return "djdcb";
        }
    }

    // 重新选择页面关联调查表

    public void relateDjdcb() throws IOException {
        // 将选择的地籍号插入申请表+平台项目表

        // System.out.println("relateDjdcb");
        HttpServletRequest request = ServletActionContext.getRequest();
        //String qlrmc = new String(request.getParameter("qlrmc").getBytes("ISO8859_1"),"GBK");
        String djh = request.getParameter("djh");
        String projectId = request.getParameter("projectId");
        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        SQB sqb = sqbService.getSQB(projectId);
        sqb.setDjh(djh);
        sqbService.updateSQB(sqb);

        // 泰州更新变更证的新老地号

        // String ztdzh = sqb.getZtdzh();
        // if (ztdzh!=null && !ztdzh.equals("")){
        // if (ztdzh.indexOf("国用")>-1){
        // GytdsyzService gytdsyzService = (GytdsyzService)
        // Container.getBean("gyTdsyzService");
        // GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(ztdzh);
        // if (gytdsyz!=null){
        // gytdsyz.setBz(gytdsyz.getDjh());
        // gytdsyz.setDjh(djh);
        // gytdsyzService.updateGYTDSYZ(gytdsyz);
        // }
        // }else if (ztdzh.indexOf("集用")>-1){
        // JttdsyzService jttdsyzService = (JttdsyzService)
        // Container.getBean("jtTdsyzService");
        // JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(ztdzh);
        // if (jttdsyz != null){
        // jttdsyz.setBz(jttdsyz.getDjh());
        // jttdsyz.setDjh(djh);
        // jttdsyzService.updateJTTDSYZ(jttdsyz);
        // }
        // }
        // }
        // 更新平台
        // PlatUtil.editWorkFlowInstance(projectId, sqb.getZl(), qlrmc);
        IPlatUtil platUtil=(IPlatUtil)Container.getBean("platUtil");
        platUtil.editWorkFlowInstance(projectId, djh+" || "+sqb.getZl(), "");

        IProjectService projectService = (IProjectService) Container
                .getBean("projectService");
        Project project = projectService.getProject(projectId);
        // project.setProjectName(qlrmc);
        project.setDjh(djh);
        projectService.updateProject(project);
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("text/xml;charset=GBK");
        String returnMessage = "OK";
        response.getOutputStream().write(returnMessage.toString().getBytes());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    // 重新选择页面拷贝调查表数据至申请表

    public void copyDjdcbToSQB() throws IOException {
        // System.out.println("copyDjdcbToSQB");
        HttpServletRequest request = ServletActionContext.getRequest();
        String qlrmc = new String(request.getParameter("qlrmc").getBytes(
                "ISO8859_1"), "GBK");
        String djh = request.getParameter("djh");
        String qsxz = request.getParameter("qsxz");
        String projectId = request.getParameter("projectId");
        // System.out.println("relateDjdcb"+qlrmc+djh+projectId);
        String tdzl = "";
        // 更新项目表

        IProjectService projectService = (IProjectService) Container
                .getBean("projectService");
        Project project = projectService.getProject(projectId);
        project.setProjectName(qlrmc);
        project.setDjh(djh);
        projectService.updateProject(project);

        // 更新申请表

        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        SQB sqb = sqbService.getSQB(projectId);
        if (!qsxz.equals("3")) {
            IZD_DJDCBService zd_djdcbService = (IZD_DJDCBService) Container
                    .getBean("zdDjdcbService");
            ZD_DJDCB queryDjdcb = new ZD_DJDCB();
            queryDjdcb.setDjh(djh);
            queryDjdcb.setQlrmc(qlrmc);
            queryDjdcb = zd_djdcbService.selectDjdcb(queryDjdcb);
            tdzl = queryDjdcb.getTdzl();
            Integer rfNum = 1;
            // if (!sqb.getRf2_dwmc().equals("")){
            // rfNum = 2;
            // }
            // sqbService.updateSQB(sqb, queryDjdcb, rfNum);
            sqbService.readDJDCB(sqb, queryDjdcb, rfNum);
        } else {
            IQSZD_DJDCBService qszd_djdcbService = (IQSZD_DJDCBService) Container
                    .getBean("qszd_DjdcbService");
            QSZD_DJDCB queryDjdcb = new QSZD_DJDCB();
            queryDjdcb.setDjh(djh);
            queryDjdcb.setTdsyzmc(qlrmc);
            queryDjdcb = qszd_djdcbService.selectDjdcb(queryDjdcb);
            tdzl = queryDjdcb.getTdzl();
            Integer rfNum = 1;
            // if (!sqb.getRf2_dwmc().equals("")){
            // rfNum = 2;
            // }
            // sqbService.updateSQB(sqb, queryDjdcb, rfNum);
            // 暂时这样写

            sqbService.readSYQDCB(sqb, queryDjdcb, rfNum);
        }

        // sqbService.insertSQB(sqb);
        sqbService.updateSQB(sqb);
        // 更新平台
        IPlatUtil platUtil=(IPlatUtil)Container.getBean("platUtil");
        platUtil.editWorkFlowInstance(projectId, djh+" || "+tdzl, qlrmc);
        // 更新收件单

        ISJDService sjdService = (ISJDService) Container.getBean("sjdService");
        SJD sjd = sjdService.getSJD(projectId);
        sjd.setJjr(qlrmc);
        sjd.setZl(tdzl);
        sjdService.updateSJD(sjd);
        // 泰州更新变更证的新老地号

        // String ztdzh = sqb.getZtdzh();
        // if (ztdzh!=null && !ztdzh.equals("")){
        // if (ztdzh.indexOf("国用")>-1){
        // GytdsyzService gytdsyzService = (GytdsyzService)
        // Container.getBean("gyTdsyzService");
        // GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(ztdzh);
        // if (gytdsyz!=null){
        // gytdsyz.setBz(gytdsyz.getDjh());
        // gytdsyz.setDjh(djh);
        // gytdsyzService.updateGYTDSYZ(gytdsyz);
        // }
        // }else if (ztdzh.indexOf("集用")>-1){
        // JttdsyzService jttdsyzService = (JttdsyzService)
        // Container.getBean("jtTdsyzService");
        // JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZByTdzh(ztdzh);
        // if (jttdsyz != null){
        // jttdsyz.setBz(jttdsyz.getDjh());
        // jttdsyz.setDjh(djh);
        // jttdsyzService.updateJTTDSYZ(jttdsyz);
        // }
        // }
        // }
        HttpServletResponse response = ServletActionContext.getResponse();
        response.setContentType("text/xml;charset=GBK");
        String returnMessage = "OK";
        response.getOutputStream().write(returnMessage.toString().getBytes());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    public QSZD_DJDCB getQszd_djdcb() {
        return qszd_djdcb;
    }

    public void setQszd_djdcb(QSZD_DJDCB qszd_djdcb) {
        this.qszd_djdcb = qszd_djdcb;
    }
}
