package com.jsegov.tddj.action;

import java.io.IOException;
import java.util.HashMap;

import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.services.interf.IZDDZBService;
import com.jsegov.tddj.vo.ZDDZB;
import com.opensymphony.xwork2.ActionSupport;

public class QureyDjhHistoryAction extends ActionSupport{
	private String zdUniqueId;
	private String dh;
	private String dhXh;
	private String zhlx;
	private SplitParam splitParam;
	private String dzbIds;
	private IZDDZBService zddzbService;
	private ZDDZB zddzb;
	
	public String execute(){
		HashMap<String, String> map = new HashMap<String, String>();
		IZDDZBService zddzbService = (IZDDZBService)Container.getBean("zddzbService");
		if (StringUtils.isNotEmpty(dh)) {
			HashMap<String, String> tempMap = new HashMap<String, String>();
			tempMap.put("dh", dh);
			ZDDZB zddzb = zddzbService.selectZDDZB(tempMap);
			if(zddzb!=null){
				map.put("zdUniqueId", zddzb.getZdUniqueId());
			}
		}
		if(StringUtils.isNotEmpty(zdUniqueId)){
			map.remove("zdUniqueId");
			map.put("zdUniqueId", "%"+zdUniqueId+"%");
		}
		if (StringUtils.isNotEmpty(dhXh)) {
			map.put("dhXh", "%"+dhXh+"%");
		}
		if (StringUtils.isNotEmpty(zhlx)) {
			map.put("zhlx", "%"+zhlx+"%");
		}
		SplitParamImpl s = new SplitParamImpl();
		s.setQueryString("queryZDDZB");
		s.setQueryParam(map);
		this.splitParam = s;
		return SUCCESS;
	}
	
	public String delDzb() throws IOException{
		String resultMsg="";
		if(StringUtils.isNotBlank(dzbIds)){
			String[] dzbId=dzbIds.split(",");
			for(String dzbid:dzbId){
				if(StringUtils.isNotBlank(dzbid)){
					try {
						zddzbService.deleteZDDZB(dzbid);
					} catch (Exception e) {
						LOG.error("删除失败:",e);
						resultMsg="删除"+dzbid+"失败！";
					}
				}
			}
			resultMsg="OK";
		}else{
			resultMsg="删除失败！";
		}
		ServletActionContext.getResponse().setContentType("text/xml;charset=GBK");
		ServletActionContext.getResponse().getOutputStream().write(resultMsg.getBytes());
		ServletActionContext.getResponse().getOutputStream().flush();
		ServletActionContext.getResponse().getOutputStream().close();
		return NONE;
	}
	
	public String updateDzb() throws IOException{
		String resultMsg="";
		try {
			zddzbService.updateZDDZB(zddzb);
			resultMsg = "OK";
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			resultMsg = "更新失败！";
		}
		ServletActionContext.getResponse().setContentType("text/xml;charset=GBK");
		ServletActionContext.getResponse().getOutputStream().write(resultMsg.getBytes());
		ServletActionContext.getResponse().getOutputStream().flush();
		ServletActionContext.getResponse().getOutputStream().close();
		return NONE;
	}
	
	public String insertDzb() throws IOException{
		String resultMsg="";
		try {
			if(StringUtils.isBlank(zddzb.getId())){
				zddzb.setId(UUIDGenerator.generate());
				zddzbService.insertZDDZB(zddzb);
				resultMsg = "OK";
			}
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			resultMsg = "新增失败！";
		}
		ServletActionContext.getResponse().setContentType("text/xml;charset=GBK");
		ServletActionContext.getResponse().getOutputStream().write(resultMsg.getBytes());
		ServletActionContext.getResponse().getOutputStream().flush();
		ServletActionContext.getResponse().getOutputStream().close();
		return NONE;
	}
	
	public SplitParam getSplitParam() {
		return splitParam;
	}
	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}
	public String getZdUniqueId() {
		return zdUniqueId;
	}
	public void setZdUniqueId(String zdUniqueId) {
		this.zdUniqueId = zdUniqueId;
	}
	public String getDh() {
		return dh;
	}
	public void setDh(String dh) {
		this.dh = dh;
	}
	public String getDhXh() {
		return dhXh;
	}
	public void setDhXh(String dhXh) {
		this.dhXh = dhXh;
	}
	public String getZhlx() {
		return zhlx;
	}
	public void setZhlx(String zhlx) {
		this.zhlx = zhlx;
	}

	public String getDzbIds() {
		return dzbIds;
	}

	public void setDzbIds(String dzbIds) {
		this.dzbIds = dzbIds;
	}

	public IZDDZBService getZddzbService() {
		return zddzbService;
	}

	public void setZddzbService(IZDDZBService zddzbService) {
		this.zddzbService = zddzbService;
	}

	public ZDDZB getZddzb() {
		return zddzb;
	}

	public void setZddzb(ZDDZB zddzb) {
		this.zddzb = zddzb;
	}
	
}
