package com.jsegov.tddj.action;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IStatService;
import com.jsegov.tddj.util.CommonUtil;
import com.opensymphony.xwork2.ActionSupport;

public class QueryZDDJAction extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6797067610462631541L;
	private SplitParam splitParam;
	private Integer gyCount;
	private Integer zxgyCount;
	private Integer jtCount;
	private Integer zxjtCount;
	private Integer juCount;
	private Integer zxjuCount;
	private Integer txCount;
	private Integer zxtxCount;
	private Integer cfCount;
	private Integer jfCount;

	private String qlr;
	private String djh;
	private String tdzh;
	private String zslx;


	public String execute() throws Exception {

		String userDwdm = TddjUtil.getCurrentUserDwdm();
		
		IStatService statService = (IStatService) Container
				.getBean("statService");
		gyCount = statService.statGytdsyz(null, null, null, null, userDwdm);
		zxgyCount = statService.statGytdsyz(null, null, null, "1", userDwdm);
		jtCount = statService.statJttdsyz(null, null, null, null, userDwdm);
		zxjtCount = statService.statJttdsyz(null, null, null, "1", userDwdm);
		juCount = statService.statJttdsuz(null, null, null, null, userDwdm);
		zxjuCount = statService.statJttdsuz(null, null, null, "1", userDwdm);
		txCount = statService.statTxqlzms(null, null, null, null, userDwdm);
		zxtxCount = statService.statTxqlzms(null, null, null, "1", userDwdm);
		cfCount = statService.statCf(null, null, null, null, userDwdm);
		jfCount = statService.statCf(null, null, null, "1", userDwdm);
		return SUCCESS;
	}

	public String query() {
		HttpServletRequest request = ServletActionContext.getRequest();		
	
		String userDwdm = TddjUtil.getCurrentUserDwdm();
		
		IStatService statService = (IStatService) Container
				.getBean("statService");
		gyCount = statService.statGytdsyz(qlr, tdzh, djh, null, userDwdm);
		zxgyCount = statService.statGytdsyz(qlr, tdzh, djh, "1", userDwdm);
		jtCount = statService.statJttdsyz(qlr, tdzh, djh, null, userDwdm);
		zxjtCount = statService.statJttdsyz(qlr, tdzh, djh, "1", userDwdm);
		juCount = statService.statJttdsuz(qlr, tdzh, djh, null, userDwdm);
		zxjuCount = statService.statJttdsuz(qlr, tdzh, djh, "1", userDwdm);
		txCount = statService.statTxqlzms(qlr, tdzh, djh, null, userDwdm);
		zxtxCount = statService.statTxqlzms(qlr, tdzh, djh, "1", userDwdm);
		cfCount = statService.statCf(qlr, tdzh, djh, null, userDwdm);
		jfCount = statService.statCf(qlr, tdzh, djh, "1", userDwdm);
		return SUCCESS;
	}


	// 查看证书列表

	public String ViewZSList() throws UnsupportedEncodingException {
		HttpServletRequest request = ServletActionContext.getRequest();
		String userDwdm = TddjUtil.getCurrentUserDwdm();

        qlr=java.net.URLDecoder.decode(request.getParameter("qlr"),"UTF-8");
        tdzh=java.net.URLDecoder.decode(request.getParameter("tdzh"),"UTF-8");
        djh=java.net.URLDecoder.decode(request.getParameter("tdzh"),"UTF-8");
		if (request.getParameter("zslx") != null) {
			zslx = request.getParameter("zslx");
		}
//		try {
//			qlr = new String(request.getParameter("qlr").getBytes("ISO8859_1"),
//					"GBK");
//		} catch (UnsupportedEncodingException e) {
//			e.printStackTrace();
//		}
//		try {
//			tdzh = new String(request.getParameter("tdzh")
//					.getBytes("ISO8859_1"), "GBK");
//		} catch (UnsupportedEncodingException e) {
//			e.printStackTrace();
//		}
//		try {
//			djh = new String(request.getParameter("djh").getBytes("ISO8859_1"),
//					"GBK");
//		} catch (UnsupportedEncodingException e) {
//			e.printStackTrace();
//		}
		// System.out.println(qlr+tdzh+djh);
		HashMap<String, Object> map = new HashMap<String, Object>();
		map = CommonUtil.getDwdmQuery(request, map);
		SplitParamImpl s = new SplitParamImpl();

		if (tdzh != null && !tdzh.equals("")) {
			map.put("tdzh", "%" + tdzh + "%");
		}
		if (djh != null && !djh.equals("")) {
			map.put("djh", "%" + djh + "%");
		}
		if (qlr != null && !qlr.equals("")) {
			map.put("qlr", "%" + qlr + "%");
			map.put("bzxr", "%" + qlr + "%");
		}
		if (userDwdm != null && !userDwdm.equals("")) {
			map.put("dwdm", userDwdm);
		}
		if (zslx.equals("gytdsyz")) {
			s.setQueryString("queryGytdsyz");
			s.setQueryParam(map);
		} else if (zslx.equals("jttdsyz")) {
			s.setQueryString("queryJttdsyz");
			s.setQueryParam(map);
		} else if (zslx.equals("jttdsuz")) {
			s.setQueryString("queryJttdsuz");
			s.setQueryParam(map);
		} else if (zslx.equals("txqlzms")) {
			s.setQueryString("editTxqlzms");
			s.setQueryParam(map);
		} else if (zslx.equals("cf")) {
			s.setQueryString("queryCF");
			s.setQueryParam(map);
		}
		this.splitParam = s;
		return zslx;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getQlr() {
		return qlr;
	}

	public void setQlr(String qlr) {
		this.qlr = qlr;
	}

	public String getDjh() {
		return djh;
	}

	public void setDjh(String djh) {
		this.djh = djh;
	}

	public String getTdzh() {
		return tdzh;
	}

	public void setTdzh(String tdzh) {
		this.tdzh = tdzh;
	}

	public Integer getGyCount() {
		return gyCount;
	}

	public void setGyCount(Integer gyCount) {
		this.gyCount = gyCount;
	}

	public Integer getZxgyCount() {
		return zxgyCount;
	}

	public void setZxgyCount(Integer zxgyCount) {
		this.zxgyCount = zxgyCount;
	}

	public Integer getJtCount() {
		return jtCount;
	}

	public void setJtCount(Integer jtCount) {
		this.jtCount = jtCount;
	}

	public Integer getZxjtCount() {
		return zxjtCount;
	}

	public void setZxjtCount(Integer zxjtCount) {
		this.zxjtCount = zxjtCount;
	}

	public Integer getJuCount() {
		return juCount;
	}

	public void setJuCount(Integer juCount) {
		this.juCount = juCount;
	}

	public Integer getZxjuCount() {
		return zxjuCount;
	}

	public void setZxjuCount(Integer zxjuCount) {
		this.zxjuCount = zxjuCount;
	}

	public Integer getTxCount() {
		return txCount;
	}

	public void setTxCount(Integer txCount) {
		this.txCount = txCount;
	}

	public Integer getZxtxCount() {
		return zxtxCount;
	}

	public void setZxtxCount(Integer zxtxCount) {
		this.zxtxCount = zxtxCount;
	}

	public Integer getCfCount() {
		return cfCount;
	}

	public void setCfCount(Integer cfCount) {
		this.cfCount = cfCount;
	}

	public Integer getJfCount() {
		return jfCount;
	}

	public void setJfCount(Integer jfCount) {
		this.jfCount = jfCount;
	}

	public String getZslx() {
		return zslx;
	}

	public void setZslx(String zslx) {
		this.zslx = zslx;
	}
}