package com.jsegov.tddj.action;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IArchivesPostService;
import com.jsegov.tddj.util.CommonUtil;
import com.opensymphony.xwork2.ActionSupport;

public class QueryGdInfoAction extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5330488916418857331L;
	private SplitParam splitParam;
	private String zslx;
	private String tdzh;
	private String qlr;
	private String djh;
	private String zl;
	private String syqlx;
	private String fzrq1;
	private String fzrq2;
	private String zsno;
	
	private String yt;
	private String zsstate;
//	private String oldDjh;
	private String userDwdm;
	private String projectIds;
	private String isgd;
	

	private LinkedHashMap<String,String> zslxlist;
	private LinkedHashMap<String,String> zsstatelist;
	
	public QueryGdInfoAction() {
		
		this.zslxlist = new LinkedHashMap<String, String>();
		this.zslxlist.put("gytdsyz","国有土地使用证");
		this.zslxlist.put("jttdsyz","集体土地使用证");
		this.zslxlist.put("txqlzms", "他项权利证明书");
		this.zslxlist.put("jttdsuz","集体土地所有证");
		this.zsstatelist = new LinkedHashMap<String, String>();
		this.zsstatelist.put("0", "正常");
		this.zsstatelist.put("1", "注销");
		this.zsstatelist.put("2", "变更");
		this.zsstatelist.put("3", "部分抵押");
		this.zsstatelist.put("4", "完全抵押");
		this.zsstatelist.put("5", "部分租赁");
		this.zsstatelist.put("6", "完全租赁");
		this.zsstatelist.put("7", "部分变更");
		this.zsstatelist.put("8", "分割登记产生的证");
		this.zsstatelist.put("20", "房改房");   
	}	

	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();		
		
		HashMap<String, Object> map = new HashMap<String, Object>();
		
		map = CommonUtil.getDwdmQuery(request, map);
		if(map.get("dwdm")!=null)
			userDwdm = TddjUtil.getCurrentUserDwdm();
		SplitParamImpl s = new SplitParamImpl();
		// System.out.println("zslx=="+zslx);
		String queryTdzh = null;
		String queryDjh = null;
		String queryQlr = null;
		String queryZl = null;
		String querySyqlx = null;
		Date queryFzrq1 = null;
		Date queryFzrq2 = null;
		String queryZsNo = null;	
		String queryisgd = null;
	
		String queryYt = null;
		String queryZsstate = null;

		if (tdzh != null && !tdzh.equals("")) {
			queryTdzh = "%" + tdzh + "%";
		}
		if (djh != null && !djh.equals("")) {
			queryDjh = "%" + djh + "%";
		}
		if (qlr != null && !qlr.equals("")) {
			queryQlr = "%" + qlr + "%";
		}
		if (zl != null && !zl.equals("")) {
			queryZl = "%" + zl + "%";
		}
		if (syqlx != null && !syqlx.equals("")) {
			querySyqlx = "%" + syqlx + "%";
		}
		if (fzrq1 != null && !fzrq1.equals("")) {
			queryFzrq1 = CommonUtil.formateDateToStr(fzrq1);
		}
		if (fzrq2 != null && !fzrq2.equals("")) {
			queryFzrq2 = CommonUtil.formateDateToStr(fzrq2);
		}
		
		if (zsno != null && !zsno.equals("")) {
			queryZsNo = "%" + zsno + "%";
		}
		if (yt != null && !yt.equals("")) {
			queryYt = "%" + yt + "%";
		}

		if (zsstate != null && !zsstate.equals("")) {
			queryZsstate = zsstate;
		}
		if (isgd!=null && !isgd.equals("")){
			queryisgd = isgd;
		}

		
		map.put("tdzh", queryTdzh);
		map.put("djh", queryDjh);
		map.put("qlr", queryQlr);
		map.put("zl", queryZl);
		map.put("syqlx", querySyqlx);
		map.put("fzrq1", queryFzrq1);
		map.put("fzrq2", queryFzrq2);

		map.put("zsno", queryZsNo);
		map.put("yt", queryYt);
		map.put("islogout", queryZsstate);
		map.put("isGd", queryisgd);
		

//		IDHDZBService dhdzbService = (IDHDZBService)Container.getBean("dhDzbService");
//		map = dhdzbService.putNewDjhToMap(map, oldDjh, "a");
//		    if (djh != null && !djh.equals(""))
//	    	    map = dhdzbService.putOldDjhToMap(map, djh, "a");
			if (zslx == null || zslx.equals("gytdsyz")) {
				//s.setQueryString("queryGytdsyz");
				s.setQueryString("queryGytdsyzForGD");
				s.setQueryParam(map);
			} else if (zslx.equals("jttdsyz")) {
				//s.setQueryString("queryJttdsyz");
				s.setQueryString("queryJttdsyzForGD");
				s.setQueryParam(map);
			} else if (zslx.equals("jttdsuz")) {
				//s.setQueryString("queryJttdsuz");
				s.setQueryString("queryJttdsuzForGD");
				s.setQueryParam(map);
			} else if (zslx.equals("txqlzms")) {
				//s.setQueryString("editTxqlzms");
				s.setQueryString("queryTxqlzmsForGD");
				s.setQueryParam(map);
			}
		/*}*/
		// System.out.println("====="+map);
		this.splitParam = s;
		return SUCCESS;
	}
    public String plgd() throws Exception{
		
		try {
			if(projectIds!=null && !projectIds.equals("")){
				String[] projectId = projectIds.split(";");
				IArchivesPostService archivesPostService = (IArchivesPostService)Container.getBean("archivesPostService");
				for(String id:projectId){
					archivesPostService.ArchivesPost(id);					
				}				
			}			
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
			System.out.println("批量归档失败！");
		}
		return execute();
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getZslx() {
		return zslx;
	}

	public void setZslx(String zslx) {
		this.zslx = zslx;
	}

	public String getTdzh() {
		return tdzh;
	}

	public void setTdzh(String tdzh) {
		this.tdzh = tdzh;
	}

	public String getQlr() {
		return qlr;
	}

	public void setQlr(String qlr) {
		this.qlr = qlr;
	}
	
	public String getIsgd() {
		return isgd;
	}

	public void setIsgd(String isgd) {
		this.isgd = isgd;
	}

	public String getDjh() {
		return djh;
	}

	public void setDjh(String djh) {
		this.djh = djh;
	}

	public String getZl() {
		return zl;
	}

	public void setZl(String zl) {
		this.zl = zl;
	}

	public String getSyqlx() {
		return syqlx;
	}

	public void setSyqlx(String syqlx) {
		this.syqlx = syqlx;
	}

	public String getFzrq1() {
		return fzrq1;
	}

	public void setFzrq1(String fzrq1) {
		this.fzrq1 = fzrq1;
	}

	public String getFzrq2() {
		return fzrq2;
	}

	public void setFzrq2(String fzrq2) {
		this.fzrq2 = fzrq2;
	}

	public LinkedHashMap<String, String> getZslxlist() {
		return zslxlist;
	}

	public void setZslxlist(LinkedHashMap<String, String> zslxlist) {
		this.zslxlist = zslxlist;
	}

	public String getZsno() {
		return zsno;
	}

	public void setZsno(String zsno) {
		this.zsno = zsno;
	}


	public String getYt() {
		return yt;
	}

	public void setYt(String yt) {
		this.yt = yt;
	}

	public String getZsstate() {
		return zsstate;
	}

	public void setZsstate(String zsstate) {
		this.zsstate = zsstate;
	}

	public LinkedHashMap<String, String> getZsstatelist() {
		return zsstatelist;
	}

	public void setZsstatelist(LinkedHashMap<String, String> zsstatelist) {
		this.zsstatelist = zsstatelist;
	}

	public String getUserDwdm() {
		return userDwdm;
	}

	public void setUserDwdm(String userDwdm) {
		this.userDwdm = userDwdm;
	}

	public String getProjectIds() {
		return projectIds;
	}

	public void setProjectIds(String projectIds) {
		this.projectIds = projectIds;
	}
	
//	public String getOldDjh() {
//		return oldDjh;
//	}
//
//	public void setOldDjh(String oldDjh) {
//		this.oldDjh = oldDjh;
//	}
}
