package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.services.interf.IJttdsuzService;
import com.jsegov.tddj.services.interf.IJttdsyzService;
import com.jsegov.tddj.services.interf.ITDZJSService;
import com.jsegov.tddj.services.interf.ITxqlzmsService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.JTTDSUZ;
import com.jsegov.tddj.vo.JTTDSYZ;
import com.jsegov.tddj.vo.TDZJS;
import com.jsegov.tddj.vo.TXQLZMS;
import com.opensymphony.xwork2.ActionSupport;

public class JsAction extends ActionSupport {

    /**
     *
     */
    private static final long serialVersionUID = 1476356588479412941L;
    private String sqlstr;
    private String projectId;
    private String zslx;
    private String tdzjsid;
    private String js;
    private String msg;
    private String tdzh;
    private SplitParam splitParam;

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        projectId = request.getParameter("projectId");
        zslx = request.getParameter("zslx");

        // System.out.println("tdzh=======" + tdzh);
        if (zslx.equals("gytdsyz")) {
            IGytdsyzService gytdsyzService = (IGytdsyzService) Container
                    .getBean("gyTdsyzService");
            GYTDSYZ gytdsyz = gytdsyzService.getGYTDSYZ(projectId);
            tdzh = gytdsyz.getTdzh();
        } else if (zslx.equals("jttdsyz")) {
            IJttdsyzService jttdsyzService = (IJttdsyzService) Container
                    .getBean("jtTdsyzService");
            JTTDSYZ jttdsyz = jttdsyzService.getJTTDSYZ(projectId);
            tdzh = jttdsyz.getTdzh();
        }
        else if (zslx.equals("jttdsuz")) {
            IJttdsuzService jttdsuzService = (IJttdsuzService) Container
                    .getBean("jtTdsuzService");
            JTTDSUZ jttdsuz = jttdsuzService.getJTTDSUZ(projectId);
            tdzh = jttdsuz.getTdzh();
        }
        else if (zslx.equals("txqlzms")) {
            ITxqlzmsService txqlzmsService = (ITxqlzmsService) Container
                    .getBean("txqlzmsService");
            TXQLZMS txqlzms = txqlzmsService.getTXQLZMS(projectId);
            tdzh = txqlzms.getTdzh();
        }
        SplitParamImpl s = new SplitParamImpl();
        s.setQueryString("sqlTDZJS");
        s.setQueryParam(tdzh);
        splitParam=s;

        ///sqlstr = "select * from tbl_tdzjs where tdzh='" + tdzh + "' order by tdzjsid";
        // System.out.println(sqlstr);
        return SUCCESS;
    }

    public String save() {
        ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
        TDZJS tdzjs = null;
        if (tdzjsid.equals("")) {
            tdzjs = new TDZJS();
            tdzjs.setJs(js);
            tdzjs.setTdzh(tdzh);
            tdzjs.setProjectId(projectId);
            tdzjs.setJsdate(CommonUtil.getCurrStrDate());
            tdzjsService.insertTDZJS(tdzjs);
        } else {
            tdzjsid=tdzjsid.substring(0,tdzjsid.indexOf(","));
            tdzjs = tdzjsService.getTDZJS(tdzjsid);
            tdzjs.setJs(js);
            tdzjsService.updateTDZJS(tdzjs);
        }

        msg = "保存成功！";
        ///sqlstr = "select * from tbl_tdzjs where tdzh='" + tdzh + "' order by tdzjsid";
        SplitParamImpl s = new SplitParamImpl();
        s.setQueryString("sqlTDZJS");
        s.setQueryParam(tdzh);
        splitParam=s;

        return SUCCESS;
    }

    public String delete() {
        ITDZJSService tdzjsService = (ITDZJSService) Container.getBean("tdzJsService");
        tdzjsService.deleteTDZJSByJsId(tdzjsid);
        msg = "删除成功！";

        //sqlstr = "select * from tbl_tdzjs where tdzh='" + tdzh + "' order by tdzjsid";
        SplitParamImpl s = new SplitParamImpl();
        s.setQueryString("sqlTDZJS");
        s.setQueryParam(tdzh);
        splitParam=s;
        return SUCCESS;
    }

    public String getSqlstr() {
        return sqlstr;
    }

    public void setSqlstr(String sqlstr) {
        this.sqlstr = sqlstr;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getZslx() {
        return zslx;
    }

    public void setZslx(String zslx) {
        this.zslx = zslx;
    }

    /**
     * @return the tdzjsid
     */
    public String getTdzjsid() {
        return tdzjsid;
    }

    /**
     * @param tdzjsid
     *            the tdzjsid to set
     */
    public void setTdzjsid(String tdzjsid) {
        this.tdzjsid = tdzjsid;
    }

    /**
     * @return the js
     */
    public String getJs() {
        return js;
    }

    /**
     * @param js
     *            the js to set
     */
    public void setJs(String js) {
        this.js = js;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * @return the tdzh
     */
    public String getTdzh() {
        return tdzh;
    }

    /**
     * @param tdzh
     *            the tdzh to set
     */
    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }

}
