package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.jsegov.tddj.services.interf.ICFService;
import com.jsegov.tddj.services.interf.IJFService;
import com.jsegov.tddj.services.interf.IProjectService;
import com.jsegov.tddj.services.interf.ISHEETINFOService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.CF;
import com.jsegov.tddj.vo.JF;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SHEETINFO;
import com.opensymphony.xwork2.ActionSupport;

public class JFAction extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = -6970424028778015147L;
	private CF cf;
	private JF jf;
	private String sdrq;
	private String cfksrq;
	private String cfjsrq;
	private String xbnr;
	private String isjfed;
	

	public String getIsjfed() {
		return isjfed;
	}
	public void setIsjfed(String isjfed) {
		this.isjfed = isjfed;
	}
	public String getXbnr() {
		return xbnr;
	}
	public void setXbnr(String xbnr) {
		this.xbnr = xbnr;
	}
	public String getSdrq() {
		return sdrq;
	}
	public void setSdrq(String sdrq) {
		this.sdrq = sdrq;
	}
	public String getCfksrq() {
		return cfksrq;
	}
	public void setCfksrq(String cfksrq) {
		this.cfksrq = cfksrq;
	}
	public String getCfjsrq() {
		return cfjsrq;
	}
	public void setCfjsrq(String cfjsrq) {
		this.cfjsrq = cfjsrq;
	}
	public CF getCf() {
		return cf;
	}
	public void setCf(CF cf) {
		this.cf = cf;
	}
	public JF getJf() {
		return jf;
	}
	public void setJf(JF jf) {
		this.jf = jf;
	}
	@Override
	public String execute() throws Exception {
		// TODO Auto-generated method stub
		String projectId="";
		HttpServletRequest request = ServletActionContext.getRequest();
		if (request.getParameter("proid")!=null) projectId = request.getParameter("proid").toString();
		IJFService jfService = (IJFService)Container.getBean("jfService");
		jf = jfService.getJF(projectId);
		ICFService cfService = (ICFService)Container.getBean("cfService");
		cf = cfService.getCFByProjectId(jf.getCfProjectId());
		if(cf.getSdrq() != null){
			//sdrq = CommonUtil.formateDate(cf.getSdrq());
			sdrq = CommonUtil.formateTime(cf.getSdrq());
		}
		if(cf.getCfksrq() != null){
			cfksrq = CommonUtil.formateDate(cf.getCfksrq());
		}
		if(cf.getCfjsrq() != null){
			cfjsrq = CommonUtil.formateDate(cf.getCfjsrq());
		}
		//	xbnr= "证号："+cf.getTdzh()+"，地号："+cf.getDjh()+",因jfyy被解封。";
		if (jf.getXbnr().equals("")){
			ISHEETINFOService sheetinfoService = (ISHEETINFOService)Container.getBean("sheetInfoService");
			SHEETINFO sheetinfo = sheetinfoService.getSHEETINFO("解封");
			if (sheetinfo != null){
				String xbnr = sheetinfo.getDjkxbnr(); 
				if(cf.getTdzh()!=null){
					xbnr = xbnr.replace("tdzh", cf.getTdzh());
				}
				if(cf.getDjh()!=null){
					xbnr = xbnr.replace("djh", cf.getDjh());
				}
				jf.setXbnr(xbnr);
			}
			jfService.updateJF(jf);
		}
		IProjectService projectService=(IProjectService)Container.getBean("projectService");
		Project project=projectService.getProject(projectId);
			if (project.getEndTime()!=null){
				isjfed="JFED";
			}else{
				isjfed="JFING";
			}
		return SUCCESS;
	}

	public String SavaJfInfo() throws Exception{
		IJFService jfService = (IJFService)Container.getBean("jfService");
		jfService.updateJF(jf);
		ICFService cfService = (ICFService)Container.getBean("cfService");
		cf = cfService.getCFByProjectId(jf.getCfProjectId());	
		if(cf.getSdrq() != null){
			sdrq = CommonUtil.formateTime(cf.getSdrq());
		}
		if(cf.getCfksrq() != null){
			cfksrq = CommonUtil.formateDate(cf.getCfksrq());
		}
		if(cf.getCfjsrq() != null){
			cfjsrq = CommonUtil.formateDate(cf.getCfjsrq());
		}
		return SUCCESS;
	}
}
