package com.jsegov.tddj.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.common.util.UUIDGenerator;
import com.jsegov.tddj.services.BhService;
import com.jsegov.tddj.util.ExcelCheckUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IFGINFOService;
import com.jsegov.tddj.services.interf.IFGZService;
import com.jsegov.tddj.services.interf.IGytdsyzService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.FGINFO;
import com.jsegov.tddj.vo.FGZ;
import com.jsegov.tddj.vo.GYTDSYZ;
import com.jsegov.tddj.vo.XZQ;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;
import org.apache.struts2.json.annotations.JSON;

public class FgdjAction extends ActionSupport {

    /**
     *
     */
    private static final long serialVersionUID = 4393957313153164697L;
    private GYTDSYZ gytdsyz = new GYTDSYZ();
    private FGINFO fginfo = new FGINFO();
	private FGZ fgz = new FGZ();
    private List<FGZ> listFgz = new ArrayList<FGZ>();
    private String projectId = "";
    private Integer fgzNum = 0;
    private String zuTdzh = "";
    private String activityName;
    private String inputStyle;
    private XZQ xzq;
    private String wfRemark;
    private SplitParam splitParam;
	private Integer excelNum;
	// 封装上传文件域属性
	private File[] xlsfile;
	// 封装上传文件类型的属性
	private String[] xlsfileContentType;
	// 封装上传文件名的属性
	private String[] xlsfileFileName;


    public String execute() throws Exception {
		IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
        HttpServletRequest request = ServletActionContext.getRequest();
        IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
        if (request.getParameter("proid") != null) projectId = request.getParameter("proid");
        String taskId = "";
        if (request.getParameter("taskid") != null) taskId = request.getParameter("taskid").toString();
        activityName = platUtil.getPfActivityNameByTaskId(taskId);
        if (activityName.equals("分割登记")) {
            inputStyle = "style='width:100%;'";
        } else {
            inputStyle = "readonly='readonly' style='border: 0px solid ;width:100%;'";
        }

        //System.out.println("request.proid===="+projectId);
        //读取分割信息
        IFGINFOService fginfoService = (IFGINFOService) Container.getBean("fgInfoService");
        FGINFO tempfginfo = new FGINFO();
        tempfginfo.setProjectId(projectId);
        fginfo = fginfoService.getFGINFO(tempfginfo);
        //读取大证信息
        IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
        gytdsyz = gytdsyzService.getGYTDSYZbyTdzh(fginfo.getZtdzh());
        //读取分割土地证号
        xzq = CommonUtil.getXZQ();       
        wfRemark = platUtil.getWfRemarkByProjectId(projectId);

        //读取分割证信息

        getFGZ();
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put("projectId", projectId);
		SplitParamImpl s = new SplitParamImpl();
		s.setQueryString("queryFGZByProjectId");
		s.setQueryParam(map);
		this.splitParam = s;
        return SUCCESS;
    }

    public String save() {
        //保存分割项目信息
        saveFginfo();
        //保存前1节点生成的土地证信息
        xzq = CommonUtil.getXZQ();
        IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
        wfRemark = platUtil.getWfRemarkByProjectId(projectId);
        //if (xzq.getXzqName().equals("泰州市") && !wfRemark.equals("分割登记标准版")){
        //	saveFgTdz();
        //}
        //保存分割证信息

        saveFGZ();
        //读取分割证信息

        getFGZ();
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put("projectId", projectId);
		SplitParamImpl s = new SplitParamImpl();
		s.setQueryString("queryFGZByProjectId");
		s.setQueryParam(map);
		this.splitParam = s;
        return SUCCESS;
    }
    //保存分割项目信息

    public void saveFginfo() {
        HttpServletRequest request = ServletActionContext.getRequest();
        FGINFO dataFginfo = new FGINFO();
        dataFginfo.setProjectId(projectId);
        IFGINFOService fginfoService = (IFGINFOService) Container.getBean("fgInfoService");
        //djh, zdmj, zjzmj, zl, th, syqlx, yt, zzrq, fddbr, dwxz, lxdh, txdz
        dataFginfo = fginfoService.getFGINFO(dataFginfo);
        //System.out.println(fginfo.getDjh());
        if (fginfo.getFgtype().equals("按整宗分割")) {
            dataFginfo.setDjh(gytdsyz.getDjh());
            if (gytdsyz.getSyqmj() != null) {
                dataFginfo.setZdmj(gytdsyz.getSyqmj().toString());
            }
            dataFginfo.setZl(gytdsyz.getZl());
            dataFginfo.setZjzmj(fginfo.getZjzmj());
            dataFginfo.setSyqlx(gytdsyz.getSyqlx());
            dataFginfo.setZzrq(gytdsyz.getZzrq());
        } else {
            dataFginfo.setDjh(fginfo.getDjh());
            dataFginfo.setZdmj(fginfo.getZdmj());
            dataFginfo.setZl(fginfo.getZl());
            dataFginfo.setZjzmj(fginfo.getZjzmj());
            if (fginfo.getSyqlx().equals("")) {
                dataFginfo.setSyqlx(gytdsyz.getSyqlx());
            } else {
                dataFginfo.setSyqlx(fginfo.getSyqlx());
            }
            dataFginfo.setZzrq(fginfo.getZzrq());
            dataFginfo.setTh(fginfo.getTh());
            dataFginfo.setYt(fginfo.getYt());
            dataFginfo.setFddbr(fginfo.getFddbr());
            dataFginfo.setDwxz(fginfo.getDwxz());
            dataFginfo.setLxdh(fginfo.getLxdh());
            dataFginfo.setTxdz(fginfo.getTxdz());
        }

        fginfoService.updateFGINFO(dataFginfo);
        IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
        platUtil.editWorkFlowInstance(projectId, dataFginfo.getDjh() +" || "+ dataFginfo.getZl(), "");
    }
    //保存前1节点生成的土地证信息

    public void saveFgTdz() {       
        String userDwdm = TddjUtil.getCurrentUserDwdm();

        IGytdsyzService gytdsyzService = (IGytdsyzService) Container.getBean("gyTdsyzService");
        GYTDSYZ fgGytdsyz = new GYTDSYZ();
        fgGytdsyz = gytdsyzService.getGYTDSYZ(projectId);
        // projectid, tdzh, qlr, zl, djh, th, yt, qdjg, syqlx, zzrq, syqmj, dymj,
        // ftmj, fzrq, dwdm, islogout, rmzf, olddata, isprinted, bz
        fgGytdsyz.setQlr(gytdsyz.getQlr());
        fgGytdsyz.setZl(fginfo.getZl());
        //System.out.println(fginfo.getZl()+"========fginfo.getZl()");
        fgGytdsyz.setDjh(fginfo.getDjh());
        fgGytdsyz.setTh(fginfo.getTh());
        if (fginfo.getSyqlx().equals("")) {
            fgGytdsyz.setSyqlx(gytdsyz.getSyqlx());
        } else {
            fgGytdsyz.setSyqlx(fginfo.getSyqlx());
        }
        fgGytdsyz.setZzrq(fginfo.getZzrq());
        fgGytdsyz.setYt(fginfo.getYt());
        fgGytdsyz.setOlddata(0);
        fgGytdsyz.setIsprinted(0);
        fgGytdsyz.setDwdm(userDwdm);
        fgGytdsyz.setFzrq(CommonUtil.getCurrStrDate());
        if (fginfo.getFgtype().equals("按幢分割")) {
            if (fginfo.getZdmj() != null) {
                fgGytdsyz.setSyqmj(Double.parseDouble(fginfo.getZdmj()));
            }
        } else {
            fgGytdsyz.setSyqmj(gytdsyz.getSyqmj());
        }
        gytdsyzService.updateGYTDSYZ(fgGytdsyz);
    }
    //保存分割证信息


    public void saveFGZ() {
        HttpServletRequest request = ServletActionContext.getRequest();		
		String userDwdm = TddjUtil.getCurrentUserDwdm();
        String[] fgzid = request.getParameterValues("fgzid");
        String[] fgzxh = request.getParameterValues("fgzxh");
        String[] lzh = request.getParameterValues("lzh");
        String[] dyh = request.getParameterValues("dyh");
        String[] sh = request.getParameterValues("sh");
        String[] jzmj = request.getParameterValues("jzmj");
        String[] ftmj = request.getParameterValues("ftmj");
        String[] yt = request.getParameterValues("yt");
        String[] zzrq = request.getParameterValues("zzrq");
        String[] zl = request.getParameterValues("zl");
        String[] syqlx = request.getParameterValues("syqlx");
        IFGZService fgzService = (IFGZService) Container.getBean("fgzService");

		if(fgzid != null){
			for (int i = 0; i < fgzid.length; i++) {
				//fgzid, projectid, fgzh, fgzxh, qlr, zl, djh, yt, zzrq, dymj, ftmj,
				//fzrq, rf2_dwmc, jzmj, ishz, sh, lzh, dyh, hfzh, dwdm
				FGZ fgz = new FGZ();
				fgz.setFgzid(fgzid[i]);
				fgz.setProjectId(projectId);
				fgz.setFgzxh(Integer.parseInt(fgzxh[i]));
				fgz.setQlr(gytdsyz.getQlr());
				if (fginfo.getDjh() == null || fginfo.getDjh().equals("")) {
					fgz.setDjh(gytdsyz.getDjh());
				} else {
					fgz.setDjh(fginfo.getDjh());
				}
				fgz.setZl(zl[i]);
				fgz.setZzrq(zzrq[i]);
				if (ftmj[i] != null && !ftmj[i].equals(""))
					fgz.setFtmj(Double.valueOf(ftmj[i]));
				if (jzmj[i] != null && !jzmj[i].equals(""))
					fgz.setJzmj(Double.valueOf(jzmj[i]));
				fgz.setIshz(0);
				fgz.setFzrq(CommonUtil.getCurrStrDate());
				fgz.setDyh(dyh[i]);
				fgz.setLzh(lzh[i]);
				fgz.setSh(sh[i]);
				fgz.setYt(yt[i]);
				fgz.setDwdm(userDwdm);
				fgz.setSyqlx(syqlx[i]);
				if (fgzService.getFGZById(fgzid[i]) == null) {
					fgzService.insertFGZ(fgz);
				} else {
					fgzService.updateFGZ(fgz);
				}
			}
		}

    }
    //读取分割证信息


    public void getFGZ() {
        IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
        listFgz = fgzService.getFGZByProjectID(projectId);
        fgzNum = listFgz.size();
    }
    //删除一本分割证

    public void delFgz() throws IOException {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        String fgzid = request.getParameter("fgzid");
        //System.out.println("fgzid===del==="+fgzid);
        FGZ delfgz = new FGZ();
        delfgz.setFgzid(fgzid);
        IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
        fgzService.deleteFGZ(delfgz);
        response.setContentType("text/xml;charset=GBK");
        response.getOutputStream().write("OK".toString().getBytes());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }
    //public

    public String openFgz() {
        SplitParamImpl s = new SplitParamImpl();
        HttpServletRequest request = ServletActionContext.getRequest();
        String proid = request.getParameter("proid");
        //request.setAttribute("proid", proid);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("projectId", proid);
        s.setQueryString("queryFGZ");
        s.setQueryParam(map);
        this.splitParam = s;
        return "openfgdj";
    }

	//导入excel
	public String impExcel(){
		HttpServletRequest request = ServletActionContext.getRequest();
		IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
		IFGINFOService fginfoService = (IFGINFOService) Container.getBean("fgInfoService");
		String projectId = request.getParameter("projectId");
		String djh = request.getParameter("djh");
		String zdmjString = request.getParameter("zdmj");
		String zjzmjString = request.getParameter("zjzmj");
		Double zdmj = 0.0;
		Double zjzmj =0.0;
		if(StringUtils.isNotBlank(zdmjString)){
			zdmj = Double.parseDouble(zdmjString);
		}
		if(StringUtils.isNotBlank(zjzmjString)){
			zjzmj = Double.parseDouble(zjzmjString);
		}
		String dwdm = TddjUtil.getCurrentUserDwdm();
		String fzrq = CommonUtil.getCurrStrDate();
		try {
			String targetDirectory = ServletActionContext.getRequest().getRealPath("/" + "uploadFile");
			String uploadfileName = xlsfileFileName[0];
			uploadfileName = "temp" + uploadfileName.substring(uploadfileName.lastIndexOf("."));
			File target = new File(targetDirectory,uploadfileName);
			FileUtils.copyFile(xlsfile[0], target);
			FileInputStream fis = new FileInputStream(target);
			//从输入流创建Workbook
			Workbook rwb = null;
			if(uploadfileName.substring(uploadfileName.lastIndexOf(".")).equals(".xls")){
				rwb = new HSSFWorkbook(fis);
			}else{

				try {
					rwb = new XSSFWorkbook(fis);
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			}
			//获取第一张sheet表,sheet的下标从0开始
			Sheet rs = rwb.getSheetAt(0);
			int rsRows = rs.getLastRowNum();

			if(rsRows <= 0){
				ServletActionContext.getResponse().setContentType("text/html;charset=GB2312");
				ServletActionContext.getResponse().setCharacterEncoding("GB2312");
				ServletActionContext.getResponse().getWriter().print("{success:true,data:[{\"message\":\"Excel表为空表，请检查！\"}]}");
				return Action.NONE;
			}
			FGZ fgzDel = new FGZ();
			fgzDel.setProjectId(projectId);
			fgzDel.setIsExcel(1);
			fgzService.deleteFGZ(fgzDel);
			String num = String.valueOf(rsRows);
			int rsColumns = rs.getRow(0).getLastCellNum();
			FGZ fgz =null;
			Double jzmj = 0.0;
			Double ftmj = 0.0;
			FGINFO fginfo1 = fginfoService.getFGINFO(projectId);
			List<FGZ> fgzs = fgzService.getFGZByProjectID(projectId);

			Integer k = 0;
			if(fgzs != null){
				k=fgzs.size();
			}

			for(int i = 1; i< rsRows+1;i++){
				fgz = new FGZ();
				jzmj = Double.valueOf(ExcelCheckUtil.getStringCellValue(rs.getRow(i).getCell(4)));
				if(zjzmj != 0.0){
					ftmj = (zdmj/zjzmj)*jzmj;
				}
				fgz.setFgzid(UUIDGenerator.generate());
				fgz.setProjectId(projectId);
				fgz.setFgzxh(i + k);
				fgz.setQlr(fginfo1.getQlr());
				fgz.setDjh(djh);
				fgz.setFzrq(fzrq);
				fgz.setIshz(0);
				fgz.setIsprinted(0);
				fgz.setDwdm(dwdm);
				fgz.setFtmj(ftmj);
				fgz.setZl(ExcelCheckUtil.getStringCellValue(rs.getRow(i).getCell(0)));
				fgz.setLzh(ExcelCheckUtil.getStringCellValue(rs.getRow(i).getCell(1)));
				fgz.setDyh(ExcelCheckUtil.getStringCellValue(rs.getRow(i).getCell(2)));
				fgz.setSh(ExcelCheckUtil.getStringCellValue(rs.getRow(i).getCell(3)));
				fgz.setJzmj(jzmj);
				fgz.setSyqlx(ExcelCheckUtil.getStringCellValue(rs.getRow(i).getCell(5)));
				fgz.setYt(ExcelCheckUtil.getStringCellValue(rs.getRow(i).getCell(6)));
				fgz.setZzrq(ExcelCheckUtil.getStringCellValue(rs.getRow(i).getCell(7)));
				fgz.setIsExcel(1);
				fgzService.insertFGZ(fgz);
			}
			ServletActionContext.getResponse().setContentType("text/html;charset=GB2312");
			ServletActionContext.getResponse().setCharacterEncoding("GB2312");
			ServletActionContext.getResponse().getWriter().print("{success:true,data:[{\"message\":\"导入成功！\"}]}");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return Action.NONE;
	}

	//修改分割证
	public String modifgFgz(){
		HttpServletRequest request = ServletActionContext.getRequest();
		IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
		String fgzid = request.getParameter("fgzid");
		fgz = fgzService.getFGZById(fgzid);
		return "modifgFgz";
	}
    //保存修改的分割证
	public String saveModifgFgz(){
		IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
		FGZ fgz1 = fgzService.getFGZById(fgz.getFgzid());
		fgz1.setLzh(fgz.getLzh());
		fgz1.setDyh(fgz.getDyh());
		fgz1.setSh(fgz.getSh());
		fgz1.setJzmj(fgz.getJzmj());
		fgz1.setFtmj(fgz.getFtmj());
		fgz1.setQlr(fgz.getQlr());
		fgz1.setYt(fgz.getYt());
		fgz1.setZzrq(fgz.getZzrq());
		fgz1.setFzrq(fgz.getFzrq());
		fgz1.setSyqlx(fgz.getSyqlx());
		fgz1.setZl(fgz.getZl());
		fgzService.updateFGZ(fgz1);
		return "modifgFgz";
	}

	public String add(){
		HttpServletRequest request = ServletActionContext.getRequest();
		IFGINFOService fginfoService = (IFGINFOService) Container.getBean("fgInfoService");
		FGINFO fginfo1 = fginfoService.getFGINFO(projectId);
		String djh = request.getParameter("djh");
		fgz.setFgzid(UUIDGenerator.generate());
		fgz.setProjectId(projectId);
		fgz.setDjh(djh);
		fgz.setQlr(fginfo1.getQlr());
		fgz.setFzrq(CommonUtil.getCurrStrDate());
		return "add";
	}

	public String saveAdd(){
		HttpServletRequest request = ServletActionContext.getRequest();
		IFGZService fgzService = (IFGZService) Container.getBean("fgzService");
		IFGINFOService fginfoService = (IFGINFOService) Container.getBean("fgInfoService");
		FGZ fgz1 = fgzService.getFGZById(fgz.getFgzid());
		Integer i = 0;
		List<FGZ> list = fgzService.getFGZByProjectID(projectId);
		if(list !=null){
			i = list.size();
		}
		if(fgz1 == null){
			FGZ fgz2 = new FGZ();
			fgz2.setFgzid(fgz.getFgzid());
			fgz2.setProjectId(projectId);
			fgz2.setFgzxh(i+1);
			fgz2.setQlr(fgz.getQlr());
			fgz2.setDjh(fgz.getDjh());
			fgz2.setFzrq(fgz.getFzrq());
			fgz2.setIshz(0);
			fgz2.setIsprinted(0);
			fgz2.setDwdm(TddjUtil.getCurrentUserDwdm());
			fgz2.setFtmj(fgz.getFtmj());
			fgz2.setZl(fgz.getZl());
			fgz2.setLzh(fgz.getZl());
			fgz2.setDyh(fgz.getDyh());
			fgz2.setSh(fgz.getSh());
			fgz2.setJzmj(fgz.getJzmj());
			fgz2.setSyqlx(fgz.getSyqlx());
			fgz2.setYt(fgz.getYt());
			fgz2.setZzrq(fgz.getZzrq());
			fgzService.insertFGZ(fgz2);
			fgzNum = fgzService.getFGZByProjectID(projectId).size();
		}else{
			fgz1.setQlr(fgz.getQlr());
			fgz1.setDjh(fgz.getDjh());
			fgz1.setFzrq(fgz.getFzrq());
			fgz1.setFtmj(fgz.getFtmj());
			fgz1.setZl(fgz.getZl());
			fgz1.setLzh(fgz.getZl());
			fgz1.setDyh(fgz.getDyh());
			fgz1.setSh(fgz.getSh());
			fgz1.setJzmj(fgz.getJzmj());
			fgz1.setSyqlx(fgz.getSyqlx());
			fgz1.setYt(fgz.getYt());
			fgz1.setZzrq(fgz.getZzrq());
			fgzService.updateFGZ(fgz1);
		}
		return  "add";
	}
	public Integer getExcelNum() {
		return excelNum;
	}

	public void setExcelNum(Integer excelNum) {
		this.excelNum = excelNum;
	}

	public File[] getXlsfile() {
		return xlsfile;
	}

	public void setXlsfile(File[] xlsfile) {
		this.xlsfile = xlsfile;
	}

	public String[] getXlsfileContentType() {
		return xlsfileContentType;
	}

	public void setXlsfileContentType(String[] xlsfileContentType) {
		this.xlsfileContentType = xlsfileContentType;
	}

	public String[] getXlsfileFileName() {
		return xlsfileFileName;
	}

	public void setXlsfileFileName(String[] xlsfileFileName) {
		this.xlsfileFileName = xlsfileFileName;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getWfRemark() {
		return wfRemark;
	}

	public void setWfRemark(String wfRemark) {
		this.wfRemark = wfRemark;
	}

	public XZQ getXzq() {
		return xzq;
	}

	public void setXzq(XZQ xzq) {
		this.xzq = xzq;
	}

	public String getInputStyle() {
		return inputStyle;
	}

	public void setInputStyle(String inputStyle) {
		this.inputStyle = inputStyle;
	}

	public String getActivityName() {
		return activityName;
	}

	public void setActivityName(String activityName) {
		this.activityName = activityName;
	}

	public String getZuTdzh() {
		return zuTdzh;
	}

	public void setZuTdzh(String zuTdzh) {
		this.zuTdzh = zuTdzh;
	}

	public Integer getFgzNum() {
		return fgzNum;
	}

	public void setFgzNum(Integer fgzNum) {
		this.fgzNum = fgzNum;
	}

	public String getProjectId() {
		return projectId;
	}

	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}


	public List<FGZ> getListFgz() {
		return listFgz;
	}

	public void setListFgz(List<FGZ> listFgz) {
		this.listFgz = listFgz;
	}

	public FGINFO getFginfo() {
		return fginfo;
	}

	public void setFginfo(FGINFO fginfo) {
		this.fginfo = fginfo;
	}

	public GYTDSYZ getGytdsyz() {
		return gytdsyz;
	}

	public void setGytdsyz(GYTDSYZ gytdsyz) {
		this.gytdsyz = gytdsyz;
	}

	public FGZ getFgz() {
		return fgz;
	}

	public void setFgz(FGZ fgz) {
		this.fgz = fgz;
	}
}
