package com.jsegov.tddj.action;

import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.spring.Container;
import com.gtis.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.dao.ProjectDAO;
import com.jsegov.tddj.dao.SQBDAO;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.platform.IqlygUtil;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.vo.Project;
import com.jsegov.tddj.vo.SQB;
import com.jsegov.tddj.vo.SPB;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;


/**
 * Created by Administrator on 2014/11/14.
 */
public class EditHisDataAction extends ActionSupport {
    private SplitParam splitParam;
    private String projectName;
    private String djh;
    private String djlx;
    private String creater;
    private String beginTime;
    private String endTime;
    private String startDate;
    private String endDate;
    private ProjectDAO projectDAO;
    private Project project;
    String[] dates=null;
    String msg="";

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    public String getCreater() {
        return creater;
    }

    public void setCreater(String creater) {
        this.creater = creater;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Project getProject() {
        return project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public ProjectDAO getProjectDAO() {
        return projectDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public String execute() throws Exception {
        SplitParamImpl s = new SplitParamImpl();
        HashMap param = new HashMap();
        if(StringUtils.isNotBlank(projectName)){
            param.put("projectName",projectName);
        }
        if(StringUtils.isNotBlank(djh)){
            param.put("djh",djh);
        }
        if(StringUtils.isNotBlank(djlx)){
            param.put("djlx",djlx);
        }
        if(StringUtils.isNotBlank(creater)){
            param.put("creater",creater);
        }
        if(StringUtils.isNotBlank(beginTime)){
            param.put("beginTime",CommonUtil.formateDateToString(beginTime));
        }
        if(StringUtils.isNotBlank(endTime)){
            param.put("endTime",CommonUtil.formateDateToString(endTime));
        }
        s.setQueryString("queryProject");
        s.setQueryParam(param);
        this.splitParam = s;
        return SUCCESS;
    }
    public String impHistoryData() throws Exception{
        List<String> logMsgList=new ArrayList<String>();
        HttpServletRequest request = ServletActionContext.getRequest();
        String userId= SessionUtil.getUserId(request);
        HashMap param = new HashMap();
        if(StringUtils.isNotBlank(startDate))
            startDate= CommonUtil.formateDateToString(startDate);
        if(StringUtils.isNotBlank(endDate))
            endDate=CommonUtil.formateDateToString(endDate);

        List<Project> projectList =projectDAO.queryProject(startDate,endDate);
        IqlygUtil qlygUtil = (IqlygUtil) Container.getBean("qlygUtil");
     //   IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
        ISQBService sqbService = (ISQBService) Container.getBean("sqbService");
        List<SQB> qlygList= new ArrayList<SQB>();
        for(int i=0;i<projectList.size();i++ ){
            SQB sqb = sqbService.getSQB(projectList.get(i).getProjectId());
            System.out.println(i+":开始调用权力阳光接口！！！！");
            qlygList.add(sqb);
        }
        msg =  qlygUtil.workflowEndList(qlygList);
        if(msg=="ok"){
            msg = "";
        }
       // qlygUtil.workflowEnd("XC5E4415J3B4W6S9","国有建设用地使用权","土地使用权抵押权初始登记");
        HashMap mapresult = new HashMap();
        mapresult.put("success", true);
        mapresult.put("msg", msg);
        ServletActionContext.getResponse().getWriter().println(ObjectJSONUtil.ObjectToJson(mapresult));
        return NONE;
    }
    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }
}
