package com.jsegov.tddj.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.util.UUIDGenerator;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.TddjUtil;
import com.jsegov.tddj.services.interf.IBHService;
import com.jsegov.tddj.services.interf.IFGINFOService;
import com.jsegov.tddj.services.interf.IFGZService;
import com.jsegov.tddj.util.CommonUtil;
import com.jsegov.tddj.vo.FGINFO;
import com.jsegov.tddj.vo.FGZ;
import com.opensymphony.xwork2.ActionSupport;
public class EditFGZAction extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4359801219514026335L;

	private SplitParam splitParam;
	private String djh;
	private String fgzh;
	private String zl;
	private String qlr;
	private String ishz;
	private String lzh;
	private String dyh;
	private String sh;
	private FGZ editfgz;
	private String syqlx;
	private FGINFO fginfo;
	
	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		
		HashMap<String, Object> map=new HashMap<String, Object>();
		map = CommonUtil.getDwdmQuery(request, map);
		String queryDjh=null;
		String queryFgzh=null;
		String queryZl=null;
		String queryQlr=null;
		String queryIshz=null;
		String queryLzh=null;
		String queryDyh=null;
		String querySh=null;
		
		if(djh!=null && !djh.equals("")){
			queryDjh="%"+djh+"%";
		}
		if(fgzh!=null && !fgzh.equals("")){
			queryFgzh="%"+fgzh+"%";
		}
		if(zl!=null && !zl.equals("")){
			queryZl="%"+zl+"%";
		}
		if(qlr!=null && !qlr.equals("")){
			queryQlr="%"+qlr+"%";
		}
		if(ishz!=null && !ishz.equals("")){
			queryIshz=ishz;
		}
		
		if(lzh!=null && !lzh.equals("")){
			queryLzh="%"+lzh+"%";
		}
		if(dyh!=null && !dyh.equals("")){
			queryDyh="%"+dyh+"%";
		}
		if(sh!=null && !sh.equals("")){
			querySh="%"+sh+"%";
		}

		map.put("djh", queryDjh);
		map.put("fgzh", queryFgzh);
		map.put("zl", queryZl);
		map.put("qlr", queryQlr);
		map.put("ishz", queryIshz);
		map.put("lzh", queryLzh);
		map.put("dyh", queryDyh);
		map.put("sh", querySh);
        map.put("dwdm","3208%");
		//System.out.println("map="+map);
		SplitParamImpl s = new SplitParamImpl();
		s.setQueryString("queryFGZ");
		s.setQueryParam(map);
		this.splitParam = s;
		
		return SUCCESS;
	}

	//删除一本分割证
	public void delFgz() throws IOException{
		HttpServletRequest request = ServletActionContext.getRequest();
		HttpServletResponse response = ServletActionContext.getResponse();
		String fgzid = request.getParameter("fgzid");
		//System.out.println("fgzid===del==="+fgzid);
		FGZ delfgz = new FGZ();
		delfgz.setFgzid(fgzid);
		IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
		fgzService.deleteFGZ(delfgz);
		response.setContentType("text/xml;charset=GBK");
		response.getOutputStream().write("OK".toString().getBytes());
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}
	
	public String openFGZ(){
		HttpServletRequest request = ServletActionContext.getRequest();
		//HttpServletResponse response = ServletActionContext.getResponse();
		String fgzid = request.getParameter("fgzid");
		//System.out.println("fgzid===openFGZ==="+fgzid);
		String projectId;
		IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
		editfgz = fgzService.getFGZById(fgzid);
		if (editfgz == null){
			editfgz = new FGZ();
			editfgz.setFgzid(fgzid);
			IBHService bhService = (IBHService)Container.getBean("bhService");
			editfgz.setFgzh(bhService.getFGZBH());
			editfgz.setProjectId(UUIDGenerator.generate());
		}
		
		if (editfgz!=null){
			projectId = editfgz.getProjectId();
			IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
			fginfo = fginfoService.getFGINFO(projectId);
			if (fginfo==null){
				fginfo = new FGINFO();
			}
		}
		return "editFgz";
	}
	
	public String save(){
		IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
		String projectId = "";
		if (fgzService.getFGZById(editfgz.getFgzid()) == null){			
			String userDwdm = TddjUtil.getCurrentUserDwdm();			
			editfgz.setIshz(0);
			if (!editfgz.getDjh().equals("")){
				List<FGZ> list = fgzService.getFGZByDjh(editfgz.getDjh());
				if (list.size()>0){
					FGZ fgz = (FGZ)list.get(0);
					projectId = fgz.getProjectId();
				}else{
					projectId = UUIDGenerator.generate();
				}
			}else{
				projectId = UUIDGenerator.generate();
			}
			editfgz.setProjectId(projectId);
			editfgz.setFgzxh(-1);
			editfgz.setDwdm(userDwdm);
			fgzService.insertFGZ(editfgz);
		}else{
			projectId = editfgz.getProjectId();
			fgzService.updateFGZ(editfgz);
		}
		//System.out.println("projectId====="+projectId);
		IFGINFOService fginfoService = (IFGINFOService)Container.getBean("fgInfoService");
		FGINFO fg = fginfoService.getFGINFO(projectId);
		if (fg==null){
			fg = new FGINFO();
			fg.setProjectId(projectId);
			fg.setZdmj(fginfo.getZdmj());
			fg.setZtdzh(fginfo.getZtdzh());
			fg.setZjzmj(fginfo.getZjzmj());
			fg.setDjh(editfgz.getDjh());
			fginfoService.insertFGINFO(fginfo);
		}else{
			fg.setProjectId(projectId);
			fg.setZdmj(fginfo.getZdmj());
			fg.setZtdzh(fginfo.getZtdzh());
			fg.setZjzmj(fginfo.getZjzmj());
			fg.setDjh(editfgz.getDjh());
			fginfoService.updateFGINFO(fg);
		}
		return "editFgz";
	}
	
	public String addFgz(){
		IFGZService fgzService = (IFGZService)Container.getBean("fgzService");
		//if (fgzService.getFGZById(editfgz.getFgzid()) == null){
		HttpServletRequest request = ServletActionContext.getRequest();		
		String userDwdm = TddjUtil.getCurrentUserDwdm();
		editfgz.setIshz(0);
		editfgz.setHfzh("");
		editfgz.setFgzid(UUIDGenerator.generate());
		String projectId = "";
		if (!editfgz.getDjh().equals("")){
			List<FGZ> list = fgzService.getFGZByDjh(editfgz.getDjh());
			if (list.size()>0){
				FGZ fgz = (FGZ)list.get(0);
				projectId = fgz.getProjectId();
			}else{
				projectId = UUIDGenerator.generate();
			}
		}else{
			projectId = UUIDGenerator.generate();
		}
		editfgz.setProjectId(projectId);
		editfgz.setFgzxh(-1);
		editfgz.setDwdm(userDwdm);
		IBHService bhService = (IBHService)Container.getBean("bhService");
		editfgz.setFgzh(bhService.getFGZBH());
		fgzService.insertFGZ(editfgz);
		//System.out.println(projectId);
		IFGINFOService fginService = (IFGINFOService)Container.getBean("fgInfoService");
		FGINFO fg = fginService.getFGINFO(projectId);
		if (fg==null){
			fg = new FGINFO();
			fg.setProjectId(projectId);
			fg.setZdmj(fginfo.getZdmj());
			fg.setZtdzh(fginfo.getZtdzh());
			fg.setZjzmj(fginfo.getZjzmj());
			fg.setDjh(editfgz.getDjh());
			fginService.insertFGINFO(fg);
		}else{
			fg.setProjectId(projectId);
			fg.setZdmj(fginfo.getZdmj());
			fg.setZtdzh(fginfo.getZtdzh());
			fg.setZjzmj(fginfo.getZjzmj());
			fg.setDjh(editfgz.getDjh());
			fginService.updateFGINFO(fg);
		}
		
		return "editFgz";
	}
	
	public FGINFO getFginfo() {
		return fginfo;
	}

	public void setFginfo(FGINFO fginfo) {
		this.fginfo = fginfo;
	}

	public String getSyqlx() {
		return syqlx;
	}

	public void setSyqlx(String syqlx) {
		this.syqlx = syqlx;
	}
	
	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getDjh() {
		return djh;
	}

	public void setDjh(String djh) {
		this.djh = djh;
	}

	public String getFgzh() {
		return fgzh;
	}

	public void setFgzh(String fgzh) {
		this.fgzh = fgzh;
	}

	public String getZl() {
		return zl;
	}

	public void setZl(String zl) {
		this.zl = zl;
	}

	public String getQlr() {
		return qlr;
	}

	public void setQlr(String qlr) {
		this.qlr = qlr;
	}

	public String getIshz() {
		return ishz;
	}

	public void setIshz(String ishz) {
		this.ishz = ishz;
	}

	public String getLzh() {
		return lzh;
	}

	public void setLzh(String lzh) {
		this.lzh = lzh;
	}

	public String getDyh() {
		return dyh;
	}

	public void setDyh(String dyh) {
		this.dyh = dyh;
	}

	public String getSh() {
		return sh;
	}

	public void setSh(String sh) {
		this.sh = sh;
	}

	public FGZ getEditfgz() {
		return editfgz;
	}

	public void setEditfgz(FGZ editfgz) {
		this.editfgz = editfgz;
	}
}

