package com.jsegov.tddj.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts2.ServletActionContext;

import com.gtis.spring.Container;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.tddj.platform.IPlatUtil;
import com.jsegov.tddj.services.interf.IDJKService;
import com.jsegov.tddj.services.interf.ISPBService;
import com.jsegov.tddj.services.interf.ISQBService;
import com.jsegov.tddj.vo.DJK;
import com.jsegov.tddj.vo.SPB;
import com.jsegov.tddj.vo.SQB;
import com.opensymphony.xwork2.ActionSupport;

public class DJKAction extends ActionSupport {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1102303566181536482L;
	private DJK djk = new DJK();
	private SplitParam splitParam;
	private String xbnr;
	private String sqlstr;
	private String activityName;
	private String qsxz;

	public String getQsxz() {
		return qsxz;
	}

	public void setQsxz(String qsxz) {
		this.qsxz = qsxz;
	}

	public String getActivityName() {
		return activityName;
	}

	public void setActivityName(String activityName) {
		this.activityName = activityName;
	}

	public String execute() throws Exception {
		HttpServletRequest request = ServletActionContext.getRequest();
		String projectId = request.getParameter("proid");
		SplitParamImpl s = new SplitParamImpl();
		String taskId = "";
		IPlatUtil platUtil = (IPlatUtil)Container.getBean("platUtil");
		if (request.getParameter("taskid") != null)
			taskId = request.getParameter("taskid").toString();
		    activityName = platUtil.getPfActivityNameByTaskId(taskId);
		// System.out.println("---"+projectId);
		String djh = "";
		ISPBService spbService = (ISPBService) Container.getBean("spbService");
		SPB spb = spbService.getSPB(projectId);
		if (spb != null) {
			xbnr = spb.getXbnr();
			djh = spb.getDjh();
			qsxz = spb.getQsxz();
		} else {
			ISQBService sqbService = (ISQBService) Container
					.getBean("sqbService");
			SQB sqb = sqbService.getSQB(projectId);
			if (sqb != null) {
				djh = sqb.getDjh();
				qsxz = sqb.getQsxz();
			}else{
				IDJKService djkService = (IDJKService) Container.getBean("djkService");
				DJK djk = djkService.getDJK(projectId);
				if (djk != null){
					djh = djk.getDjh();
					qsxz = djk.getQsxz();
				}
			}
		}
		if (qsxz.indexOf("所有权") > -1) {
			qsxz = "3";
		} else {
			qsxz = "0";
		}
		IDJKService djkService = (IDJKService) Container.getBean("djkService");
		if (djh == null || djh.equals("")) {
			DJK _djk = djkService.getDJK(projectId);
            if(_djk!=null) {
                 djh = _djk.getDjh();
            }
		}
		djk = djkService.getDJKByDjh(djh);
		if (djk != null) {
			//sqlstr = "select rownum as ID, djjs,islogout from zd_zcdj where djkId="+ String.valueOf(djk.getDjkId()) + " order by djkxbid";
			// s.setQueryString("selectDJKXBByDJKID");
             s.setQueryString("selectDJKXBByDJKID");
			 s.setQueryParam(djk.getDjkId());
		} else if(djh!=null && !djh.equals("")){
			//sqlstr = "select rownum as ID, djjs,islogout from zd_zcdj where djkId=0 order by djkxbid";
			 s.setQueryString("selectDJKXBByDjh");
			 s.setQueryParam(djh);
            // s.setQueryParam("2417");
            
		}
		splitParam = s;
		// System.out.println("===="+sqlstr);
       /// Object obj = Container.getBean("tddj");
		return SUCCESS;
	}

	public String SaveDJK() {
		return SUCCESS;
	}

	public DJK getDjk() {

		return djk;
	}

	public void setDjk(DJK djk) {
		this.djk = djk;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getXbnr() {
		return xbnr;
	}

	public void setXbnr(String xbnr) {
		this.xbnr = xbnr;
	}

	public String getSqlstr() {
		return sqlstr;
	}

	public void setSqlstr(String sqlstr) {
		this.sqlstr = sqlstr;
	}

}
