package com.jsegov.fy.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultElement;
import org.jfree.util.Log;

import com.gtis.util.UUIDGenerator;
import com.jsegov.fy.vo.GtcfVo;
import com.jsegov.fy.vo.GtcxqqVo;
import com.jsegov.fy.vo.GtxxVo;

public class XmlUtils {
	/**
	 * 获取用户xml
	 * @param username
	 * @param password
	 * @return
	 */
	public static String getUsermarkerXml(String username,String password){
		String xml="";
		if(StringUtils.isNotBlank(username)){
			xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?><usermarker>";
			xml=xml+"<condition username=\""+StringUtils.trim(username)+"\" password=\""+StringUtils.trim(password)+"\"></condition></usermarker>";
		}
		return xml;
	}
	
	public static List<GtcxqqVo> getGtcxqqVoListFromXml(StringBuffer gtcxqqXml){
		List<GtcxqqVo> gtcxqqList=new ArrayList<GtcxqqVo>();
		if(gtcxqqXml!=null){
			SAXReader sr = new SAXReader();
			Document document = null;
			try {
				 System.out.println(gtcxqqXml.toString());
				document = (Document)DocumentHelper.parseText(gtcxqqXml.toString());  
			} catch (DocumentException e) {
				// TODO Auto-generated catch block
				Log.error("获取司法查询信息的返回的xml不正确：",e);
			}
			if(document!=null){
				Element root = document.getRootElement();
				List<Node> nodes = root.selectNodes("gtcxqq");
				for (int i = 0 ; i < nodes.size() ; i++){
					GtcxqqVo gtcxqq=new GtcxqqVo();
					Node node= nodes.get(i);
					DefaultElement element = (DefaultElement)node;
					gtcxqq.setGtcxqqId(UUIDGenerator.generate());
					gtcxqq.setBdhm(element.attribute("BDHM").getText());		
					gtcxqq.setLb(element.attribute("LB").getText());
					gtcxqq.setXz(element.attribute("XZ").getText());		
					gtcxqq.setXm(element.attribute("XM").getText());
					gtcxqq.setGj(element.attribute("GJ").getText());		
					gtcxqq.setZjlx(element.attribute("ZJLX").getText());
					gtcxqq.setDsrzjhm(element.attribute("DSRZJHM").getText());		
					gtcxqq.setFzjg(element.attribute("FZJG").getText());
					gtcxqq.setFymc(element.attribute("FYMC").getText());		
					gtcxqq.setCbr(element.attribute("CBR").getText());
					gtcxqq.setAh(element.attribute("AH").getText());
					gtcxqq.setGtcxqqDate(new Date());
					gtcxqq.setResultStatus("0");
					gtcxqqList.add(gtcxqq);
				}
			}
		}
		return gtcxqqList;
	}
	public static List<GtcxqqVo> getGtcxqqVoListFromDocument(Document gtcxqqXml){
		List<GtcxqqVo> gtcxqqList=new ArrayList<GtcxqqVo>();
			if(gtcxqqXml!=null){
				Element root = gtcxqqXml.getRootElement();
				List<Node> nodes = root.selectNodes("gtcxqq");
				for (int i = 0 ; i < nodes.size() ; i++){
					GtcxqqVo gtcxqq=new GtcxqqVo();
					Node node= nodes.get(i);
					DefaultElement element = (DefaultElement)node;
					gtcxqq.setGtcxqqId(UUIDGenerator.generate());
					gtcxqq.setBdhm(element.attribute("BDHM").getText());		
					gtcxqq.setLb(element.attribute("LB").getText());
					gtcxqq.setXz(element.attribute("XZ").getText());		
					gtcxqq.setXm(element.attribute("XM").getText());
					gtcxqq.setGj(element.attribute("GJ").getText());		
					gtcxqq.setZjlx(element.attribute("ZJLX").getText());
					gtcxqq.setDsrzjhm(element.attribute("DSRZJHM").getText());		
					gtcxqq.setFzjg(element.attribute("FZJG").getText());
					gtcxqq.setFymc(element.attribute("FYMC").getText());		
					gtcxqq.setCbr(element.attribute("CBR").getText());
					gtcxqq.setAh(element.attribute("AH").getText());
					gtcxqq.setGtcxqqDate(new Date());
					gtcxqq.setResultStatus("0");
					gtcxqqList.add(gtcxqq);
				}
			}
		
		return gtcxqqList;
	}
	public static GtxxVo getGtxxVo(HashMap map){
		GtxxVo gtxxVo=null;
		if(map!=null){
			gtxxVo=new GtxxVo();
			gtxxVo.setGtxxId(UUIDGenerator.generate());
			gtxxVo.setCqzh(ShareMethods.getStringFromObject(map.get("CQZH")));
			gtxxVo.setGtdz(ShareMethods.getStringFromObject(map.get("GTDZ")));
			gtxxVo.setTdmj(ShareMethods.formatNumber(map.get("TDMJ"),"4"));
			gtxxVo.setQslb(ShareMethods.getStringFromObject(map.get("QSLB")));
			gtxxVo.setDjjg(ShareMethods.formatNumber(map.get("DJJG"), "4"));
			gtxxVo.setDjsj(ShareMethods.getCurrTime(map.get("DJSJ")));
			gtxxVo.setDjr(ShareMethods.getStringFromObject(map.get("DJR")));
			gtxxVo.setDjrq(ShareMethods.getCurrTime(map.get("DJRQ")));
		}
		return gtxxVo;
	}
	
	public static GtcfVo getGtcfVo(HashMap map){
		GtcfVo gtcfVo=null;
		if(map!=null){
			gtcfVo=new GtcfVo();
			gtcfVo.setGtcfId(UUIDGenerator.generate());
			gtcfVo.setCqzh(ShareMethods.getStringFromObject(map.get("CQZH")));
			gtcfVo.setQzjg(ShareMethods.getStringFromObject(map.get("QZJG")));
			gtcfVo.setQzwh(ShareMethods.getStringFromObject(map.get("QZWH")));
			gtcfVo.setDyqr(ShareMethods.getStringFromObject(map.get("DYQR")));
			gtcfVo.setDyje(ShareMethods.formatNumber(map.get("DYJE"), "4"));
			gtcfVo.setKzksrq(ShareMethods.getCurrTime(map.get("KZKSRQ")));
			gtcfVo.setKzjsrq(ShareMethods.getCurrTime(map.get("KZJSRQ")));
			gtcfVo.setTxzh(ShareMethods.getStringFromObject(map.get("TXZH")));
		}
		return gtcfVo;
	}
	
	public static StringBuffer getGtxxXml(GtxxVo gtxxVo,List<GtcfVo> gtcfList,int i){
		StringBuffer stringBuffer=new StringBuffer();
		if(gtxxVo!=null){
			stringBuffer.append("<gtxx BDHM=\""+ShareMethods.getStringFromObject(gtxxVo.getBdhm())+"\" XH=\""+(i+1)+"\"" +
					" CQZH=\""+ShareMethods.getStringFromObject(gtxxVo.getCqzh())+"\" GTDZ=\""+ShareMethods.getStringFromObject(gtxxVo.getGtdz())+"\" TDMJ=\""+ShareMethods.formatNumber(gtxxVo.getTdmj(), "4")
					+"\" QSLB=\""+ShareMethods.getStringFromObject(gtxxVo.getQslb())+"\" GYQK=\""+ShareMethods.getStringFromObject(gtxxVo.getGyqk())+"\" FEBL=\""+ShareMethods.getStringFromObject(gtxxVo.getFebl())+"\" DJJG=\""
					+ShareMethods.formatNumber(gtxxVo.getDjjg(),"4")+"\" DJSJ=\""+ShareMethods.getStringFromObject(gtxxVo.getDjsj())+"\" DJR=\""+ShareMethods.getStringFromObject(gtxxVo.getDjr())+"\" DJRQ=\""+ShareMethods.getStringFromObject(gtxxVo.getDjrq())
					+"\" BEIZ=\""+ShareMethods.getStringFromObject(gtxxVo.getBeiz())+"\">");
			if(gtcfList!=null && gtcfList.size()>0){
				stringBuffer.append("<gtcfList>");
				for(int j=0;j<gtcfList.size();j++){
					stringBuffer.append("<gtcf CSXH=\""+(j+1)+"\" QZJG=\""+ShareMethods.getStringFromObject(gtcfList.get(j).getQzjg())+"\" QZWH=\""+ShareMethods.getStringFromObject(gtcfList.get(j).getQzwh())
							+"\" DYQR=\""+ShareMethods.getStringFromObject(gtcfList.get(j).getDyqr())+"\" DYJE=\""+ShareMethods.formatNumber(gtcfList.get(j).getDyje(),"4")+"\" KZKSRQ=\""+ShareMethods.getStringFromObject(gtcfList.get(j).getKzksrq())+"\" KZJSRQ=\""
							+ShareMethods.getStringFromObject(gtcfList.get(j).getKzjsrq())+"\"></gtcf>");
				}
				stringBuffer.append("</gtcfList>");
			}
			stringBuffer.append("</gtxx>");
		}
		return stringBuffer;
	}
	
	public static List<GtcxqqVo> getResultGtcxqq(StringBuffer resultMsg){
		List<GtcxqqVo> gtcxqqList=new ArrayList<GtcxqqVo>();
		if(resultMsg!=null){
			SAXReader sr = new SAXReader();
			Document document = null;
			try {
				System.out.println(resultMsg.toString());
				document = (Document)DocumentHelper.parseText(resultMsg.toString());  
			} catch (DocumentException e) {
				// TODO Auto-generated catch block
				Log.error("获取司法返回信息的xml不正确：",e);
			}
			if(document!=null){
				Element root = document.getRootElement();
				List<Node> nodes = root.selectNodes("//result/cxjglist/jg");
				for (int i = 0 ; i < nodes.size() ; i++){
					GtcxqqVo gtcxqq=new GtcxqqVo();
					Node node= nodes.get(i);
					DefaultElement element = (DefaultElement)node;
					gtcxqq.setGtcxqqId(UUIDGenerator.generate());
					gtcxqq.setBdhm(element.attribute("bdhm").getText());	
					if(element.attribute("result")!=null && StringUtils.isNotBlank(element.attribute("result").getText())){
						if(StringUtils.equals(element.attribute("result").getText(), "fail")){
							gtcxqq.setResultStatus("1");
							gtcxqq.setMsg(element.attribute("msg").getText());
						}else
							gtcxqq.setResultStatus("2");
					}
					gtcxqqList.add(gtcxqq);
				}
			}
		}
		return gtcxqqList;
	}
	public static void main(String[] args) {
		StringBuffer sb=new StringBuffer();
		sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><gtcxqqList><gtcxqq BDHM=\"20111\" LB=\"GT\"" +
				" XZ=\"1\" XM=\"333\" GJ=\"中国\" ZJLX=\"01\" DSRZJHM=\"333\" FZJG=\"江苏南京\" " +
				"FYMC=\"南京市中级人民法院\" CBR=\"张三\" AH=\"(2011)宁执字第00003号\"></gtcxqq><gtcxqq BDHM=\"20113\" LB=\"GT\"" +
				" XZ=\"1\" XM=\"333\" GJ=\"中国\" ZJLX=\"01\" DSRZJHM=\"333\" FZJG=\"江苏南京\" " +
				"FYMC=\"南京市中级人民法院\" CBR=\"张三\" AH=\"(2011)宁执字第00003号\"></gtcxqq></gtcxqqList>");
		List<GtcxqqVo> gtcxqqList=getGtcxqqVoListFromXml(sb);
		System.out.println(gtcxqqList.size());
	}
}
