package com.jsegov.fy.util;

import java.io.UnsupportedEncodingException;

import org.apache.commons.lang.StringUtils;

import sun.misc.BASE64Decoder;
import tdh.util.Basic64;
import tdh.util.xml.XMLDocument;
import tdh.util.xml.XMLException;
import tdh.util.xml.XMLNode;

public class TranscodingUtils {
	public static StringBuffer transcodingGBK(StringBuffer xml)
			throws UnsupportedEncodingException {
		StringBuffer value = new StringBuffer();
		if (xml != null && StringUtils.isNotBlank(xml.toString())) {
			value.append(new String(xml.toString().getBytes("UTF-8"), "GBK"));
		}
		return value;
	}
	public static String transcodingGBK(String s)
	throws UnsupportedEncodingException {
		String value = "";
		if (s != null && StringUtils.isNotBlank(s)) {
			value=(new String(s.getBytes("UTF-8"), "GBK"));
		}
		return value;
}
	
	public static StringBuffer transcodingUTF(StringBuffer xml)
			throws UnsupportedEncodingException {
		StringBuffer value = new StringBuffer();
		if (xml != null && StringUtils.isNotBlank(xml.toString())) {
			value.append(new String(xml.toString().getBytes("GBK"), "UTF-8"));
		}
		return value;
	}

	// 将 s 进行 BASE64 编码
	public static String getBASE64(String s) {
		if (s == null)
			return null;
		return (new sun.misc.BASE64Encoder()).encode(s.getBytes());
	}

	// 将 BASE64 编码的字符串 s 进行解码
	public static String getFromBASE64(String s) {
		if (s == null)
			return null;
		BASE64Decoder decoder = new BASE64Decoder();
		try {
			byte[] b = decoder.decodeBuffer(s);
			return new String(b);
		} catch (Exception e) {
			return null;
		}
	}
	public static String encodeGbkBase64(String str) {
	    str = trim(str);
	    try {
	      str = new String(str.getBytes(), "GBK");
	    } catch (UnsupportedEncodingException e) {
	      e.printStackTrace();
	    }
	    str = Basic64.encode(str);
	    return str;
	  }
	/**
	   * 对字符串进行去空格处理.
	   * 
	   * @param str 需要处理的字符串.
	   * @return 处理后的字符串.
	   */
	  public static String trim(String str) {
	    if (str == null) {
	      return "";
	    }

	    str = str.trim();
	    if ("null".equals(str))
	      str = "";

	    return str;

	  }
	  public static String encodeXmlNodeGbkBase64(String xmlString) {
		    XMLDocument doc = new XMLDocument();
		    try {
		      doc.loadFromString(xmlString);
		    } catch (XMLException e) {
		      e.printStackTrace();
		    }
		    XMLNode root = doc.getRoot();
		    encodeNode(root);
		    return doc.toString();
		  }
	  public static void encodeNode(XMLNode node) {
		    String[] attrNames = node.getAttributeNames();
		    int size_attrNames = (attrNames == null) ? 0 : attrNames.length;
		    for (int i = 0; i < size_attrNames; i++) {
		      node.setAttribute(attrNames[i], encodeGbkBase64(node.getAttributeValue(attrNames[i])));
		    }
		    XMLNode[] childNodes = node.getAllChildNode();
		    int size_childNodes = (childNodes == null) ? 0 : childNodes.length;
		    for (int i = 0; i < size_childNodes; i++) {
		      encodeNode(childNodes[i]);
		    }
		  }
	  public static String decodeXmlNodeGbkBase64(String xmlString) {
		    XMLDocument doc = new XMLDocument();
		    try {
		      doc.loadFromString(xmlString);
		    } catch (XMLException e) {
		      e.printStackTrace();
		    }
		    XMLNode root = doc.getRoot();
		    decodeNode(root);
		    return doc.toString();
		  }

		  public static void decodeNode(XMLNode node) {
		    String[] attrNames = node.getAttributeNames();
		    int size_attrNames = (attrNames == null) ? 0 : attrNames.length;
		    for (int i = 0; i < size_attrNames; i++) {
		      node.setAttribute(attrNames[i], decodeBase64Gbk(node.getAttributeValue(attrNames[i])));
		    }
		    XMLNode[] childNodes = node.getAllChildNode();
		    int size_childNodes = (childNodes == null) ? 0 : childNodes.length;
		    for (int i = 0; i < size_childNodes; i++) {
		      decodeNode(childNodes[i]);
		    }
		  }
		    /**
		     * 先GBK转码,再Base64加密
		     * 
		     * @param str
		     * @return
		     */
		    public static String decodeBase64Gbk(String str) {
		      str = trim(str);

		      str = Basic64.decode(str);

		      try {
		        str = new String(str.getBytes("GBK"));
		      } catch (UnsupportedEncodingException e) {
		        e.printStackTrace();
		      }

		      return str;
		    }

}
