package com.jsegov.fy.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ShareMethods {
	/**
	 * 用于格式化数值型数据
	 * 
	 * @author liuz
	 * @param value
	 * @param precision
	 * @return 按精度类型格式化
	 */
	public static Double formatNumber(Object value, String precision) {
		Double revalue=0.0;
		if(value!=null){
			BigDecimal bd = new BigDecimal(value.toString());
			BigDecimal one = new BigDecimal("1");
			bd = bd.divide(one, Integer.parseInt(precision),
					BigDecimal.ROUND_HALF_UP);
			// System.out.println("bigDecimal:"+bd);
			revalue = bd.doubleValue();
		}
		return revalue;
	}
	
	/**
	 * 获取当前时间
	 * 
	 * @return 日期型当前时间
	 * 
	 */
	public static String getCurrTime(Object date) {
		String date1 = "";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		if(date!=null){
			try {
				date1 = sdf.format(DateFormat.getDateInstance().parse(date.toString()));
			} catch (ParseException e) {
			}
		}
		return date1;
	}
	
	/**
	 * 转换字符串
	 * 
	 * @return 
	 */
	public static String getStringFromObject(Object value) {
		String str="";
		if(value!=null)
			str=value.toString();
		return str;
	}
	
	public static void main(String[] args) {
		String date="2012-09-12";
		getCurrTime(date);
	}
}
