package com.jsegov.fy.action;

import java.io.*;
import java.net.URLDecoder;
import java.util.*;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import tdh.util.Basic64;

import com.gtis.util.UUIDGenerator;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.jsegov.fy.dao.GtcfDAO;
import com.jsegov.fy.dao.GtcxqqDAO;
import com.jsegov.fy.dao.GtxxDAO;
import com.jsegov.fy.util.TranscodingUtils;
import com.jsegov.fy.util.WebServiceClientHelper;
import com.jsegov.fy.util.XmlUtils;
import com.jsegov.fy.vo.GtcfVo;
import com.jsegov.fy.vo.GtcxqqVo;
import com.jsegov.fy.vo.GtxxVo;
import com.jsegov.tddj.util.CommonUtil;
import com.opensymphony.xwork2.ActionSupport;

public class GtcxqqListAction extends ActionSupport{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private SplitParam splitParam;
	private GtcxqqDAO gtcxqqDAO;
	private GtxxDAO gtxxDAO;
	private String gtcxqqUrl;
	private String username;
	private String password;
	private String msg;
	private String gtcxqqId;
	private GtxxVo gtxx;
	private String type;
	private String bdhm;
	private String delGtxxId;
	private GtcfDAO gtcfDAO;
	private GtcfVo gtcf;
	private String delGtcfId;
	private String gtcxqqIds;
	private File xmlFile;
	private static final Log log = LogFactory.getLog(GtcxqqListAction.class);
	
	public String execute()throws IOException{	
		HashMap<String, Object> map = new HashMap<String, Object>();
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtcxqqList");
		s.setQueryParam(map);
		this.splitParam = s;
		return SUCCESS;
	}
	
	public String submitXmlFile() throws DocumentException{

		List<GtcxqqVo> gtcxqqList=null;
		if(xmlFile!=null){
			//创建一个读取XML文件的对象     
	        SAXReader reader=new SAXReader();     
	        //创建一个文档对象     
	        Document document=reader.read(xmlFile);     
	        gtcxqqList=XmlUtils.getGtcxqqVoListFromDocument(document);	        
		}
		if(gtcxqqList!=null){
            for(int i=0;i<gtcxqqList.size();i++){
                GtcxqqVo gtcxqqVo=gtcxqqList.get(i);
				if(gtcxqqVo!=null && StringUtils.isNotBlank(gtcxqqVo.getBdhm())){
					HashMap<String, Object> parmsMap=new HashMap<String, Object>();
					parmsMap.put("bdhm", gtcxqqVo.getBdhm());
					List<GtcxqqVo> gtcxqqList1=gtcxqqDAO.queryGtcxqqList(parmsMap);
					if(gtcxqqList1.size()>0)
						gtcxqqDAO.updateGtcxqq(gtcxqqVo);
					else
						gtcxqqDAO.insertGtcxqq(gtcxqqVo);
                    HashMap<String, Object> paramMap=new HashMap<String, Object>();
                    paramMap.put("gtcxqqId",gtcxqqVo.getGtcxqqId());
                    List<GtxxVo> gtxxList=gtxxDAO.queryGtxxList(paramMap);
				    if(gtxxList==null ||gtxxList.size()==0){
                        List<HashMap> gtxxFromDjList=new ArrayList<HashMap>();
                        HashMap<String, Object> queryMap =new HashMap<String, Object>();
                        if(gtcxqqVo!=null && StringUtils.isNotBlank(gtcxqqVo.getDsrzjhm())&&!gtcxqqVo.getDsrzjhm().trim().equals("不详")){
                            queryMap.put("rf1_sfzmnum", "%"+gtcxqqVo.getDsrzjhm()+"%");
                            gtxxFromDjList=gtxxDAO.queryGtxxFromDJ(queryMap);
                        }
                        if(gtcxqqVo!=null && StringUtils.isNotBlank(gtcxqqVo.getXm())&&gtcxqqVo.getXm().trim().equals("不详")){
                            queryMap.put("qlr", "%"+gtcxqqVo.getXm()+"%");
                            gtxxFromDjList=gtxxDAO.queryGtxxFromDJ(queryMap);
                        }
                        if(gtxxFromDjList!=null && gtxxFromDjList.size()>0){
                            for(HashMap<?, ?> map1:gtxxFromDjList){
                                GtxxVo gtxxVo=XmlUtils.getGtxxVo(map1);
                                if(gtxxVo!=null){
                                    gtxxVo.setBdhm(gtcxqqVo.getBdhm());
                                    gtxxVo.setGtcxqqId(gtcxqqVo.getGtcxqqId());
                                    gtxxDAO.insertGtxx(gtxxVo);
                                }
                            }
                        }
                    }
				}
            }

        }
		SplitParamImpl s = new SplitParamImpl();	
		s.setQueryString("queryGtcxqqList");
		//s.setQueryParam(map);
		this.splitParam = s;
		return SUCCESS;
	}
	public String gotoXML() throws IOException{
		HttpServletResponse response = ServletActionContext.getResponse();
		StringBuffer stringBuffer=new StringBuffer();
		if(StringUtils.isNotBlank(gtcxqqIds)){
			String[] queryGtcxqqId=gtcxqqIds.split(",");
			
			if(queryGtcxqqId!=null && queryGtcxqqId.length>0)
				stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><gtxxList>");
			for(int i=0;i<queryGtcxqqId.length;i++){
				HashMap queryMap=new HashMap();
				queryMap.put("gtcxqqId", queryGtcxqqId[i]);
				List<GtxxVo> gtxxList=gtxxDAO.queryGtxxList(queryMap);
				List<GtcxqqVo> gtcxqqList=gtcxqqDAO.queryGtcxqqList(queryMap);
				if(gtxxList!=null && gtxxList.size()>0){
                    for(int j=0;j<gtxxList.size();j++){
                        GtxxVo gtxxVo=gtxxList.get(j);
                        if(gtxxVo!=null && StringUtils.isNotBlank(gtxxVo.getCqzh())){
                            HashMap cfMap=new HashMap();
                            cfMap.put("cqzh", gtxxVo.getCqzh());
                            List<GtcfVo> gtcfVos=gtcfDAO.queryGtcfList(cfMap);
                            stringBuffer.append(XmlUtils.getGtxxXml(gtxxVo, gtcfVos, i));
                        }
                    }
				}
			}
			if(queryGtcxqqId!=null && queryGtcxqqId.length>0)
				stringBuffer.append("</gtxxList>");
			if(StringUtils.isBlank(stringBuffer.toString()))
				stringBuffer.append("查无国土信息");
			System.out.println("提交xml"+stringBuffer.toString());
		}
		String filePath = ServletActionContext.getServletContext().getRealPath("/") + "downLoad\\GTFHXX.xml";
		File xmlFile = new File(filePath);
		FileOutputStream os = new FileOutputStream(xmlFile);
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        osw.write(stringBuffer.toString());
        osw.flush();
        response.setContentType("text/xml;charset=UTF-8");
		response.addHeader("Content-Disposition", "attachment; filename=GTFHXX.xml");
		response.setContentLength((int) xmlFile.length());
        try {
            java.io.OutputStream os1 = response.getOutputStream();
            BufferedWriter bw1=new BufferedWriter(new OutputStreamWriter(os1,"UTF-8"));
            java.io.FileInputStream fis = new java.io.FileInputStream(filePath);
            BufferedReader br = new BufferedReader(new InputStreamReader(
                    fis,"UTF-8"));
			String  i = null;
			while ((i = br.readLine())!= null) {
                System.out.println(i);
                bw1.write(i);
                bw1.newLine();
			}
            bw1.flush();
            bw1.close();
            br.close();

		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public String getGtcxqqList()throws IOException{
		msg="";
		if(StringUtils.isNotBlank(username))
			username=URLDecoder.decode(username,"UTF-8");
		if(StringUtils.isNotBlank(password))
			password=URLDecoder.decode(password,"UTF-8");
		String usermarkerXml=XmlUtils.getUsermarkerXml(username,password);
		usermarkerXml=Basic64.encode(TranscodingUtils.encodeXmlNodeGbkBase64(usermarkerXml));
		
		//System.out.println("加密后的xml="+usermarkerXml);
		if(StringUtils.isBlank(usermarkerXml)){
			msg="没有配置用户名和密码！";
			log.error("没有配置用户名和密码！");
		}else{
			StringBuffer queryInfos1 =new StringBuffer();
			List<GtcxqqVo> gtcxqqList=null;
			if(StringUtils.isNotBlank(gtcxqqUrl))
				queryInfos1 = WebServiceClientHelper.callService(StringUtils.trim(gtcxqqUrl),"getXzcxGtList",usermarkerXml);
			StringBuffer queryInfos =new StringBuffer();
			queryInfos=queryInfos.append(TranscodingUtils.decodeXmlNodeGbkBase64(Basic64.decode(queryInfos1.toString())));
			System.out.println("调用webservice成功，返回的xml为:"+queryInfos);
//			queryInfos.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><gtcxqqList><gtcxqq BDHM=\"20111\" LB=\"GT\"" +
//					" XZ=\"1\" XM=\"333\" GJ=\"中国\" ZJLX=\"01\" DSRZJHM=\"320422196511053334\" FZJG=\"江苏南京\" " +
//					"FYMC=\"南京市中级人民法院\" CBR=\"张三\" AH=\"(2011)宁执字第00003号\"></gtcxqq><gtcxqq BDHM=\"20113\" LB=\"GT\"" +
//					" XZ=\"1\" XM=\"333\" GJ=\"中国\" ZJLX=\"01\" DSRZJHM=\"320407000201112020071S\" FZJG=\"江苏南京\" " +
//					"FYMC=\"南京市中级人民法院\" CBR=\"张三\" AH=\"(2011)宁执字第00003号\"></gtcxqq></gtcxqqList>");
			if(StringUtils.indexOf(queryInfos.toString(), "ErrorMSG")>-1){
				msg=queryInfos.substring( StringUtils.indexOf(queryInfos.toString(), "ErrorMSG")+9,queryInfos.toString().length()).substring(0,(queryInfos.substring( StringUtils.indexOf(queryInfos.toString(), "ErrorMSG")+9,queryInfos.toString().length())).replaceAll(" ","").indexOf("\">"));
				log.error(CommonUtil.formateDate(new Date())+"返回的查询信息："+queryInfos);
			}else
				gtcxqqList=XmlUtils.getGtcxqqVoListFromXml(queryInfos);
			if(gtcxqqList!=null){
				for(GtcxqqVo gtcxqqVo:gtcxqqList){
					if(gtcxqqVo!=null && StringUtils.isNotBlank(gtcxqqVo.getBdhm())){
						HashMap<String, Object> parmsMap=new HashMap<String, Object>();
						parmsMap.put("bdhm", gtcxqqVo.getBdhm());
						List<GtcxqqVo> gtcxqqList1=gtcxqqDAO.queryGtcxqqList(parmsMap);
						if(gtcxqqList1.size()>0)
							gtcxqqDAO.updateGtcxqq(gtcxqqVo);
						else
							gtcxqqDAO.insertGtcxqq(gtcxqqVo);
					}
				}
			}
		}
		
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put("begin_time", CommonUtil.formateDate(new Date()));
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtcxqqList");
		s.setQueryParam(map);
		this.splitParam = s;
		return SUCCESS;
	}
	
	public void getGtcxqqXml() throws IOException{
		
		ServletActionContext.getResponse().setContentType("text/xml;charset=UTF-8");
        ServletActionContext.getResponse().getOutputStream().write(msg.getBytes());
        ServletActionContext.getResponse().getOutputStream().flush();
        ServletActionContext.getResponse().getOutputStream().close();
	}
	public String showGtcxqqInfo() {
		if(StringUtils.isNotBlank(gtcxqqId)){
			HashMap<String, Object> map =new HashMap<String, Object>();
			map.put("gtcxqqId", gtcxqqId);
			SplitParamImpl s = new SplitParamImpl();
			
			s.setQueryString("queryGtxxList");
			s.setQueryParam(map);
			this.splitParam = s;	
		}
		return "showGtcxqqInfo";
	}
	
	public String showGtxxInfo() {
		if(StringUtils.isNotBlank(gtcxqqId)){
			HashMap<String, String> map =new HashMap<String, String>();
			map.put("gtcxqqId", gtcxqqId);
			SplitParamImpl s = new SplitParamImpl();
			
			gtxx=new GtxxVo();
			gtxx.setBdhm(bdhm);
			gtxx.setGtcxqqId(gtcxqqId);
			
			s.setQueryString("queryGtxxList");
			s.setQueryParam(map);
			this.splitParam = s;	
		}
		
		return "showGtxxInfo";
	}
	
	public String saveGtxx(){
		if(gtxx!=null ){
			if(StringUtils.isNotBlank(gtxx.getGtxxId())){
				if(StringUtils.equals(type, "save")){
					gtxxDAO.updateGtxx(gtxx);
				}else if(!StringUtils.equals(type, "add")){
					HashMap<String, Object> map1 =new HashMap<String, Object>();
					map1.put("gtxxId", gtxx.getGtxxId());
					List<GtxxVo> gtxxList=gtxxDAO.queryGtxxList(map1);
					if(gtxxList!=null && gtxxList.size()>0){
						gtxx=gtxxList.get(0);
						if(gtxx!=null && StringUtils.isNotBlank(gtxx.getDjsj()))
							gtxx.setDjsj(StringUtils.substring(gtxx.getDjsj(), 0,10));
						if(gtxx!=null && StringUtils.isNotBlank(gtxx.getDjrq()))
							gtxx.setDjrq(StringUtils.substring(gtxx.getDjrq(), 0,10));
						
					}
				}
			}
			if(StringUtils.equals(type, "add")){
				gtxx.setGtxxId(UUIDGenerator.generate());
				gtxxDAO.insertGtxx(gtxx);
			}
			HashMap<String, String> map =new HashMap<String, String>();
			map.put("gtcxqqId", gtxx.getGtcxqqId());
			SplitParamImpl s = new SplitParamImpl();
			
			s.setQueryString("queryGtxxList");
			s.setQueryParam(map);
			this.splitParam = s;	
		}
		
		return "showGtxxInfo";
	}
	
	public String delGtxx(){
		if(StringUtils.isNotBlank(delGtxxId)){
			String[] gtxxIds=delGtxxId.split(",");
			for(int i=0;i<gtxxIds.length;i++){
				gtxxDAO.deleteGtxxById(gtxxIds[i]);
				gtcfDAO.deleteGtcfByGtcxqqId(gtxxIds[i]);
			}
		}
		GtxxVo newGtxx=new GtxxVo();
		newGtxx.setBdhm(gtxx.getBdhm());
		newGtxx.setGtcxqqId(gtxx.getGtcxqqId());
		gtxx=newGtxx;
		
		HashMap<String, String> map =new HashMap<String, String>();
		map.put("gtcxqqId", gtxx.getGtcxqqId());
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtxxList");
		s.setQueryParam(map);
		this.splitParam = s;	
		
		return "showGtxxInfo";
	}
	
	
	public String showGtcfInfo() {
		if(StringUtils.isNotBlank(gtcxqqId)){
			HashMap<String, Object> map =new HashMap<String, Object>();
			map.put("gtcxqqId", gtcxqqId);
			List<GtcxqqVo> gtcxqqList=gtcxqqDAO.queryGtcxqqList(map);
			if(gtcxqqList!=null && gtcxqqList.size()>0){
				GtcxqqVo gtcxqq=gtcxqqList.get(0);
				map.put("iscf", true);
				
				List<GtcfVo> gtcfList=gtcfDAO.queryGtcfList(map);
				if(gtcfList==null ||gtcfList.size()==0){		
					List<GtxxVo> gtxxList=gtxxDAO.queryGtxxList(map);
					for(GtxxVo gtxxVo : gtxxList){
						List<HashMap> gtcfFromDjList=new ArrayList<HashMap>();
						String cqzh=gtxxVo.getCqzh();
						HashMap<String, Object> queryMap =new HashMap<String, Object>();					
						if(StringUtils.isNotBlank(cqzh)){
							queryMap.put("cqzh", cqzh);
							gtcfFromDjList=gtcfDAO.queryGtcfFromDJ(queryMap);
						}				
						if(gtcfFromDjList!=null && gtcfFromDjList.size()>0){
							for(HashMap<?, ?> map1:gtcfFromDjList){
								GtcfVo gtcfVo=XmlUtils.getGtcfVo(map1);
								if(gtcfVo!=null){
									gtcfVo.setBdhm(gtcxqq.getBdhm());
									gtcfVo.setGtcxqqId(gtcxqq.getGtcxqqId());
									gtcfDAO.insertGtcf(gtcfVo);
								}
							}
						}
					}
				}
			}
			gtcf=new GtcfVo();
			gtcf.setBdhm(bdhm);
			gtcf.setGtcxqqId(gtcxqqId);
			
			SplitParamImpl s = new SplitParamImpl();
			map.put("iscf", true);
			s.setQueryString("queryGtcfList");
			s.setQueryParam(map);
			this.splitParam = s;	
		}
		
		return "showGtcfInfo";
	}
	
	public String saveGtcf(){
		if(gtcf!=null ){
			if(StringUtils.isNotBlank(gtcf.getGtcfId())){
				if(StringUtils.equals(type, "save")){
					gtcfDAO.updateGtcf(gtcf);
				}else if(!StringUtils.equals(type, "add")){
					HashMap<String, Object> map1 =new HashMap<String, Object>();
					map1.put("gtcfId", gtcf.getGtcfId());
					map1.put("iscf", true);
					List<GtcfVo> gtcfList=gtcfDAO.queryGtcfList(map1);
					if(gtcfList!=null && gtcfList.size()>0){
						gtcf=gtcfList.get(0);
						if(gtcf!=null && StringUtils.isNotBlank(gtcf.getKzksrq()))
							gtcf.setKzksrq(StringUtils.substring(gtcf.getKzksrq(), 0,10));
						if(gtcf!=null && StringUtils.isNotBlank(gtcf.getKzjsrq()))
							gtcf.setKzjsrq(StringUtils.substring(gtcf.getKzjsrq(), 0,10));
						
					}
				}
			}
			if(StringUtils.equals(type, "add")){
				gtcf.setGtcfId(UUIDGenerator.generate());
				gtcfDAO.insertGtcf(gtcf);
			}
			HashMap<String, Comparable> map =new HashMap<String, Comparable>();
			map.put("gtcxqqId", gtcf.getGtcxqqId());
			map.put("iscf", true);
			SplitParamImpl s = new SplitParamImpl();
			
			s.setQueryString("queryGtcfList");
			s.setQueryParam(map);
			this.splitParam = s;	
		}
		
		return "showGtcfInfo";
	}
	
	public String delGtcf(){
		if(StringUtils.isNotBlank(delGtcfId)){
			String[] gtcfIds=delGtcfId.split(",");
			for(int i=0;i<gtcfIds.length;i++){
				gtcfDAO.deleteGtcfById(gtcfIds[i]);
			}
		}
		GtcfVo newGtcf=new GtcfVo();
		newGtcf.setBdhm(gtcf.getBdhm());
		newGtcf.setGtcxqqId(gtcf.getGtcxqqId());
		gtcf=newGtcf;
		
		HashMap<String, Comparable> map =new HashMap<String, Comparable>();
		map.put("gtcxqqId", gtcf.getGtcxqqId());
		map.put("iscf", true);
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtcfList");
		s.setQueryParam(map);
		this.splitParam = s;	
		
		return "showGtcfInfo";
	}
	
	public String showGtdyInfo() {
		if(StringUtils.isNotBlank(gtcxqqId)){
			HashMap<String, Object> map =new HashMap<String, Object>();
			map.put("gtcxqqId", gtcxqqId);
			List<GtcxqqVo> gtcxqqList=gtcxqqDAO.queryGtcxqqList(map);
			if(gtcxqqList!=null && gtcxqqList.size()>0){
				GtcxqqVo gtcxqq=gtcxqqList.get(0);
				map.put("isdy", true);				
				List<GtcfVo> gtcfList=gtcfDAO.queryGtcfList(map);
				if(gtcfList==null ||gtcfList.size()==0){
					List<GtxxVo> gtxxList=gtxxDAO.queryGtxxList(map);
					for(GtxxVo gtxxVo : gtxxList){
						List<HashMap> gtcfFromDjList=new ArrayList<HashMap>();
						String cqzh=gtxxVo.getCqzh();
						HashMap<String, Object> queryMap =new HashMap<String, Object>();
						if(StringUtils.isNotBlank(cqzh)){
							queryMap.put("cqzh", cqzh);
							gtcfFromDjList=gtcfDAO.queryGtdyFromDJ(queryMap);
						}			
						if(gtcfFromDjList!=null && gtcfFromDjList.size()>0){
							for(HashMap<?, ?> map1:gtcfFromDjList){
								GtcfVo gtcfVo=XmlUtils.getGtcfVo(map1);
								if(gtcfVo!=null){
									gtcfVo.setBdhm(gtcxqq.getBdhm());
									gtcfVo.setGtcxqqId(gtcxqq.getGtcxqqId());
									gtcfDAO.insertGtcf(gtcfVo);
								}
							}
						}
					}
				}
			}
			gtcf=new GtcfVo();
			gtcf.setBdhm(bdhm);
			gtcf.setGtcxqqId(gtcxqqId);
			
			SplitParamImpl s = new SplitParamImpl();
			map.put("isdy", true);
			s.setQueryString("queryGtcfList");
			s.setQueryParam(map);
			this.splitParam = s;	
		}
		
		return "showGtdyInfo";
	}
	
	public String saveGtdy(){
		if(gtcf!=null ){
			if(StringUtils.isNotBlank(gtcf.getGtcfId())){
				if(StringUtils.equals(type, "save")){
					gtcfDAO.updateGtcf(gtcf);
				}else if(!StringUtils.equals(type, "add")){
					HashMap<String, Object> map1 =new HashMap<String, Object>();
					map1.put("gtcfId", gtcf.getGtcfId());
					map1.put("isdy", true);
					List<GtcfVo> gtcfList=gtcfDAO.queryGtcfList(map1);
					if(gtcfList!=null && gtcfList.size()>0){
						gtcf=gtcfList.get(0);
					}
				}
			}
			if(StringUtils.equals(type, "add")){
				gtcf.setGtcfId(UUIDGenerator.generate());
				gtcfDAO.insertGtcf(gtcf);
			}
			HashMap<String, Comparable> map =new HashMap<String, Comparable>();
			map.put("gtcxqqId", gtcf.getGtcxqqId());
			map.put("isdy", true);
			SplitParamImpl s = new SplitParamImpl();
			
			s.setQueryString("queryGtcfList");
			s.setQueryParam(map);
			this.splitParam = s;	
		}
		
		return "showGtdyInfo";
	}
	
	public String delGtdy(){
		if(StringUtils.isNotBlank(delGtcfId)){
			String[] gtcfIds=delGtcfId.split(",");
			for(int i=0;i<gtcfIds.length;i++){
				gtcfDAO.deleteGtcfById(gtcfIds[i]);
			}
		}
		GtcfVo newGtcf=new GtcfVo();
		newGtcf.setBdhm(gtcf.getBdhm());
		newGtcf.setGtcxqqId(gtcf.getGtcxqqId());
		gtcf=newGtcf;
		
		HashMap<String, Comparable> map =new HashMap<String, Comparable>();
		map.put("gtcxqqId", gtcf.getGtcxqqId());
		map.put("isdy", true);
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtcfList");
		s.setQueryParam(map);
		this.splitParam = s;	
		
		return "showGtdyInfo";
	}
	
	public String queryGtcf(){
		HashMap<String, Comparable> map =new HashMap<String, Comparable>();
		map.put("gtcxqqId", gtcf.getGtcxqqId());
		map.put("iscf", true);
		map.put("cqzh", gtcf.getCqzh());
		map.put("qzjg", gtcf.getQzjg());
		map.put("qzwh", gtcf.getQzwh());
		map.put("kzksrq", gtcf.getKzksrq());
		map.put("kzjsrq", gtcf.getKzjsrq());
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtcfList");
		s.setQueryParam(map);
		this.splitParam = s;
		return "showGtcfInfo";
	}
	
	public String queryGtdy(){
		HashMap<String, Comparable> map =new HashMap<String, Comparable>();
		map.put("gtcxqqId", gtcf.getGtcxqqId());
		map.put("isdy", true);
		map.put("cqzh", gtcf.getCqzh());
		map.put("txzh", gtcf.getTxzh());
		map.put("dyqr", gtcf.getDyqr());
		map.put("dyje", gtcf.getDyje());
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtcfList");
		s.setQueryParam(map);
		this.splitParam = s;
		return "showGtdyInfo";
	}
	public String queryGtxx(){
		HashMap<String, Comparable> map =new HashMap<String, Comparable>();
		map.put("gtcxqqId", gtxx.getGtcxqqId());
		map.put("bdhm", gtxx.getBdhm());
		map.put("cqzh", gtxx.getCqzh());
		map.put("djr", gtxx.getDjr());
		map.put("gtdz", gtxx.getGtdz());
		map.put("tdmj", gtxx.getTdmj());
		
		map.put("qslb", gtxx.getQslb());
		map.put("gyqk", gtxx.getGyqk());
		map.put("febl", gtxx.getFebl());
		map.put("djjg", gtxx.getDjjg());
		map.put("djsj", gtxx.getDjsj());
		map.put("djrq", gtxx.getDjrq());
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtxxList");
		s.setQueryParam(map);
		this.splitParam = s;
		return "showGtxxInfo";
	}
	
	public String submitDJInfo()throws IOException{
		msg="";
		if(StringUtils.isNotBlank(username))
			username=URLDecoder.decode(username,"UTF-8");
		if(StringUtils.isNotBlank(password))
			password=URLDecoder.decode(password,"UTF-8");
		String usermarkerXml=XmlUtils.getUsermarkerXml(username, password);
		usermarkerXml=Basic64.encode(TranscodingUtils.encodeXmlNodeGbkBase64(usermarkerXml));
		if(StringUtils.isBlank(usermarkerXml)){
			msg="没有配置用户名和密码！";
			log.error("没有配置用户名和密码！");
		}else{
			if(StringUtils.isNotBlank(gtcxqqIds)){
				String[] queryGtcxqqId=gtcxqqIds.split(",");
				StringBuffer stringBuffer=new StringBuffer();
				if(queryGtcxqqId!=null && queryGtcxqqId.length>0)
					stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><gtxxList>");
				for(int i=0;i<queryGtcxqqId.length;i++){
					HashMap queryMap=new HashMap();
					queryMap.put("gtcxqqId", queryGtcxqqId[i]);
					List<GtxxVo> gtxxList=gtxxDAO.queryGtxxList(queryMap);
					List<GtcxqqVo> gtcxqqList=gtcxqqDAO.queryGtcxqqList(queryMap);
					if(gtxxList!=null && gtxxList.size()>0){
						GtxxVo gtxxVo=gtxxList.get(0);
						if(gtxxVo!=null && StringUtils.isNotBlank(gtxxVo.getCqzh())){
							HashMap cfMap=new HashMap();
							cfMap.put("cqzh", gtxxVo.getCqzh());
							List<GtcfVo> gtcfVos=gtcfDAO.queryGtcfList(cfMap);
							
							stringBuffer.append(XmlUtils.getGtxxXml(gtxxVo, gtcfVos, i));
							
						}
					}
				}
				if(queryGtcxqqId!=null && queryGtcxqqId.length>0)
					stringBuffer.append("</gtxxList>");
				System.out.println("提交xml"+stringBuffer.toString());
				if(StringUtils.isBlank(stringBuffer.toString()))
					stringBuffer.append("查无国土信息");
				String stringBuffer1="";
				stringBuffer1=Basic64.encode(TranscodingUtils.encodeXmlNodeGbkBase64(stringBuffer.toString()));
				StringBuffer resultInfos1=new StringBuffer();
				if(StringUtils.isNotBlank(gtcxqqUrl))
					resultInfos1 = WebServiceClientHelper.callService(StringUtils.trim(gtcxqqUrl),"gtfeedXzcxInfo",usermarkerXml,stringBuffer1);
//				resultInfos.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><result ><cxjglist><jg bdhm=\"20113\" result=\"success\" msg=\"\"></jg>" +
//						"<jg bdhm=\"20111\" result=\"fail\" msg=\"test2\"></jg></cxjglist></result>");
				StringBuffer resultInfos=new StringBuffer();
				//System.out.println("返回加密xml"+resultInfos1.toString());
				resultInfos=resultInfos.append(TranscodingUtils.decodeXmlNodeGbkBase64(Basic64.decode(resultInfos1.toString())));
				System.out.println("返回解密xml"+resultInfos.toString());
				if(StringUtils.isNotBlank(resultInfos.toString())){
					if(StringUtils.indexOf(resultInfos.toString(), "errMsg")>-1){
						msg=resultInfos.substring( StringUtils.indexOf(resultInfos.toString(), "errMsg")+8,resultInfos.toString().length()).substring(0,(resultInfos.substring( StringUtils.indexOf(resultInfos.toString(), "errMsg")+8,resultInfos.toString().length())).replaceAll(" ","").indexOf("\">"));
						log.error(CommonUtil.formateDate(new Date())+"返回的信息："+resultInfos);
					}else{
						List<GtcxqqVo> gtcxList=XmlUtils.getResultGtcxqq(resultInfos);
						if(gtcxList!=null && gtcxList.size()>0){
							for(GtcxqqVo gtcx:gtcxList){
								if(StringUtils.isNotBlank(gtcx.getBdhm())){
									HashMap map2=new HashMap();
									map2.put("bdhm", gtcx.getBdhm());
									List<GtcxqqVo> gtcxList1=gtcxqqDAO.queryGtcxqqList(map2);
									if(gtcxList1!=null && gtcxList1.size()==1){
										GtcxqqVo gtcx1=gtcxList1.get(0);
										gtcx1.setResultStatus(gtcx.getResultStatus());
										gtcx1.setMsg(gtcx.getMsg());
										gtcx1.setResultDate(new Date());
										gtcxqqDAO.updateGtcxqq(gtcx1);
									}
								}
							}
						}
					}
						
				}
			}
		}
		
		HashMap<String, Object> map = new HashMap<String, Object>();
		map.put("begin_time", CommonUtil.formateDate(new Date()));
		SplitParamImpl s = new SplitParamImpl();
		
		s.setQueryString("queryGtcxqqList");
		s.setQueryParam(map);
		this.splitParam = s;
		return SUCCESS;
	}
//	public void insertGtcxInfo(String gtcxqqIds){
//		if(StringUtils.isNotBlank(gtcxqqIds)){
//			String[] gtcxqqIds1=gtcxqqIds.split(",");
//			for(String gtcxqqId1:gtcxqqIds1){
//				HashMap<String, Object> map =new HashMap<String, Object>();
//				map.put("gtcxqqId", gtcxqqId1);
//				List<GtcxqqVo> gtcxqqList=gtcxqqDAO.queryGtcxqqList(map);
//				if(gtcxqqList!=null && gtcxqqList.size()>0){
//					GtcxqqVo gtcxqq=gtcxqqList.get(0);
//					List<HashMap> gtxxFromDjList=new ArrayList<HashMap>();
//					List<GtxxVo> gtxxList=gtxxDAO.queryGtxxList(map);
//					if(gtxxList==null ||gtxxList.size()==0){
//						HashMap<String, Object> queryMap =new HashMap<String, Object>();
//						if(gtcxqq!=null && StringUtils.isNotBlank(gtcxqq.getDsrzjhm())){
//							queryMap.put("rf1_sfzmnum", gtcxqq.getDsrzjhm());
//							gtxxFromDjList=gtxxDAO.queryGtxxFromDJ(queryMap);
//						}
//						if(gtxxFromDjList!=null && gtxxFromDjList.size()>0){
//							for(HashMap<?, ?> map1:gtxxFromDjList){
//								GtxxVo gtxxVo=XmlUtils.getGtxxVo(map1);
//								if(gtxxVo!=null){
//									gtxxVo.setBdhm(gtcxqq.getBdhm());
//									gtxxVo.setGtcxqqId(gtcxqq.getGtcxqqId());
//									gtxxDAO.insertGtxx(gtxxVo);
//								}
//							}
//						}
//					}
//					HashMap<String, Object> map2 =new HashMap<String, Object>();
//					map2.put("gtcxqqId", gtcxqqId1);
//					map2.put("iscf", true);
//					List<HashMap> gtcfFromDjList=new ArrayList<HashMap>();
//					List<GtcfVo> gtcfList=gtcfDAO.queryGtcfList(map2);
//					if(gtcfList==null ||gtcfList.size()==0){
//						HashMap<String, Object> queryMap =new HashMap<String, Object>();
//						if(gtcxqq!=null && StringUtils.isNotBlank(gtcxqq.getDsrzjhm())){
//							queryMap.put("rf1_sfzmnum", gtcxqq.getDsrzjhm());
//							gtcfFromDjList=gtcfDAO.queryGtcfFromDJ(queryMap);
//						}
//						if(gtcfFromDjList!=null && gtcfFromDjList.size()>0){
//							for(HashMap<?, ?> map1:gtcfFromDjList){
//								GtcfVo gtcfVo=XmlUtils.getGtcfVo(map1);
//								if(gtcfVo!=null){
//									gtcfVo.setBdhm(gtcxqq.getBdhm());
//									gtcfVo.setGtcxqqId(gtcxqq.getGtcxqqId());
//									gtcfDAO.insertGtcf(gtcfVo);
//								}
//							}
//						}
//					}
//					HashMap<String, Object> map3 =new HashMap<String, Object>();
//					map3.put("gtcxqqId", gtcxqqId1);
//					map3.put("isdy", true);
//					List<HashMap> gtdyFromDjList=new ArrayList<HashMap>();
//					List<GtcfVo> gtdyList=gtcfDAO.queryGtcfList(map3);
//					if(gtdyList==null ||gtdyList.size()==0){
//						HashMap<String, Object> queryMap =new HashMap<String, Object>();
//						if(gtcxqq!=null && StringUtils.isNotBlank(gtcxqq.getDsrzjhm())){
//							queryMap.put("rf2_sfzmnum", gtcxqq.getDsrzjhm());
//							gtdyFromDjList=gtcfDAO.queryGtdyFromDJ(queryMap);
//						}
//						if(gtdyFromDjList!=null && gtdyFromDjList.size()>0){
//							for(HashMap<?, ?> map1:gtdyFromDjList){
//								GtcfVo gtcfVo=XmlUtils.getGtcfVo(map1);
//								if(gtcfVo!=null){
//									gtcfVo.setBdhm(gtcxqq.getBdhm());
//									gtcfVo.setGtcxqqId(gtcxqq.getGtcxqqId());
//									gtcfDAO.insertGtcf(gtcfVo);
//								}
//							}
//						}
//					}
//				}
//			}
//		}
//		
//	}
	public SplitParam getSplitParam() {
		return splitParam;
	}
	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}
	public GtcxqqDAO getGtcxqqDAO() {
		return gtcxqqDAO;
	}
	public void setGtcxqqDAO(GtcxqqDAO gtcxqqDAO) {
		this.gtcxqqDAO = gtcxqqDAO;
	}

	public String getGtcxqqUrl() {
		return gtcxqqUrl;
	}

	public void setGtcxqqUrl(String gtcxqqUrl) {
		this.gtcxqqUrl = gtcxqqUrl;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public String getGtcxqqId() {
		return gtcxqqId;
	}

	public void setGtcxqqId(String gtcxqqId) {
		this.gtcxqqId = gtcxqqId;
	}

	public GtxxDAO getGtxxDAO() {
		return gtxxDAO;
	}

	public void setGtxxDAO(GtxxDAO gtxxDAO) {
		this.gtxxDAO = gtxxDAO;
	}

	public GtxxVo getGtxx() {
		return gtxx;
	}

	public void setGtxx(GtxxVo gtxx) {
		this.gtxx = gtxx;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getBdhm() {
		return bdhm;
	}

	public void setBdhm(String bdhm) {
		this.bdhm = bdhm;
	}

	public String getDelGtxxId() {
		return delGtxxId;
	}

	public void setDelGtxxId(String delGtxxId) {
		this.delGtxxId = delGtxxId;
	}

	public GtcfDAO getGtcfDAO() {
		return gtcfDAO;
	}

	public void setGtcfDAO(GtcfDAO gtcfDAO) {
		this.gtcfDAO = gtcfDAO;
	}

	public GtcfVo getGtcf() {
		return gtcf;
	}

	public void setGtcf(GtcfVo gtcf) {
		this.gtcf = gtcf;
	}

	public String getDelGtcfId() {
		return delGtcfId;
	}

	public void setDelGtcfId(String delGtcfId) {
		this.delGtcfId = delGtcfId;
	}

	public String getGtcxqqIds() {
		return gtcxqqIds;
	}

	public void setGtcxqqIds(String gtcxqqIds) {
		this.gtcxqqIds = gtcxqqIds;
	}

	public File getXmlFile() {
		return xmlFile;
	}

	public void setXmlFile(File xmlFile) {
		this.xmlFile = xmlFile;
	}
	
}
