package cn.gtmap.exchange.cxf.util;

import cn.gtmap.exchange.cxf.services.ExchangeDataService;
import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author zhangxing
 * @version V1.0, 13-9-26
 */
public class CommonUtil {
    public static String dataExchangeUrl;

    /**
     * 获取省级编号
     */
    public static   String getdjbhById(String proId) {
        ExchangeDataService exchangeDataService = (ExchangeDataService) Container.getBean("exchangeDataService");
        HashMap map = new HashMap();
        HashMap resultmap = new HashMap();
        String djbhString = "";
        if (StringUtils.isNotBlank(proId)) {
            map.put("PROJECTID", proId);
            List<HashMap> excdateList = exchangeDataService.getExchange(map);
            if (excdateList != null && excdateList.size() > 0) {
                resultmap = excdateList.get(0);
                if (resultmap.get("DJBH") != null) {
                    djbhString = resultmap.get("DJBH").toString();
                } else {
                    djbhString = "";
                }
            }
        }
        return djbhString;
    }

    /**
     * 用于打印组织数据xml数据源包含detail数据
     *
     * @param obj
     * @return
     */
    public static String getZSDataXML(Object obj) {
        StringBuffer sb = new StringBuffer();
        sb.append("<datas>");
        if (obj != null) {
            Field[] fds;
            try {
                fds = Class.forName(obj.getClass().getName())
                        .getDeclaredFields();
                for (int i = 0; i < fds.length; i++) {
                    String fieldName = fds[i].getName();
                    if (fieldName.equals("serialVersionUID")) {
                        continue;
                    }
                    String tempFieldName = fieldName.replaceFirst(fieldName
                            .substring(0, 1), fieldName.substring(0, 1)
                            .toUpperCase());
                    Method m = obj.getClass().getMethod("get" + tempFieldName,
                            null);
                    String returnType = m.getReturnType().getName();
                    String fieldValue = null;
                    if (returnType.equals("java.lang.String")) {
                        fieldValue = (String) m.invoke(obj, null);
                    } else if (returnType.equals("java.util.Date")) {
                        Date adate = (Date) m.invoke(obj, null);
                        if (adate == null) {
                            fieldValue = "";
                        } else {
                            fieldValue = formateDate(adate);
                        }
                    } else if (returnType.equals("java.lang.Integer")) {
                        Integer avalue = (Integer) m.invoke(obj, null);
                        avalue = avalue == null ? 0 : avalue;
                        fieldValue = avalue.toString();
                    } else if (returnType.equals("java.lang.Double")) {
                        Double dvalue = (Double) m.invoke(obj, null);
                        dvalue = dvalue == null ? 0 : dvalue;
                        fieldValue = dvalue.toString();
                    }
                    fieldValue = fieldValue == null ? "" : fieldValue;
                    fieldValue = fieldValue.replaceAll("<", "&lt;");
                    fieldValue = fieldValue.replaceAll(">", "&gt;");
                    // 签名图片
                    if (fieldName.indexOf("_sign") > -1) {
                        sb.append("<data name=\"" + fieldName
                                + "\" type=\"image\">");
                        sb.append("GetSignServlet?signid=" + fieldValue);
                        sb.append("</data>");
                    } else {
                        sb.append("<data name=\"" + fieldName
                                + "\" type=\"String(50)\">");
                        sb.append(fieldValue);
                        sb.append("</data>");
                    }
                    if (fieldName.indexOf("djbh") > -1) {
                        sb.append("<data name=\"" + fieldName
                                + "\" type=\"image\">");
                        sb.append(dataExchangeUrl + "/getEwm.action?djbh=" + fieldValue);
                        sb.append("</data>");
                    }

                }
                sb.append("</datas>");
            } catch (SecurityException e) {
                e.printStackTrace();
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    /**
     * 格式化时间
     *
     * @param date 类型为java.sql.date
     * @return 字符型日期值
     */
    public static String formateDate(java.sql.Date date) {
        String strDate = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        strDate = sdf.format(date);
        return strDate;
    }

    /**
     * 用于打印组织数据xml数据源detail数据
     *
     * @param list
     * @param detailId
     * @return
     */
    public static String getDetailXML(List list, String detailId) {
        StringBuffer sb = new StringBuffer();
        sb.append("<detail ID='");
        sb.append(detailId);
        sb.append("'>");
        for (int j = 0; j < list.size(); j++) {
            int k = j;
            sb.append("<row ID=\"" + k + "\">");
            Object obj = list.get(j);

            if (obj != null) {
                Field[] fds;
                try {
                    fds = Class.forName(obj.getClass().getName())
                            .getDeclaredFields();
                    for (int i = 0; i < fds.length; i++) {
                        String fieldName = fds[i].getName();
                        if (fieldName.equals("serialVersionUID")) {
                            continue;
                        }
                        String tempFieldName = fieldName.replaceFirst(fieldName
                                .substring(0, 1), fieldName.substring(0, 1)
                                .toUpperCase());
                        Method m = obj.getClass().getMethod(
                                "get" + tempFieldName, null);
                        String returnType = m.getReturnType().getName();
                        String fieldValue = null;
                        if (returnType.equals("java.lang.String")) {
                            fieldValue = (String) m.invoke(obj, null);
                        } else if (returnType.equals("java.util.Date")) {
                            Date adate = (Date) m.invoke(obj, null);
                            if (adate == null) {
                                fieldValue = "";
                            } else {
                                fieldValue = formateDate(adate);
                            }
                        } else if (returnType.equals("java.lang.Integer")) {
                            Integer avalue = (Integer) m.invoke(obj, null);
                            avalue = avalue == null ? 0 : avalue;
                            fieldValue = avalue.toString();
                        } else if (returnType.equals("java.lang.Double")) {
                            Double dvalue = (Double) m.invoke(obj, null);
                            dvalue = dvalue == null ? 0 : dvalue;
                            fieldValue = dvalue.toString();
                        }

                        fieldValue = fieldValue == null ? "" : fieldValue;
                        fieldValue = fieldValue.replaceAll("<", "&lt;");
                        fieldValue = fieldValue.replaceAll(">", "&gt;");
                        sb.append("<data name=\"" + fieldName
                                + "\" type=\"String(50)\">");
                        sb.append(fieldValue);
                        sb.append("</data>");
                    }
                } catch (SecurityException e) {
                    e.printStackTrace();
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                } catch (IllegalArgumentException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            sb.append("</row>");
        }
        sb.append("</detail>");
        return sb.toString();
    }


    public String getDataExchangeUrl() {
        return dataExchangeUrl;
    }

    public void setDataExchangeUrl(String dataExchangeUrl) {
        this.dataExchangeUrl = dataExchangeUrl;
    }
}
