package cn.gtmap.exchange.cxf.services.impl;

import cn.gtmap.exchange.cxf.dao.CheckTransformDao;
import cn.gtmap.exchange.cxf.services.CheckDictNodeService;
import cn.gtmap.exchange.cxf.services.CheckTransformService;
import cn.gtmap.exchange.cxf.services.DJYZDCBService;
import cn.gtmap.exchange.cxf.services.ExchangeDataService;
import cn.gtmap.exchange.cxf.vo.CheckField;
import cn.gtmap.exchange.cxf.vo.DJYZDCB;
import cn.gtmap.exchange.cxf.vo.ExchangeData;
import com.gtis.spring.Container;
import com.jsegov.tddj.dao.*;
import com.jsegov.tddj.services.interf.IYYDJService;
import com.jsegov.tddj.vo.*;
import org.apache.commons.lang.StringUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CheckTransformServiceImpl implements CheckTransformService{
	ProjectDAO projectDAO;
	SJDDAO sjdDAO;
	SQBDAO sqbDAO;
	SPBDAO spbDAO;
	CFDAO cfDAO;
	GytdsyzDAO gytdsyzDAO;
	JttdsyzDAO jttdsyzDAO;
	TxqlzmsDAO txqlzmsDAO;
	CheckTransformDao checkTransformDao;
	CheckDictNodeService checkDictNodeService;

	public String checkTransformField(String projecttype, String nodeid, String projectId){
		SJD sjd_sqlx = sjdDAO.getSJD(projectId);

		String sqlx="";
		String djlx="";
		if(sjd_sqlx!=null){
			sqlx = sjd_sqlx.getSqlx();
		}
		Project project=projectDAO.getProject(projectId);
		if(project!=null)
			djlx=project.getDjlx();
		List checkFieldList=new ArrayList();
		List<CheckField> checkFieldListBySqlx=getCheckField(sqlx,nodeid,null);
		List<CheckField> checkFieldListByDjlx=getCheckField(null,nodeid,djlx);
		if(checkFieldListBySqlx!=null){
			for(CheckField checkField:checkFieldListBySqlx)
				checkFieldList.add(checkField);
		}
		if(checkFieldListByDjlx!=null){
			for(CheckField checkField:checkFieldListByDjlx)
				checkFieldList.add(checkField);
		}
		
		String msg = "";
		if (checkFieldList.size()>0){
			for (Integer i=0; i<checkFieldList.size(); i++){
				CheckField checkField = (CheckField)checkFieldList.get(i);
				String tableName = checkField.getTablename();
				String fieldName = checkField.getFieldname();
				String checkType = checkField.getChecktype();
				msg = checkField.getMsg();
				if(StringUtils.isNotBlank(tableName) && StringUtils.isNotBlank(fieldName)&& !StringUtils.equals(checkType, "qssp")){
					if (tableName.equals("tbl_sjd")){
						SJD sjd = sjdDAO.getSJD(projectId);
						if (sjd != null){
							if (!getFieldValue(sjd,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("zd_sqdj")){
						SQB sqb = sqbDAO.getSQB(projectId);
						if (sqb != null){
							if (!getFieldValue(sqb,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("tbl_cf")){
						CF cf = cfDAO.getCF(projectId);
						if (cf != null){
							if (!getFieldValue(cf,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("zd_qssp")){
						SPB spb = spbDAO.getSPB(projectId);
						if (spb != null){
							if (!getFieldValue(spb,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("tbl_gytdsyz")){
						GYTDSYZ gytdsyz = gytdsyzDAO.getGYTDSYZ(projectId);
						if (gytdsyz != null){
							if (!getFieldValue(gytdsyz,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("tbl_txqlzms")){
						TXQLZMS txqlzms = txqlzmsDAO.getTXQLZMS(projectId);
						if (txqlzms != null){
							if (!getFieldValue(txqlzms,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("tbl_jttdsyz")){
						JTTDSYZ jttdsyz = jttdsyzDAO.getJTTDSYZ(projectId);
						if (jttdsyz != null){
							if (!getFieldValue(jttdsyz,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("tbl_yydj")){
						IYYDJService yydjService = (IYYDJService)Container.getBean("yydjService");
						YYDJ yydj = yydjService.getYYDJ(projectId);
						if (yydj != null){
							if (!getFieldValue(yydj,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("tbl_djyzdcb")){
						DJYZDCBService djyzdcbService = (DJYZDCBService)Container.getBean("djyzdcbService");
						DJYZDCB djyzdcb = djyzdcbService.getDJYZDCB(projectId);
						if (djyzdcb != null){
							if (!getFieldValue(djyzdcb,fieldName,checkType)){
								return msg;
							}
						}
					}else if (tableName.equals("exc_data")){
						ExchangeDataService exchangeDataService = (ExchangeDataService)Container.getBean("exchangeDataService");
						HashMap map=new HashMap();
						map.put("PROJECTID", projectId);
						ExchangeData exchangeData = exchangeDataService.getExchangeDataByProId(map);
						if (exchangeData != null){
							if (!getFieldValue(exchangeData,fieldName,checkType)){
								return msg;
							}
						}
					}
				}
				if(StringUtils.equals(checkType, "qssp")){
					try {
						String checkMsg=checkDictNodeService.checkDictData(checkType, null);
						if(StringUtils.isBlank(checkMsg))
							return msg;
					} catch (Exception e) {
//						return false;
					}
				}

				msg = "";
			}
		}
		return msg;
	}

	public boolean getFieldValue(Object obj, String fieldName,String checkType){
		String fieldValue = "";
		fieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1).toUpperCase());
		Method m = null;
		try {
			m = obj.getClass().getMethod("get" + fieldName, null);
		} catch (SecurityException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchMethodException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		String returnType = m.getReturnType().getName();
		if (returnType.equals("java.lang.String")) {
			try {
				fieldValue = (String) m.invoke(obj, null);
				if (fieldValue ==null){
					return false;
				}else{
					fieldValue = fieldValue.trim();
				}
				if (fieldValue.equals("")){
					return false;
				}
			} catch (IllegalArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if(StringUtils.isNotBlank(fieldValue) && StringUtils.isNotBlank(checkType)){
			try {
				String checkMsg=checkDictNodeService.checkDictData(checkType, fieldValue);
				if(StringUtils.isBlank(checkMsg))
					return false;
			} catch (Exception e) {
//				return false;
			}
		}
			
		return true;
	}
	public List getCheckField(String projecttype, String nodeid, String djlx) {
		return checkTransformDao.getCheckField(projecttype, nodeid,djlx);
	}
	
	public SJDDAO getSjdDAO() {
		return sjdDAO;
	}

	public void setSjdDAO(SJDDAO sjdDAO) {
		this.sjdDAO = sjdDAO;
	}

	public SQBDAO getSqbDAO() {
		return sqbDAO;
	}

	public void setSqbDAO(SQBDAO sqbDAO) {
		this.sqbDAO = sqbDAO;
	}

	public SPBDAO getSpbDAO() {
		return spbDAO;
	}

	public void setSpbDAO(SPBDAO spbDAO) {
		this.spbDAO = spbDAO;
	}

	public CFDAO getCfDAO() {
		return cfDAO;
	}

	public void setCfDAO(CFDAO cfDAO) {
		this.cfDAO = cfDAO;
	}

	public GytdsyzDAO getGytdsyzDAO() {
		return gytdsyzDAO;
	}

	public void setGytdsyzDAO(GytdsyzDAO gytdsyzDAO) {
		this.gytdsyzDAO = gytdsyzDAO;
	}

	public JttdsyzDAO getJttdsyzDAO() {
		return jttdsyzDAO;
	}

	public void setJttdsyzDAO(JttdsyzDAO jttdsyzDAO) {
		this.jttdsyzDAO = jttdsyzDAO;
	}

	public TxqlzmsDAO getTxqlzmsDAO() {
		return txqlzmsDAO;
	}

	public void setTxqlzmsDAO(TxqlzmsDAO txqlzmsDAO) {
		this.txqlzmsDAO = txqlzmsDAO;
	}

	public ProjectDAO getProjectDAO() {
		return projectDAO;
	}

	public void setProjectDAO(ProjectDAO projectDAO) {
		this.projectDAO = projectDAO;
	}

	public CheckTransformDao getCheckTransformDao() {
		return checkTransformDao;
	}

	public void setCheckTransformDao(CheckTransformDao checkTransformDao) {
		this.checkTransformDao = checkTransformDao;
	}

	public CheckDictNodeService getCheckDictNodeService() {
		return checkDictNodeService;
	}

	public void setCheckDictNodeService(CheckDictNodeService checkDictNodeService) {
		this.checkDictNodeService = checkDictNodeService;
	}
}
