/**    
 * 文件名：ExchangeDataAction.java    
 * 版本信息：    
 * 日期：Aug 16, 2013    
 * Copyright版权所有  Corporation 2013       
 */
package cn.gtmap.exchange.cxf.action;

import cn.gtmap.exchange.cxf.services.CertiNumServer;
import cn.gtmap.exchange.cxf.services.ExchangeDataService;
import cn.gtmap.exchange.cxf.util.CommonUtil;
import com.gtis.spring.Container;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/**    
 *     
 * 项目名称：tddj_jt    
 * 类名称：ExchangeDataAction    
 * 类描述：    
 * 创建人：zhangqiang    
 * 创建时间：Aug 16, 2013 11:18:38 AM    
 * 修改人：zhangqiang    
 * 修改时间：Aug 16, 2013 11:18:38 AM    
 * 修改备注：    
 * @version     
 *     
 */
public class ExchangeDataAction extends ActionSupport{
	private String proId;
	private CertiNumServer certiNumServerClient;
	private String djbh;
	private String isprintImage;
	
	public String execute() throws Exception {
		try {
			String djbhxml=certiNumServerClient.GetCertiNumber(proId);
//			String djbhxml="<Response><Status>0</Status><DJBH>330621201386277108</DJBH></Response>";
//			String djbhxml="<Response Type=\"失败返回数据\"><Status>9999</Status><Description>sdfsdf</Description></Response> ";
			String djbh="";
			String status="";
			if(StringUtils.isNotBlank(djbhxml) && StringUtils.indexOf(djbhxml, "Status")>-1){
				status=djbhxml.substring(djbhxml.indexOf("<Status>")+8,(djbhxml.indexOf("</Status>"))); 
				if(StringUtils.equals(status, "0"))
					status="0";
				else
					status="1";
			}
			if(StringUtils.equals(status, "0") && StringUtils.isNotBlank(djbhxml) && StringUtils.indexOf(djbhxml, "DJBH")>-1){
				djbh=djbhxml.substring(djbhxml.indexOf("<DJBH>")+6,djbhxml.indexOf("</DJBH>")); 
			}else if(StringUtils.equals(status, "1") && StringUtils.isNotBlank(djbhxml) && StringUtils.indexOf(djbhxml, "Description")>-1){
				djbh=djbhxml.substring(djbhxml.indexOf("<Description>")+13,djbhxml.indexOf("</Description>"));
			}
				
			HashMap map=new HashMap();
			map.put("djbh", djbh) ;
			map.put("status", status) ;
				
            ServletActionContext.getResponse().setCharacterEncoding("utf-8");
            ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(map));
		} catch (Exception e) {
			System.err.println(e);
		}
		
		return NONE;
	}
	/**
	 * 
	* @Title: isprintBydjbh 
	* @Description: TODO(验证证书打印之前是否获取省级编号) 
	* @param @return    设定文件 
	* @return String    返回类型 
	* @throws
	 */
	public String isprintBydjbh(){
		ExchangeDataService exchangeDataService=(ExchangeDataService)Container.getBean("exchangeDataService");
		HashMap map = new HashMap();			
		HashMap resultmap=new HashMap();
		
		String flag = "true";
		if(StringUtils.isNotBlank(proId)){
			map.put("PROJECTID", proId);
			List<HashMap> excdateList= exchangeDataService.getExchange(map);
			if(excdateList!=null && excdateList.size()>0){
				resultmap=excdateList.get(0);
				if(resultmap.get("DJBH")==null){
					flag ="false";
				}
			}else {
				flag="false";
			}
		}
		HashMap tempmap=new HashMap();
		tempmap.put("result",flag);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        try {
			ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(tempmap));
		} catch (IOException e) {
			e.printStackTrace();
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return NONE;
	}
	
	public String getdjbhById(){
        ExchangeDataService exchangeDataService=(ExchangeDataService)Container.getBean("exchangeDataService");
		HashMap map = new HashMap();			
		HashMap resultmap=new HashMap();
		String djbhString="";
		if(StringUtils.isNotBlank(proId)){
			map.put("PROJECTID", proId);
			List<HashMap> excdateList= exchangeDataService.getExchange(map);
			if(excdateList!=null && excdateList.size()>0){
				resultmap=excdateList.get(0);
				if(resultmap.get("DJBH")!=null){
					djbhString =resultmap.get("DJBH").toString();
				}else{
					djbhString="";
				}
			}
		}
		HashMap tempmap=new HashMap();
		tempmap.put("result",djbhString);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        try {
			ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(tempmap));
		} catch (IOException e) {
			e.printStackTrace();
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return NONE;
	}

    public String getDataExchangeURL() throws IOException, JSONException{
        HashMap map=new HashMap();
        map.put("dataExchangeUrl", CommonUtil.dataExchangeUrl) ;
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
        ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(map));
        return NONE;
    }
//	/**
//	 * 
//	* @Title: getProId 
//	* @Description: TODO 获取二维码 
//	* @param @return    设定文件 
//	* @return String    返回类型 
//	* @throws
//	 */
//	
//	public String getEwmPic(){
//		if(StringUtils.isNotBlank(djbh)){
//				TwoDimensionCode tdc = new TwoDimensionCode();
//				String content = "省级编号:"+djbh;
//				ByteArrayOutputStream byteArrayOutputStream =new ByteArrayOutputStream();
//				tdc.encoderQRCode(content, byteArrayOutputStream);
//				byte[] byte1 =byteArrayOutputStream.toByteArray();
//				EWMVo eVo = new EWMVo();
//				eVo.setPic_ewm(byte1);
//				eVo.setProjectid(proId);
//				getEwmDao.insertDJF(eVo);
//				
//				String imgPath = "C:/test.jpg"; 
//				tdc.encoderQRCode(content, imgPath, "jpg");
//		        System.out.println("========成功生成二维码！");  
//		}
//		return NONE;
//	}
	
//	public String getPrintEwm() throws Exception {
//		HashMap map = new HashMap();
//	    HttpServletResponse response=ServletActionContext.getResponse();
//		if(StringUtils.isNotBlank(proId)){
//			map.put("projectId", proId);
//			EWMVo eVo = getEwmDao.getEwm(map);
//			byte[] imageByte = eVo.getPic_ewm();
//            BufferedImage image=ImageIO.read(new ByteArrayInputStream(imageByte));
//            ImageIO.write(image, "jpg", ServletActionContext.getResponse().getOutputStream());
//		}
//		return NONE;
//	}
	
//	public String getdefaultRq() {
//		PlatUtil platUtil = new PlatUtil();
//		PfWorkFlowInstanceVo wFlowInstanceVo=platUtil.getWfinstanceByProjectId(proId);
//        Map<String, String> defaultValueMap = new HashMap<String, String>();
//        Date creatTime=new Date();
//        Date finishTime=new Date();
//		if(wFlowInstanceVo!=null){
//			if(wFlowInstanceVo.getCreateTime()!=null){
//				creatTime = wFlowInstanceVo.getCreateTime();
//			}
//			if(wFlowInstanceVo.getFinishTime()!=null){
//				finishTime = wFlowInstanceVo.getFinishTime();
//			}
//			
//		}
//		String creatTimeStr =CommonUtil.formateDate(creatTime);
//		String finishTimeStr =CommonUtil.formateDate(finishTime);
//
//		defaultValueMap.put("creatTime", creatTimeStr);
//		defaultValueMap.put("finishTime", finishTimeStr);
//
//        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
//        try {
//			ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(defaultValueMap));
//		} catch (IOException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (JSONException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	
//		return NONE;
//	}

	public String getProId() {
		return proId;
	}

	public void setProId(String proId) {
		this.proId = proId;
	}


	public CertiNumServer getCertiNumServerClient() {
		return certiNumServerClient;
	}

	public void setCertiNumServerClient(CertiNumServer certiNumServerClient) {
		this.certiNumServerClient = certiNumServerClient;
	}
	public String getDjbh() {
		return djbh;
	}
	public void setDjbh(String djbh) {
		this.djbh = djbh;
	}
	public String getIsprintImage() {
		return isprintImage;
	}
	public void setIsprintImage(String isprintImage) {
		this.isprintImage = isprintImage;
	}
	
}
