/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class CharacterEncodingFilter
implements Filter {
    protected String encoding;
    protected boolean forceEncoding = true;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.encoding = filterConfig.getInitParameter("encoding");
        String value = filterConfig.getInitParameter("forceEncoding");
        this.forceEncoding = value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.forceEncoding || request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(this.encoding);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.encoding = null;
    }
}

