/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.services.impl;

import com.gtis.sams.services.GeoService;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.text.NumberFormat;
import org.springframework.stereotype.Service;

@Service
public class GeoServiceImpl
implements GeoService {
    private WKTReader wktReader;

    public Geometry parseWtkCoords(String coords) throws ParseException {
        return this.getWktReader().read(coords);
    }

    public String transform2GtCoordsFromat(Geometry geometry) {
        String resultStr = "";
        if (geometry instanceof Polygon) {
            resultStr = this.polygon2String((Polygon)geometry);
            System.out.println(resultStr);
        } else if (geometry instanceof MultiPolygon) {
            int polygonNum = geometry.getNumGeometries();
            for (int i = 0; i < polygonNum; ++i) {
                Polygon p = (Polygon)geometry.getGeometryN(i);
                resultStr = resultStr + this.polygon2String(p);
            }
            System.out.println(resultStr);
        } else if (geometry instanceof GeometryCollection) {
            int geometryNum = geometry.getNumGeometries();
            for (int i = 0; i < geometryNum; ++i) {
                String geomType = geometry.getGeometryN(i).getGeometryType();
                if (geomType.equals("Point")) {
                    Coordinate[] points = geometry.getGeometryN(i).getCoordinates();
                    for (int j = 0; j < points.length; ++j) {
                        resultStr = resultStr + String.valueOf(j + 1) + "," + String.valueOf(points[j].x) + "," + String.valueOf(points[j].y) + "\r\n";
                    }
                    System.out.println(resultStr);
                    continue;
                }
                if (geomType.equals("LineString")) {
                    Coordinate[] coordinates = geometry.getGeometryN(i).getCoordinates();
                    for (int m = 0; m < coordinates.length; ++m) {
                        resultStr = resultStr + String.valueOf(m + 1) + "," + String.valueOf(coordinates[m].x) + "," + String.valueOf(coordinates[m].y) + "\r\n";
                    }
                    System.out.println(resultStr);
                    continue;
                }
                if (!geomType.equals("Polygon")) continue;
                resultStr = resultStr + this.polygon2String((Polygon)geometry.getGeometryN(i));
            }
        }
        return resultStr;
    }

    private String polygon2String(Polygon polygon) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        String resultStr = "";
        int ringNum = polygon.getNumInteriorRing() + 1;
        Coordinate[] exteriorRingString = polygon.getExteriorRing().getCoordinates();
        for (int i = 0; i < exteriorRingString.length - 1; ++i) {
            resultStr = resultStr + numberFormat.format(exteriorRingString[i].x) + "," + numberFormat.format(exteriorRingString[i].y);
            resultStr = i + 2 == exteriorRingString.length ? resultStr + ";" : resultStr + ",";
        }
        for (int m = 0; m < ringNum - 1; ++m) {
            Coordinate[] temp = polygon.getInteriorRingN(m).getCoordinates();
            resultStr = resultStr + this.coordinates2String(temp);
        }
        return resultStr;
    }

    private String coordinates2String(Coordinate[] coord) {
        String resultStr = "";
        for (int i = 0; i < coord.length - 1; ++i) {
            resultStr = resultStr + String.valueOf(coord[i].x) + "," + String.valueOf(coord[i].y);
            resultStr = i + 2 == coord.length ? resultStr + ";" : resultStr + ",";
        }
        return resultStr;
    }

    public WKTReader getWktReader() {
        if (this.wktReader == null) {
            this.wktReader = new WKTReader();
        }
        return this.wktReader;
    }
}

