/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.core.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.Page;
import com.gtis.plat.vo.UserInfo;
import com.gtis.sams.core.entity.AnalysisField;
import com.gtis.sams.core.entity.ShowField;
import com.gtis.sams.core.service.BaseService;
import com.gtis.sams.core.service.ModelService;
import com.gtis.sams.core.service.TemplateService;
import com.gtis.sams.core.web.BaseAction;
import com.gtis.sams.services.FCBService;
import com.gtis.sams.services.PermissionService;
import com.gtis.sams.services.ServicesManager;
import com.gtis.sams.utils.ClassUtils;
import com.gtis.sams.utils.GetJxlCellStyle;
import com.gtis.sams.vo.FCBVo;
import com.gtis.sams.vo.FCPVo;
import com.gtis.sams.vo.Permission;
import com.gtis.sams.vo.SLAVo;
import com.gtis.sams.vo.SLSVo;
import com.gtis.web.SessionUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseEntityAction<T>
extends BaseAction {
    protected static final String DETAIL = "detail";
    protected static final String BASIC_INFO = "basicInfo";
    @Autowired
    private ServicesManager servicesManager;
    protected BaseService<T> baseService;
    private UserInfo userInfo;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ModelService modelService;
    @Autowired
    private FCBService fcbService;
    private String type;
    private String id;
    private String[] ids;
    private List<T> entities;
    private Map condition;
    private Map<String, String> fields;
    protected T entity;
    protected int start;
    protected int limit = 20;
    protected String message;
    protected String starttime;
    protected String endtime;
    protected String unit;

    public Page<T> list() throws IOException {
        try {
            this.sendJson((Object)this.baseService.getPages(this.start, this.limit, this.condition));
        }
        catch (Exception e) {
            this.sendJson((Object)new Page());
        }
        return null;
    }

    public List<T> getEntities() {
        if (this.entities == null) {
            this.baseService.getEntities(this.start, this.limit);
        }
        return this.entities;
    }

    public T getEntity() {
        if (this.entity == null) {
            this.entity = this.baseService.find(this.id);
        }
        return (T)this.baseService.find(this.id);
    }

    public String detail() {
        return DETAIL;
    }

    public String basicInfo() {
        return BASIC_INFO;
    }

    public String save() {
        try {
            this.baseService.update(this.entity);
            this.logger.info(this.entity.toString());
            this.message = "\u4fdd\u5b58\u6210\u529f!";
        }
        catch (Exception e) {
            this.logger.error("\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.message = "\u4fdd\u5b58\u5931\u8d25!";
        }
        return BASIC_INFO;
    }

    public String delete() {
        try {
            if (this.getEntity() != null) {
                this.baseService.delete(this.getEntity());
                this.logger.info(this.entity.toString());
                this.message = "\u5220\u9664\u6210\u529f!";
            } else {
                this.message = "\u5f53\u524d\u9879\u76ee\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u52ff\u91cd\u590d\u5220\u9664\uff01";
            }
        }
        catch (Exception e) {
            this.logger.error("\u9879\u76ee\u5220\u9664\u5931\u8d25\u3010{}\u3011", (Object)e.getLocalizedMessage());
            this.message = "\u5220\u9664\u5931\u8d25!";
        }
        return BASIC_INFO;
    }

    public Properties getSysEnv() {
        return System.getProperties();
    }

    public UserInfo getUser() {
        return SessionUtil.getCurrentUser();
    }

    public List<String> getPerms() {
        ArrayList<String> perms = new ArrayList<String>();
        String roleIds = this.getUser().getRoleIds();
        if (StringUtils.isNotBlank((String)roleIds)) {
            for (String roleId : roleIds.split(",")) {
                roleId = roleId.substring(1, roleId.length() - 1);
                List perm = this.permissionService.getPermissions(this.getType().equals("fcb") ? "fcp" : this.type, roleId);
                ArrayList<String> tmpPerm = new ArrayList<String>();
                for (Permission permission : perm) {
                    tmpPerm.add(permission.getOperation());
                }
                ArrayList tmp = new ArrayList(tmpPerm);
                tmp.retainAll(perms);
                tmpPerm.removeAll(tmp);
                perms.addAll(tmpPerm);
            }
        }
        return perms;
    }

    public Map<String, String> getFields() throws IOException {
        if (this.fields == null) {
            this.fields = this.modelService.getFields(this.type);
        }
        return this.fields;
    }

    public String fields() throws IOException {
        try {
            this.sendJson((Object)this.modelService.getModel(this.type).getFields());
        }
        catch (Exception e) {
            this.sendError(e.getLocalizedMessage());
        }
        return null;
    }

    public void setCondition(String value) {
        this.condition = new HashMap();
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        ArrayList<String> conditions = new ArrayList<String>();
        JSONArray conJson = JSON.parseArray((String)value);
        for (Object obj : conJson) {
            conditions.add(this.seriCondition((JSONObject)obj));
        }
        this.condition.put("condition", conditions);
    }

    public Map getCondition() {
        return this.condition;
    }

    private String seriCondition(JSONObject item) {
        String condition = item.getString("field").concat(" ").concat(item.getString("condition").concat(" "));
        condition = item.getString("condition").equalsIgnoreCase("like") ? condition.concat("'%").concat(item.getString("value").concat("%'")) : condition.concat(item.getString("value"));
        return condition;
    }

    public void setType(String type) {
        this.type = type;
        if (this.baseService == null) {
            this.baseService = this.servicesManager.getEntityService(type);
        }
    }

    public List<T> getStatisticData() {
        this.condition = new HashMap();
        ArrayList<String> conditions = new ArrayList<String>();
        if (this.type.equals("fcp")) {
            if (!this.starttime.equals("null") && !this.endtime.equals("null")) {
                conditions.add("t.pc_year between '" + this.starttime + "' and '" + this.endtime + "'");
            }
            if (!this.unit.equals("null") && this.unit != null) {
                conditions.add("t.pc_unit = '" + this.unit + "'");
            }
            if (this.starttime.equals("null") && this.endtime.equals("null") && this.unit.equals("null")) {
                return null;
            }
            this.condition.put("condition", conditions);
            return this.fcbService.getEntities(this.condition);
        }
        conditions.add("t1.pzrq between to_date('" + this.getStarttime() + "', 'YYYY-MM-DD HH24:MI:SS') and to_date('" + this.getEndtime() + "', 'YYYY-MM-DD HH24:MI:SS')");
        this.condition.put("condition", conditions);
        return this.baseService.getEntities(this.condition);
    }

    public List<List<FCPVo>> getStatisticFcp() {
        if (this.type.equals("fcp")) {
            List fcbVoList = this.getStatisticData();
            ArrayList<List<FCPVo>> resultList = new ArrayList<List<FCPVo>>();
            this.condition = new HashMap();
            for (int i = 0; i < fcbVoList.size(); ++i) {
                FCBVo fcbVo = (FCBVo)fcbVoList.get(i);
                ArrayList<String> conditions = new ArrayList<String>();
                conditions.add("t1.fcb_id = '" + fcbVo.getId() + "'");
                this.condition.put("condition", conditions);
                resultList.add(this.baseService.getEntities(this.condition));
            }
            return resultList;
        }
        return null;
    }

    public String Standardize(String coords) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        String[] tempArray = coords.split(";");
        String resuluStr = "";
        for (String tempStr : tempArray) {
            String[] coordArray = tempStr.split(",");
            String tempStr1 = "";
            for (int i = 0; i < coordArray.length; ++i) {
                if (i % 2 == 0) {
                    coordArray[i] = numberFormat.format(Double.parseDouble(coordArray[i]) - 500000.0);
                }
                tempStr1 = i + 1 == coordArray.length ? tempStr1 + coordArray[i] : tempStr1 + coordArray[i] + ",";
            }
            resuluStr = resuluStr + tempStr1;
            resuluStr = resuluStr + ";";
        }
        return resuluStr;
    }

    public String exportExcel() throws Exception {
        List proList = this.getStatisticData();
        List fields = this.getAnalysisFields();
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String fileName = "\u9879\u76ee\u7edf\u8ba1\u5206\u6790\u8868.xls";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet("\u9879\u76ee\u7edf\u8ba1\u5206\u6790", 0);
            WritableCellFormat scf = GetJxlCellStyle.getStringFormatCellStyle();
            WritableCellFormat ncf = GetJxlCellStyle.getNumberFormatCellStyle();
            WritableCellFormat dcf = GetJxlCellStyle.getDateFormatCellStyle();
            WritableCellFormat hcf = GetJxlCellStyle.getHeaderCellStyle();
            if (this.type.equals("fcp")) {
                ws.addCell((WritableCell)new Label(0, 0, "\u6279\u6b21\u4fe1\u606f", (CellFormat)hcf));
                ws.addCell((WritableCell)new Label(2, 0, "\u9879\u76ee\u4fe1\u606f", (CellFormat)hcf));
                ws.addCell((WritableCell)new Label(0, 1, "\u6279\u6b21\u5e8f\u53f7", (CellFormat)hcf));
                ws.addCell((WritableCell)new Label(1, 1, "\u6279\u6b21\u4fe1\u606f", (CellFormat)hcf));
                ws.addCell((WritableCell)new Label(2, 1, "\u9879\u76ee\u5e8f\u53f7", (CellFormat)hcf));
                for (int m = 0; m < fields.size(); ++m) {
                    ws.addCell((WritableCell)new Label(m + 3, 1, ((AnalysisField)fields.get(m)).getLabel(), (CellFormat)hcf));
                }
                ws.mergeCells(0, 0, 1, 0);
                ws.mergeCells(2, 0, 11, 0);
                FCBVo fcbVo = new FCBVo();
                FCPVo fcpVo = new FCPVo();
                int fcbRowStart = 2;
                int fcpRowStart = 2;
                List fcpList = this.getStatisticFcp();
                for (int i = 0; i < proList.size(); ++i) {
                    fcbVo = (FCBVo)proList.get(i);
                    ws.addCell((WritableCell)new Number(0, fcbRowStart, (double)(i + 1), (CellFormat)ncf));
                    ws.addCell((WritableCell)new Label(1, fcbRowStart, fcbVo.getProName(), (CellFormat)scf));
                    List fcpVos = (List)fcpList.get(i);
                    if (fcpVos.size() == 0) {
                        fcpRowStart = ++fcbRowStart;
                        continue;
                    }
                    ws.mergeCells(0, fcbRowStart, 0, fcbRowStart + fcpVos.size() - 1);
                    ws.mergeCells(1, fcbRowStart, 1, fcbRowStart + fcpVos.size() - 1);
                    fcbRowStart += fcpVos.size();
                    for (int j = 0; j < fcpVos.size(); ++j) {
                        fcpVo = (FCPVo)fcpVos.get(j);
                        ws.addCell((WritableCell)new Number(2, fcpRowStart, (double)(j + 1), (CellFormat)ncf));
                        for (int m = 0; m < fields.size(); ++m) {
                            Object object = ClassUtils.getFieldValue((Object)fcpVo, (String)((AnalysisField)fields.get(m)).getField());
                            if (object instanceof Double) {
                                ws.addCell((WritableCell)new Number(m + 3, fcpRowStart, ((Double)object).doubleValue(), (CellFormat)ncf));
                                continue;
                            }
                            if (object instanceof Date) {
                                ws.addCell((WritableCell)new DateTime(m + 3, fcpRowStart, (Date)object, (CellFormat)dcf));
                                continue;
                            }
                            ws.addCell((WritableCell)new Label(m + 3, fcpRowStart, (String)object, (CellFormat)scf));
                        }
                        ++fcpRowStart;
                    }
                }
            } else if (this.type.equals("sla")) {
                ws.addCell((WritableCell)new Label(0, 0, "\u9879\u76ee\u5e8f\u53f7", (CellFormat)hcf));
                for (int m = 0; m < fields.size(); ++m) {
                    ws.addCell((WritableCell)new Label(m + 1, 0, ((AnalysisField)fields.get(m)).getLabel(), (CellFormat)hcf));
                }
                SLAVo slaVo = new SLAVo();
                for (int i = 0; i < proList.size(); ++i) {
                    slaVo = (SLAVo)proList.get(i);
                    ws.addCell((WritableCell)new Number(0, i + 1, (double)(i + 1), (CellFormat)ncf));
                    for (int j = 0; j < fields.size(); ++j) {
                        Object object = ClassUtils.getFieldValue((Object)slaVo, (String)((AnalysisField)fields.get(j)).getField());
                        if (object instanceof Double) {
                            ws.addCell((WritableCell)new Number(j + 1, i + 1, ((Double)object).doubleValue(), (CellFormat)ncf));
                            continue;
                        }
                        if (object instanceof Date) {
                            ws.addCell((WritableCell)new DateTime(j + 1, i + 1, (Date)object, (CellFormat)dcf));
                            continue;
                        }
                        ws.addCell((WritableCell)new Label(j + 1, i + 1, (String)object, (CellFormat)scf));
                    }
                }
            } else if (this.type.equals("sls")) {
                ws.addCell((WritableCell)new Label(0, 0, "\u9879\u76ee\u5e8f\u53f7", (CellFormat)hcf));
                for (int m = 0; m < fields.size(); ++m) {
                    ws.addCell((WritableCell)new Label(m + 1, 0, ((AnalysisField)fields.get(m)).getLabel(), (CellFormat)hcf));
                }
                SLSVo slsVo = new SLSVo();
                for (int i = 0; i < proList.size(); ++i) {
                    slsVo = (SLSVo)proList.get(i);
                    ws.addCell((WritableCell)new Number(0, i + 1, (double)(i + 1), (CellFormat)ncf));
                    for (int j = 0; j < fields.size(); ++j) {
                        Object object = ClassUtils.getFieldValue((Object)slsVo, (String)((AnalysisField)fields.get(j)).getField());
                        if (object instanceof Double) {
                            ws.addCell((WritableCell)new Number(j + 1, i + 1, ((Double)object).doubleValue(), (CellFormat)ncf));
                            continue;
                        }
                        if (object instanceof Date) {
                            ws.addCell((WritableCell)new DateTime(j + 1, i + 1, (Date)object, (CellFormat)dcf));
                            continue;
                        }
                        ws.addCell((WritableCell)new Label(j + 1, i + 1, (String)object, (CellFormat)scf));
                    }
                }
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception ex) {
            this.logger.error("\u5bfc\u51faexcel\u8868\u51fa\u9519\uff01", (Object)ex.getLocalizedMessage());
            System.out.println(ex.toString());
        }
        return null;
    }

    public List<AnalysisField> getAnalysisFields() {
        return JSON.parseArray((String)this.templateService.getTemplate(this.getTplName()), AnalysisField.class);
    }

    public List<ShowField> getShowFields() {
        String tplName = "";
        tplName = this.type.equals("fcb") ? "showFields/fcb.json" : (this.type.equals("fcp") ? "showFields/fcp.json" : (this.type.equals("sla") ? "showFields/sla.json" : (this.type.equals("sls") ? "showFields/sls.json" : "")));
        return JSON.parseArray((String)this.templateService.getTemplate(tplName), ShowField.class);
    }

    private String getTplName() {
        if (this.type.equals("fcp") || this.type.equals("fcb")) {
            return "statisticFields/statics_fcp.json";
        }
        if (this.type.equals("sla")) {
            return "statisticFields/statics_sla.json";
        }
        if (this.type.equals("sls")) {
            return "statisticFields/statics_sls.json";
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setIds(String[] ids) {
        this.ids = ids;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getType() {
        return this.type;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getEndtime() {
        return this.endtime;
    }

    public void setEndtime(String endtime) {
        this.endtime = endtime;
    }

    public String getStarttime() {
        return this.starttime;
    }

    public void setStarttime(String starttime) {
        this.starttime = starttime;
    }

    public String getUnit() {
        if (this.unit != null) {
            try {
                return URLDecoder.decode(this.unit, "UTF-8");
            }
            catch (Exception ex) {
                this.logger.error(ex.toString());
                return null;
            }
        }
        return null;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
}

