/**
 * Created by IntelliJ IDEA.
 * User: xunianfeng
 * Date: 12-8-1
 * Time: 上午10:25
 *
 */


$(function () {

    var $el = $(),
        $mainContent = $("#main-content");
    $mainContent.wrapInner("<div id='fade-wrapper' />");

    var $fadeWrapper = $("#fade-wrapper"),
        $allNav = $("#main-nav a"),
        $allListItems = $("#main-nav li"),
        url = '',
        liClass = '',
        hash = window.location.hash;

    $("body").attr("id", "");


    $allNav.click(function (e) {

        $el = $(this);

        if (!$el.parent().hasClass("active")) {
            $(window).scrollTop(0);
            url = $el.attr("href");
            $fadeWrapper.remove();
            $mainContent.append($fadeWrapper);
            $fadeWrapper.animate({ opacity:0.1 }, 'slow');
            $fadeWrapper.load(url, function () {
                $fadeWrapper.animate({ opacity:1 }, 'slow');
            });
            $allListItems.removeClass("active");
            $el.parent().addClass("active");
        }
        e.preventDefault();
    });

});

Ext.define('baseBtModel', {
    extend:'Ext.data.Model',
    fields:[
        {name:'id', type:'string'},
        {name:'proName', type:'string'},
        {name:'proArea', type:'float'},
        {name:'approvalNo', type:'string'},
        {name:'status',type:'int'},
        {name:'pcUnit',type:'string'},
        {name:'pcYear',type:'string'},
        {name:'approvalUnit',type:'string'}

    ]
});

/**
 * 项目基本模型
 */
Ext.define('baseProModel', {
    extend:'Ext.data.Model',
    fields:[
        {name:'id', type:'string'},
        {name:'fldm', type:'string'},
        {name:'proNo', type:'string'},
        {name:'proName', type:'string'},
        {name:'cbr', type:'string'},
        {name:'approvalNo', type:'string'},
        {name:'approvalUnit', type:'string'},
        {name:'pzrq', type:'auto'},
        {name:'approvalArea', type:'float'},
        {name:'landUseUnit', type:'string'},
        {name:'address', type:'string'},
        {name:'bz', type:'string'},
        {name:'chy', type:'string'},
        {name:'chrq', type:'date'},
        {name:'zjy', type:'string'},
        {name:'zjrq', type:'date'},
        {name:'xxlry', type:'string'},
        {name:'inputTime', type:'auto'},
        {name:'xzqdm', type:'string'},
        {name:'ssqy', type:'string'},
        {name:'bsm', type:'string'},
        {name:'ywid', type:'string'},
        {name:'xmbs', type:'string'},
        {name:'status', type:'int'}

    ]
});

/**
 *  供地项目数据模型
 */
Ext.define('slsModel', {
    extend:'baseProModel',
    fields:[
        {name:'slsId', type:'string'},
        {name:'lxfs', type:'string'},
        {name:'gdfs', type:'string'},
        {name:'gdzt', type:'string'},
        {name:'crhtbh', type:'string'},
        {name:'hbjdsbh', type:'string'},
        {name:'scmj', type:'float'},
        {name:'gdjydmj', type:'float'},
        {name:'gddlmj', type:'float'},
        {name:'gdldmj', type:'float'},
        {name:'gdsymj', type:'float'},
        {name:'gdqtmj', type:'float'},
        {name:'pzyt1', type:'string'},
        {name:'yt1mj', type:'float'},
        {name:'pzyt2', type:'string'},
        {name:'yt2mj', type:'float'},
        {name:'pzyt3', type:'string'},
        {name:'yt3mj', type:'float'},
        {name:'pzyt4', type:'string'},
        {name:'yt4mj', type:'float'},
        {name:'gkcrbh', type:'string'},
        {name:'gkcrsj', type:'auto'},
        {name:'tddj', type:'string'},
        {name:'badj', type:'string'},
        {name:'ghrjv', type:'string'}
    ]

});


/**
 * 征地项目数据模型
 */
Ext.define('slaModel', {
    extend:'baseProModel',
    fields:[
        {name:'slaId', type:'string'},
        {name:'zdwbwh', type:'string'},
        {name:'zdwbsj', type:'auto'},
        {name:'zdwbzmj', type:'float'},
        {name:'dkpzmj', type:'float'},
        {name:'dkscmj', type:'float'},
        {name:'zdbczt', type:'string'},
        {name:'zdbcbz', type:'string'},
        {name:'zdbczj', type:'string'},
        {name:'zdbcsj', type:'auto'},
        {name:'zdttwh', type:'string'},
        {name:'zdhhwh', type:'string'}
    ]
});

/**
 *  农转项目数据模型
 */
Ext.define('fcpModel', {
    extend:'baseProModel',
    fields:[
        {name:'fcpId', type:'string'},
        {name:'fcbId', type:'string'},
        {name:'xmsbzmj', type:'float'},
        {name:'pcsbbh', type:'string'},
        {name:'pcsbzmj', type:'float'},
        {name:'pcsbsj', type:'date'},
        {name:'sbmj', type:'float'},
        {name:'scmj', type:'float'},
        {name:'pcUnit', type:'string'},
        {name:'pcYear', type:'string'},
        {name:'pc', type:'int'}

    ]

});

/**
 * 条件检索模型
 */
Ext.define('fieldModel', {
    extend:'Ext.data.Model',
    fields:['name', 'field', 'title', 'condition', 'value']
});

/**
 *  页面过滤查询并高亮结果
 */
function onSearch(gridPanel) {
    var count = 0;
    gridPanel.view.refresh();

    gridPanel.searchValue = gridPanel.down('textfield[name=searchField]').getValue();  //得到要搜索的值value
    gridPanel.indexes = [];
    gridPanel.currentIndex = null;
    gridPanel.searchRegExp = null;
    gridPanel.caseSensitive = true;
    gridPanel.regExpMode = false;
    gridPanel.matchCls = 'x-livesearch-match';
    gridPanel.tagsRe = /<[^>]*>/gm;
    gridPanel.tagsProtect='\x0f';
    if (gridPanel.searchValue !== null) {

        gridPanel.searchRegExp = new RegExp(gridPanel.searchValue, 'g' + (gridPanel.caseSensitive ? '' : 'i'));

        gridPanel.store.each(function (record, idx) {
            var td = Ext.fly(gridPanel.view.getNode(idx)).down('td'),
                cell, matches, cellHTML;
            while (td) {
                cell = td.down('.x-grid-cell-inner');
                matches = cell.dom.innerHTML.match(gridPanel.tagsRe);
                cellHTML = cell.dom.innerHTML.replace(gridPanel.tagsRe, gridPanel.tagsProtect);
                cellHTML = cellHTML.replace(/&nbsp;/ig, "");    //替换&nbsp；
                cellHTML = cellHTML.replace(gridPanel.searchRegExp, function (m) {
                    count += 1;
                    if (Ext.Array.indexOf(gridPanel.indexes, idx) === -1) {
                        gridPanel.indexes.push(idx);
                    }
                    if (gridPanel.currentIndex === null) {
                        gridPanel.currentIndex = idx;
                    }
                    return '<span class="' + gridPanel.matchCls + '">' + m + '</span>';
                });
                Ext.each(matches, function (match) {
                    cellHTML = cellHTML.replace(gridPanel.tagsProtect, match);
                });
                cell.dom.innerHTML = cellHTML;
                td = td.next();
            }
        }, gridPanel);


        gridPanel.down('textfield[name=searchField]').focus();
    }
}

