<@com.proList import="ext,jquery,lanxy">
<div id="top">
</div>
    <@com.mainbox></@com.mainbox>
<script type="text/javascript">
var type = '${type}', store, gridPanel;

Ext.onReady(function () {
    Ext.QuickTips.init();
    store = new Ext.data.Store({
        pageSize:20,
        model:<@com.dataModel type='${type}'></@com.dataModel>,
        proxy:{
            type:'ajax',
            url:'pro!list.action?type=${type}&id=${id!}',
            reader:{
                type:'json',
                root:'items',
                totalProperty:'totalCount'
            }
        },
        autoLoad:true
    });

    gridPanel = new Ext.grid.Panel({
        title:'项目列表',
        store:store,
        height:400,
        selModel:new Ext.selection.CheckboxModel({mode:'SINGLE'}),
        stateful:true,
        columns:[
            {text:'项目编号', dataIndex:'proNo'},
            {text:'项目名称', dataIndex:'proName'},
            {text:'批复文号', dataIndex:'approvalNo'},
            {text:'批准状态',dataIndex:'status',renderer:statusRender},
            {text:'批准单位', dataIndex:'approvalUnit'},
            {text:'批准日期', dataIndex:'pzrq', renderer:dateFormat},
            {text:'批准总面积', dataIndex:'approvalArea'},
            {text:'土地坐落', dataIndex:'address'},
            {text:'承办人', dataIndex:'cbr'},
            {text:'录入时间', dataIndex:'inputTime', renderer:dateFormat},
            <@com.showFields type='${type}'></@com.showFields> ],
        renderTo:'main_box_content',
        viewConfig:{
            stripeRows:true
        },
        dockedItems:[
            {
                xtype:'toolbar',
                items:[
                    {
                        text:"项目详细信息",
                        iconCls:"ex_detail",
                        handler:function () {
                            openProDetailInfo();
                        }
                    },
                    {
                        text:"项目统计",
                        iconCls:"ex_static",
                        id:'statistic',
                        handler:function () {
                            openStatistics();
                        }
                    },
                    '-',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        width:150,
                        listeners:{
                            change:function(){
                                onSearch(gridPanel);
                            }
                        }

                    },
                    {
                        xtype:'button',
                        iconCls:'ex_search',
                        text:'条件检索',
                        handler:function (e) {
                            onAddCondition(e);
                        }
                    }
                ]
            },
            {
                xtype:'pagingtoolbar',
                pageSize:20,
                store:store,
                dock:'bottom',
                displayInfo:true,
                displayMsg:'{0}-{1}共{2}条',
                emptyMsg:"尚未检测到数据"
            }
        ],
        listeners:{
            itemdblclick:function (grid, item, row) {
                debugger;
                openProDetailInfo();
            }
        }
    });
});

/**
 * 打开项目详细信息
 * @param id
 */
function openProDetailInfo() {
    var selRow = gridPanel.getSelectionModel().getSelection();
    if(selRow.length > 1){
        Ext.Msg.show({title:"\u7cfb\u7edf\u63d0\u793a", msg:"只能选择一条记录!", buttons:Ext.MessageBox.OK, icon:Ext.MessageBox.INFO});
        return;
    }
    var item = gridPanel.getSelectionModel().getSelection()[0];
    if (item) {
        var id = item.get('${type}Id');
        window.open('pro!detail.action?type=' + type + '&id=' + id, "_blank");

    } else {
        Ext.MessageBox.show({
            title:'提示',
            msg:'请先选择某一项',
            buttons:Ext.MessageBox.OK
        });
    }
}
/**
 *
 * @type {*}
 */
var fieldsStore = Ext.create('gtis.store.FieldStore', {
    url:'pro!fields.action?type=${type}'
});
var selectedStore = Ext.create('gtis.store.SelectedFStore', {});

var leftGrid = Ext.create('gtis.panel.LeftDragPanel', {store:fieldsStore});

var rightDrop = Ext.create('gtis.panel.RightDropPanel', {store:selectedStore});

/**
 *  格式化时间显示样式
 * @param val
 */
function dateFormat(val) {
    if (val) return Ext.util.Format.date(new Date(val), "Y年m月d");
    else return "";
}
/**
 * 批准状态
 */
function statusRender(val){
    if(val == 1) return "已批准";
    else return "未批准";

}

/**
 * 查看项目的统计信息
 */
function openStatistics() {
    var type='${type}';
    if(type=="fcp"){
        selectFcpWin.show();
    }
    else
    {
        selectWin.show();
    }
}

var selectFcpWin = Ext.create('Ext.window.Window',{
    title:'选择年份、单位',
    modal:true,
    closable:true,
    closeAction:'hide',
    width:250,
    height:150,
    items:[{
        xtype:'combo',
        fieldLabel:'年份',
        labelWidth:60,
        width:200,
        padding:'5,10,5,0',
        id:'year',
        store:new Ext.data.SimpleStore({
            fields:['year'],
            data:[['2001'],['2002'],['2003'],['2004'],['2005'],['2006'],['2007'],['2008'],['2009'],['2010'],['2011'],['2012'],['2013'],['2014'],['2015'],['2016'],['2017'],['2018'],['2019'],['2020']]
        }),
        displayField:'year',
        queryMode:'local',
        value:'2012',
        valueField:'year'
    },{
        xtype:'combo',
        fieldLabel:'单位',
        labelWidth:60,
        width:200,
        padding:'5,10,5,0',
        id:'unit',
        store:new Ext.data.SimpleStore({
            fields:['unit'],
            data:[['国务院'],['省厅'],['太原市'],['晋源区'],['尖草坪区'],['万柏林区'],['杏花岭区'],['迎泽区'],['小店区']]
        }),
        displayField:'unit',
        queryMode:'local',
        valueField:'unit'

    }],
    bbar:['->',{
        text:'确定',
        handler:function(){
            var year = Ext.getCmp('year').getValue();
            var unit = Ext.getCmp('unit').getValue();
            window.open('pro!statisticsInfo.action?type=${type}' + '&year=' +year + '&unit=' + unit,"_blank");
            selectFcpWin.close();

        }

    },{
        text:'取消',
        handler:function(){
            selectFcpWin.close();

        }
    }]

});

var selectWin = Ext.create('Ext.window.Window', {
    title:'选择批准时间',
    modal:true,
    resizable:true,
    closable:true,
    closeAction:'hide',
    width:235,
    height:120,
    items:[
        {
            padding:'10 0 0 0',
            xtype:'datefield',
            fieldLabel:'开始时间',
            labelWidth:60,
            id:'startTime',
            anchor:'100%',
            format:'Y-m-d',
            value:new Date()

        },
        {
            xtype:'datefield',
            anchor:'100%',
            id:'endTime',
            fieldLabel:'结束时间',
            labelWidth:60,
            format:'Y-m-d',
            value:new Date()
        }
    ],
    bbar:['->', {
        text:'确定',
        handler:function () {
            var starttime = dateFormat2(Ext.getCmp("startTime").getValue());
            var endtime = dateFormat2(Ext.getCmp("endTime").getValue());
            window.open('pro!statisticsInfo.action?type=${type!}' + '&starttime=' + starttime + '&endtime=' + endtime, "_blank");
            selectWin.close();
        }
    }, {
        text:'取消',
        handler:function () {
            selectWin.close();
        }
    }]

});

function dateFormat2(value) {
    if (null != value) {
        return Ext.Date.format(new Date(value), 'Y-m-d H:i:s');
    } else {
        return null;
    }
}

$(function () {
//        debugger;
})

</script>
</@com.proList>