/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.sams.core.entity.AnalysisField;
import com.gtis.sams.core.service.TemplateService;
import com.gtis.sams.core.web.BaseAction;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAction
extends BaseAction {
    @Autowired
    private TemplateService templateService;
    protected String resultStr;
    public List<Map> analysisData;
    public List<AnalysisField> analysisFields;
    protected String type;

    public String analysis() {
        return "analysis";
    }

    public List<Map> getAnalysisData() {
        this.analysisData = new ArrayList();
        Map map = ServletActionContext.getRequest().getParameterMap();
        try {
            this.resultStr = URLDecoder.decode(((String[])map.get("analysisresult"))[0], "UTF-8");
            JSONArray resultJson = JSON.parseArray((String)this.resultStr);
            List fields = this.getAnalysisFields();
            for (int i = 0; i < resultJson.size(); ++i) {
                HashMap<String, Object> analysisMap = new HashMap<String, Object>();
                JSONObject temp = resultJson.getJSONObject(i);
                for (int j = 0; j < fields.size(); ++j) {
                    String field = ((AnalysisField)fields.get(j)).getField();
                    analysisMap.put(field, temp.get((Object)field));
                }
                this.analysisData.add(analysisMap);
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        return this.analysisData;
    }

    public List<Map> getAnalysisData(String str) {
        this.analysisData = new ArrayList();
        try {
            JSONArray resultJson = JSON.parseArray((String)str);
            List fields = this.getAnalysisFields();
            for (int i = 0; i < resultJson.size(); ++i) {
                HashMap<String, Object> analysisMap = new HashMap<String, Object>();
                JSONObject temp = resultJson.getJSONObject(i);
                for (int j = 0; j < fields.size(); ++j) {
                    String field = ((AnalysisField)fields.get(j)).getField();
                    analysisMap.put(field, temp.get((Object)field));
                }
                this.analysisData.add(analysisMap);
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        return this.analysisData;
    }

    public List<AnalysisField> getAnalysisFields() {
        return JSON.parseArray((String)this.templateService.getTemplate(this.getTplName()), AnalysisField.class);
    }

    private String getTplName() {
        if (this.type.equals("fcp")) {
            return "analysis_fcp.json";
        }
        if (this.type.equals("sla")) {
            return "analysis_sla.json";
        }
        if (this.type.equals("sls")) {
            return "analysis_sls.json";
        }
        return "";
    }

    public String exportExcel() throws Exception {
        String jsonStr = ((String[])ServletActionContext.getRequest().getParameterMap().get("param"))[0];
        List fields = this.getAnalysisFields();
        List analysisData = this.getAnalysisData(jsonStr);
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String fileName = "\u9879\u76ee\u5206\u6790\u62a5\u8868.xls";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            int i;
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet("\u9879\u76ee\u5206\u6790\u4fe1\u606f", 0);
            ws.addCell((WritableCell)new Label(0, 0, "\u5e8f\u53f7"));
            for (i = 0; i < fields.size(); ++i) {
                ws.addCell((WritableCell)new Label(i + 1, 0, ((AnalysisField)fields.get(i)).getLabel()));
            }
            for (i = 0; i < analysisData.size(); ++i) {
                Map pro = (Map)analysisData.get(i);
                ws.addCell((WritableCell)new Number(0, i + 1, (double)(i + 1)));
                for (int j = 0; j < fields.size(); ++j) {
                    AnalysisField field = (AnalysisField)fields.get(j);
                    ws.addCell((WritableCell)new Label(j + 1, i + 1, (String)pro.get(field.getField())));
                }
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u8868\u51fa\u9519\uff01", (Object)e.toString());
            System.out.println(e.toString());
        }
        return null;
    }

    public String getResultStr() {
        return this.resultStr;
    }

    public void setResultStr(String resultStr) {
        this.resultStr = resultStr;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

