/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.dao.impl;

import com.gtis.common.Page;
import com.gtis.sams.core.dao.impl.GenericIbatisDao;
import com.gtis.sams.dao.FCPDao;
import com.gtis.sams.vo.FCPVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class FCPDaoImpl
extends GenericIbatisDao<FCPVo, String>
implements FCPDao {
    private static final String FCP_NAMESPACE = "fcp";

    public FCPDaoImpl() {
        this.setSqlmapNamespace(FCP_NAMESPACE);
    }

    public int countByBatchId(String batchId) {
        return (Integer)this.getSqlMapClientTemplate().queryForObject(this.getSqlmapNamespace().concat(".countByBatchId"), (Object)batchId);
    }

    public int countByBatchId(String batchId, Map<String, ?> condition) {
        HashMap conditions = new HashMap(condition);
        conditions.put("batchId", batchId);
        return (Integer)this.getSqlMapClientTemplate().queryForObject(this.getSqlmapNamespace().concat(".countByBatchId"), condition);
    }

    public Page<FCPVo> getPagesByBatchId(String batchId, int start, int limit) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("batchId", batchId);
        Page page = new Page();
        page.setStart(start);
        page.setSize(limit);
        page.setItems(this.getSqlMapClientTemplate().queryForList(this.getSqlmapNamespace().concat(".getPageByBatchId"), condition, start, limit));
        page.setTotalCount(this.countByBatchId(batchId, condition));
        return page;
    }

    public Page<FCPVo> getPagesByBatchId(String batchId, int start, int limit, Map<String, ?> condition) {
        if (condition == null) {
            return this.getPagesByBatchId(batchId, start, limit);
        }
        HashMap conditions = new HashMap(condition);
        conditions.put("batchId", batchId);
        Page page = new Page();
        page.setStart(start);
        page.setSize(limit);
        page.setItems(this.getSqlMapClientTemplate().queryForList(this.getSqlmapNamespace().concat(".getPageByBatchId"), conditions, start, limit));
        page.setTotalCount(this.countByBatchId(batchId, condition));
        return page;
    }

    public List<FCPVo> getStatistic(String startTime, String endTime) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("t1.pzrq >=", startTime);
        condition.put("t1.pzrq <=", endTime);
        condition.put("t1.status =", "1");
        return this.getSqlMapClientTemplate().queryForList(this.getSqlmapNamespace().concat(".getPageByBatchId"), condition);
    }

    public List<FCPVo> getProgressDatas(String id) {
        return this.getSqlMapClientTemplate().queryForList(this.getSqlmapNamespace().concat(".getProgressDatas"), (Object)id);
    }

    public FCPVo getFinalData(String id) {
        return (FCPVo)this.getSqlMapClientTemplate().queryForObject(this.getSqlmapNamespace().concat(".getFinalData"), (Object)id);
    }

    public String getCoords(String id) {
        return (String)this.getSqlMapClientTemplate().queryForObject(this.getSqlmapNamespace().concat(".getCoords"), (Object)id);
    }

    public FCPVo getBasicInfo(String id) {
        return (FCPVo)this.getSqlMapClientTemplate().queryForObject(this.getSqlmapNamespace().concat(".getBasicInfo"), (Object)id);
    }
}

