/**
 * Created with IntelliJ IDEA.
 * User: xunianfeng
 * Date: 12-8-1
 * Time: 下午1:36
 * To change this template use File | Settings | File Templates.
 */

/**
 * 查询左侧拖拉窗体字段store
 */
Ext.define('gtis.store.FieldStore', {
    extend:'Ext.data.Store',
    config:{
        model:'fieldModel',
        autoLoad:true,
        proxy:{
            type:'ajax',
            url:'',
            reader:{
                type:'json'
            }
        }
    },
    constructor:function (config) {
        this.config.proxy.url = config.url;
        this.callParent(arguments);
        this.initConfig(config);
    }
});

/**
 * 查询右侧拖拉窗体Store
 */
Ext.define('gtis.store.SelectedFStore', {
    extend:'Ext.data.Store',
    config:{
        model:'fieldModel'
    }
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit:1
});

/**
 *
 */
Ext.define('gtis.panel.LeftDragPanel', {
    extend:'Ext.grid.Panel',
    bodyStyle:'margin:0px 20px 0px 0px',
    viewConfig:{
        plugins:{
            ptype:'gridviewdragdrop',
            dragGroup:'leftGridGroup',
            dropGroup:'rightGroup'
        },
        listeners:{
            drop:function (node, data, dropRect, dropPos) {
                //
                debugger;
            }
        }
    },
    columns:[
        {
            text:'待检索字段',
            dataIndex:'title',
            width:140
        }
    ],
    multiSelect:false,
    store:null,
    constructor:function (config) {
        debugger;
        this.store = config.store;
        this.callParent(arguments);
        this.initConfig(this.config);
    }
});

/**
 *
 */
Ext.define('gtis.panel.RightDropPanel', {
    extend:'Ext.grid.Panel',
    bodyStyle:{
        padding:'0px 2px 0px 2px'
    },
    viewConfig:{
        plugins:{
            ptype:'gridviewdragdrop',
            dragGroup:'rightGroup',
            dropGroup:'leftGridGroup'
        },
        listeners:{
            drop:function (node, data, dropRect, dropPos) {
            }
        }
    },
    columns:[
        {
            header:'已选字段',
            width:140,
            dataIndex:'title'
        },
        {
            header:'条件',
            dataIndex:'condition',
            width:100,
            editor:new Ext.form.field.ComboBox({
                typeAhead:true,
                triggerAction:'all',
                selectOnTab:true,
                store:[
                    [ 'like', '类似'],
                    [ '=', '等于'],
                    [ '>', '大于'],
                    [ '<', '小于'],
                    [ '!=', '不等于']
                ],
                lazyRender:true,
                listClass:'x-combo-list-small'
            })
        },
        {
            header:'值',
            dataIndex:'value',
            width:140,
            editor:{
                allowBlank:true
            }
        }
    ],
    selModel:{
        selType:'cellmodel'
    },
    multiSelect:false,
    store:null,
    plugins:[
        cellEditing
    ],
    constructor:function (config) {
        debugger;
        this.store = config.store;
        this.callParent(arguments);
        this.initConfig(this.config);
    }
});


/**
 * 添加检索条件
 */
function onAddCondition(e) {
    var conWins = Ext.create("Ext.window.Window", {
        iconCls:'ex_search',
        title:'条件检索',
        modal:true,
        headerPosition:'top',
        plain:true,
        closable:true,
        closeAction:'hide',
        width:600,
        height:400,
        layout:{
            type:'hbox',
            align:'stretch'
        },
        bodyStyle:{
            padding:'5px 5px 10px 5px;'
        },
        items:[
            leftGrid ,
            rightDrop
        ],
        bbar:[
            '->',
            {
                text:'确定',
                handler:function () {
                    debugger;
                    var json = Ext.encode(Ext.pluck(selectedStore.data.items, 'data'));
                    store.load({
                        params:{
                            condition:json
                        }
                    });
                    conWins.close();
                }
            }
        ]

    });
    conWins.show();
}


