<#---->

<#macro html title="" import="">
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8"/>
    <title>${title}</title>
    <#list import?split(",") as lib>
        <#switch lib>
            <#case "base">
                <@script name="js/base.js"></@script>
                <@style name="css/base.css"></@style>
                <#break />
            <#case "main">
                <@script name="js/main.js"></@script>
                <@style name="css/main.css"></@style>
                <#break />
            <#case "ext">
                <@style name="js/ext/resources/css/ext-all-gray.css"></@style>
                <@script name="js/ext/ext-all-dev.js"></@script>
                <@script name="js/ext/ext-lang-zh_CN.js"></@script>
                <#break />
            <#case "jquery">
                <@script name="js/jquery/jquery-1.7.2.min.js"></@script>
                <@script name="js/jquery/jquery.blockUI.js"></@script>
                <@script name="js/jquery/My97DatePicker/WdatePicker.js"></@script>
                <#break />
            <#case "swf">
                <@script name="js/swfobject.js"></@script>
                <#break />
            <#default>
                <@script name="js/${lib}.js"></@script>
                <@style name="css/${lib}.css"></@style>
        </#switch>
    </#list>
</head>
<body>
    <#nested />
</body>
</html>
</#macro>

<#macro index theme="lanxy">
    <@html title="太原测绘成果管理系统" import="ext,jquery,base,${theme}">
    <div id="mainContainer">
        <#nested />
    </div>
    </@html>
</#macro>

<#---->
<#macro main title="太原测绘成果管理系统" import="">
    <@html title=title import="${import},base,lanxy">
    <div id="mainContainer">
        <div id="header">
            <ul>
                <li class="home"><a href="index.action">主页</a></li>
            </ul>
        </div>
        <div id="mainBody">
            <#nested />
        </div>
        <div id="footer">&copy;2012 太原测绘成果管理系统</div>
    </div>
    </@html>
</#macro>

<#macro proList title="太原测绘成果管理系统" import="">
    <@html title=title import="${import},base,lanxy">
    <div id="mainContainer">
        <div id="header">
            <ul>
                <li class="home"><a href="index.action">主页</a></li>
            </ul>
        </div>
        <div id="mainBody">
            <#nested />
        </div>
    </div>
    </@html>
</#macro>

<#macro basic>
    <@html title="太原测绘成果管理系统" import="ext,jquery,base">
    <div id="mainContainer">
        <#nested />
    </div>
    </@html>
</#macro>

<#macro mainbox>
<div class="mainbox">
    <div class="top">
        <div class="title"><a>${getProCNName('${type}')}列表</a></div>
    </div>
    <div class="mid" >
        <div id="main_box_content" >
        </div>
    </div>
    <div class="bottom">
        <div class="content">&copy;2012 太原测绘成果管理系统</div>
    </div>
</div>
</#macro>

<#-- 显示项目grid的字段-->
<#macro showFields type="">
    <#switch type>
        <#case "fcp">
            <@model.fcpFields></@model.fcpFields>
            <#break />
        <#case "sls">
            <@model.slsFields></@model.slsFields>
            <#break />
        <#case "sla">
            <@model.slaFields></@model.slaFields>
            <#break />
        <#case "sp">
            <@model.spFields></@model.spFields>
            <#break />
    </#switch>
</#macro>

<#--数据模型-->
<#macro dataModel type="">
    <#switch type>
        <#case "fcp">
        'fcpModel'
            <#break />
        <#case "sla">
        'slaModel'
            <#break />
        <#case "sls">
        'slsModel'
            <#break />
        <#case "sp">
        'spModel'
            <#break />
    </#switch>
</#macro>

<#macro basicInfo type="">
    <#switch type>
        <#case "fcb">
            <@model.fcbInfo></@model.fcbInfo>
            <#break />
        <#case "fcp">
            <@model.fcpInfo></@model.fcpInfo>
            <#break />
        <#case "sla">
            <@model.slaInfo></@model.slaInfo>
            <#break />
        <#case "sls">
            <@model.slsInfo></@model.slsInfo>
            <#break />
        <#case "sp">
            <@model.spInfo></@model.spInfo>
            <#break />
    </#switch>
</#macro>
<!-- 统计分析表字段-->
<#macro statisticInfo type="">
<#switch type>
    <#case "fcb">
        <@model.fcbStatistic></@model.fcbStatistic>
        <#break />
    <#case "fcp">
        <@model.fcpStatistic></@model.fcpStatistic>
        <#break />
    <#case "sla">
        <@model.slaStatistic></@model.slaStatistic>
        <#break />
    <#case "sls">
        <@model.slsStatistic></@model.slsStatistic>
        <#break />
    <#case "sp">
        <@model.spStatistic></@model.spStatistic>
        <#break />
</#switch>

</#macro>


<#---->
<#macro script name>
<script src="${base}/${name}" type="text/javascript"></script>
</#macro>

<#macro style name>
<link href="${base}/${name}" type="text/css" media="screen" rel="stylesheet"/>
</#macro>

<#function getProCNName type>
    <#switch type>
        <#case "fcb">
            <#return "农转业务批次">
        <#case "fcp">
            <#return "农转项目">
        <#case "sls">
            <#return "供地业务">
        <#case "sla">
            <#return "征地业务">
    </#switch>
</#function>