<@com.proList import="ext,jquery">
<div id="top">

</div>
    <@com.mainbox></@com.mainbox>

<script type="text/javascript">
var type = '${type}', store, gridPanel;

Ext.onReady(function () {
    Ext.QuickTips.init();

    store = new Ext.data.Store({
        pageSize:20,
        model:'baseBtModel',
        proxy:{
            type:'ajax',
            url:'batch!list.action?type=${type}',
            reader:{
                type:'json',
                root:'items',
                totalProperty:'totalCount'
            }
        },
        autoLoad:true
    });

    gridPanel = new Ext.grid.Panel({
        title:"批次列表",
        height:400,
        store:store,
        stateful:true,
        multiSelect:false,
        columns:[
            {text:'项目名称', dataIndex:'proName', width:200},
            {text:'批准文号', dataIndex:'approvalNo', width:200},
            {text:'项目面积', dataIndex:'proArea', width:200}
        ],
        selModel:new Ext.selection.CheckboxModel(),
        renderTo:'main_box_content',
        viewConfig:{
            stripeRows:true
        },
        dockedItems:[
            {
                xtype:'toolbar',
                id:'gpToolBar',
                items:[
                    {
                        text:"批次详细信息",
                        iconCls:"ex_detail",
                        handler:function () {
                            if (getSelection()) {
                                var item = getSelection();
                                var id = item.get('id');
                                openBartchInfo(id);
                            } else {
                                Ext.MessageBox.show({
                                    title:'提示',
                                    msg:'请先选择某一项',
                                    buttons:Ext.MessageBox.OK
                                });
                            }
                        }
                    },
                    {
                        text:"进入项目列表",
                        iconCls:"ex_prolist",
                        handler:function () {
                            if (getSelection()) {
                                var item = getSelection();
                                var id = item.get('id');
                                openProList(id);
                            } else {
                                Ext.MessageBox.show({
                                    title:'提示',
                                    msg:'请先选择某一项',
                                    buttons:Ext.MessageBox.OK
                                });
                            }
                        }
                    }
//                    {
//                        text:"查看统计信息",
//                        iconCls:"ex_static",
//                        handler:function () {
//                            openStatistics();
//                        }
//
//
//                   }
                    ,
                    '-',
                    {
                        xtype:'textfield',
                        name:'searchField',
                        hideLabel:true,
                        width:130,
                        listeners:{
                            change:function(){
                                onSearch(gridPanel);
                            }
                        }
                    },
                    {
                        xtype:'button',
                        text:'条件检索',
                        iconCls:'ex_search',
                        handler:function (e) {
                            onAddCondition(e);
                        }
                    }
                ]
            },
            {
                xtype:'pagingtoolbar',
                pageSize:20,
                store:store,
                dock:'bottom',
                displayInfo:true,
                displayMsg:'{0}-{1}共{2}条',
                emptyMsg:"尚未检测到数据"
            }
        ],
        listeners:{
            itemdblclick:function (grid, item, row) {
                debugger;
                openProList(item.get('id'));
            }
        }

    });

    /////////////


});


/**
 *  获取grid选择项
 */
function getSelection() {
    return gridPanel.getSelectionModel().getSelection()[0];
}

/**
 * 打开批次相关信息
 * @param id
 */
function openBartchInfo(id) {
    window.open('batch!detail.action?type=${type!}&id=' + id, "_blank");

}

/**
 * 打开批次相关的项目列表
 * @param id
 */
function openProList(id) {
    window.open('pro.action?type=${proType}&id=' + id, "_blank");
}
/**
 * 查看项目的统计信息
 */
function openStatistics() {
    selectWin.show();
}
var selectWin = Ext.create('Ext.window.Window', {
    title:'选择批准时间',
    modal:true,
    resizable:true,
    closable:true,
    closeAction:'hide',
    width:235,
    height:120,
    items:[
        {
            padding:'10 0 0 0',
            xtype:'datefield',
            fieldLabel:'开始时间',
            labelWidth:60,
            id:'startTime',
            anchor:'100%',
            format:'Y-m-d',
            value:new Date()

        },
        {
            xtype:'datefield',
            anchor:'100%',
            id:'endTime',
            fieldLabel:'结束时间',
            labelWidth:60,
            format:'Y-m-d',
            value:new Date()
        }
    ],
    bbar:['->', {
        text:'确定',
        handler:function () {
            var starttime = dateFormat2(Ext.getCmp("startTime").getValue());
            var endtime = dateFormat2(Ext.getCmp("endTime").getValue());
            window.open('pro!statisticsInfo.action?type=${proType!}' + '&starttime=' + starttime + '&endtime=' + endtime, "_blank");
            selectWin.close();
        }
    }, {
        text:'取消',
        handler:function () {
            selectWin.close();
        }
    }]

});

function dateFormat2(value) {
    if (null != value) {
        return Ext.Date.format(new Date(value), 'Y-m-d H:i:s');
    } else {
        return null;
    }
}


/**
 *
 * @type {*}
 */
var fieldsStore = Ext.create('gtis.store.FieldStore', {
    url:'batch!fields.action?type=${type}'
});

var selectedStore = Ext.create('gtis.store.SelectedFStore', {});

var leftGrid = Ext.create('gtis.panel.LeftDragPanel', {store:fieldsStore});

var rightDrop = Ext.create('gtis.panel.RightDropPanel', {store:selectedStore});


$(function () {
//        debugger;
})

</script>
</@com.proList>