/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.sams.core.web.BaseAction;
import com.gtis.sams.vo.base.BaseProVo;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.struts2.ServletActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAction
extends BaseAction {
    protected String resultStr;
    public List<BaseProVo> analysisData;

    public String analysis() {
        Map map = ServletActionContext.getRequest().getParameterMap();
        try {
            this.analysisData = new ArrayList();
            this.resultStr = URLDecoder.decode(((String[])map.get("analysisresult"))[0], "UTF-8");
            this.analysisData = this.getAnalysisData(this.resultStr);
        }
        catch (Exception ex) {
            this.logger.error(ex.toString());
        }
        return "analysis";
    }

    public List<BaseProVo> getAnalysisData(String str) {
        ArrayList<BaseProVo> proVoList = new ArrayList<BaseProVo>();
        try {
            JSONArray resultJson = JSON.parseArray((String)str);
            for (int i = 0; i < resultJson.size(); ++i) {
                JSONObject temp = resultJson.getJSONObject(i);
                BaseProVo vo = new BaseProVo();
                vo.setBsm(temp.get((Object)"BSM").toString());
                vo.setApprovalNo(temp.get((Object)"PZWH").toString());
                vo.setBz(temp.get((Object)"BZ").toString());
                vo.setSsqy(temp.get((Object)"SSQY").toString());
                vo.setAddress(temp.get((Object)"ZLDWMC").toString());
                proVoList.add(vo);
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        return proVoList;
    }

    public String exportExcel() throws Exception {
        String jsonStr = ((String[])ServletActionContext.getRequest().getParameterMap().get("param"))[0];
        this.analysisData = this.getAnalysisData(jsonStr);
        ServletActionContext.getResponse().setContentType("application/vnd.ms-excel");
        String fileName = "\u9879\u76ee\u5206\u6790\u62a5\u8868.xls";
        ServletActionContext.getResponse().setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
        try {
            ServletOutputStream os = ServletActionContext.getResponse().getOutputStream();
            WritableWorkbook wb = Workbook.createWorkbook((OutputStream)os);
            WritableSheet ws = wb.createSheet("\u9879\u76ee\u5206\u6790\u4fe1\u606f", 0);
            ws.addCell((WritableCell)new Label(0, 0, "\u5e8f\u53f7"));
            ws.addCell((WritableCell)new Label(1, 0, "\u6807\u8bc6\u7801"));
            ws.addCell((WritableCell)new Label(2, 0, "\u6279\u51c6\u6587\u53f7"));
            ws.addCell((WritableCell)new Label(3, 0, "\u6240\u5c5e\u533a\u57df"));
            ws.addCell((WritableCell)new Label(4, 0, "\u571f\u5730\u5750\u843d"));
            ws.addCell((WritableCell)new Label(5, 0, "\u5907\u6ce8"));
            BaseProVo proVo = new BaseProVo();
            for (int i = 0; i < this.analysisData.size(); ++i) {
                proVo = (BaseProVo)this.analysisData.get(i);
                ws.addCell((WritableCell)new Number(0, i + 1, (double)(i + 1)));
                ws.addCell((WritableCell)new Label(1, i + 1, proVo.getBsm()));
                ws.addCell((WritableCell)new Label(2, i + 1, proVo.getApprovalNo()));
                ws.addCell((WritableCell)new Label(3, i + 1, proVo.getSsqy()));
                ws.addCell((WritableCell)new Label(4, i + 1, proVo.getAddress()));
                ws.addCell((WritableCell)new Label(5, i + 1, proVo.getBz()));
            }
            wb.write();
            wb.close();
            os.close();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faexcel\u8868\u51fa\u9519\uff01", (Object)e.toString());
            System.out.println(e.toString());
        }
        return null;
    }

    public String getResultStr() {
        return this.resultStr;
    }

    public void setResultStr(String resultStr) {
        this.resultStr = resultStr;
    }

    public List<BaseProVo> getAnalysisData() {
        return this.analysisData;
    }
}

